/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.codecs;

import io.vertx.core.buffer.Buffer;
import io.vertx.core.eventbus.MessageCodec;
import io.vertx.core.eventbus.impl.CodecManager;
import org.apache.cassandra.sidecar.client.SidecarInstance;
import org.apache.cassandra.sidecar.client.SidecarInstanceImpl;

public class SidecarInstanceCodec<T extends SidecarInstance>
implements MessageCodec<T, SidecarInstance> {
    public void encodeToWire(Buffer buf, T instance) {
        buf.appendInt(instance.port());
        CodecManager.STRING_MESSAGE_CODEC.encodeToWire(buf, (Object)instance.hostname());
    }

    public SidecarInstance decodeFromWire(int pos, Buffer buf) {
        int port = buf.getInt(pos);
        return new SidecarInstanceImpl((String)CodecManager.STRING_MESSAGE_CODEC.decodeFromWire(pos += 4, buf), port);
    }

    public SidecarInstance transform(T instance) {
        return new SidecarInstanceImpl(instance.hostname(), instance.port());
    }

    public String name() {
        return "SidecarInstance";
    }

    public byte systemCodecID() {
        return -1;
    }
}

