/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.auth.oauth2;

import io.vertx.codegen.annotations.Fluent;
import io.vertx.codegen.annotations.VertxGen;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.User;
import io.vertx.ext.auth.authentication.AuthenticationProvider;
import io.vertx.ext.auth.oauth2.OAuth2AuthorizationURL;
import io.vertx.ext.auth.oauth2.OAuth2Options;
import io.vertx.ext.auth.oauth2.impl.OAuth2AuthProviderImpl;

@VertxGen
public interface OAuth2Auth
extends AuthenticationProvider {
    public static OAuth2Auth create(Vertx vertx) {
        return OAuth2Auth.create(vertx, new OAuth2Options());
    }

    public static OAuth2Auth create(Vertx vertx, OAuth2Options config) {
        return new OAuth2AuthProviderImpl(vertx, config);
    }

    @Fluent
    default public OAuth2Auth jWKSet(Handler<AsyncResult<Void>> handler) {
        this.jWKSet().onComplete(handler);
        return this;
    }

    public Future<Void> jWKSet();

    @Fluent
    public OAuth2Auth missingKeyHandler(Handler<String> var1);

    @Deprecated
    public String authorizeURL(JsonObject var1);

    public String authorizeURL(OAuth2AuthorizationURL var1);

    @Fluent
    default public OAuth2Auth refresh(User user, Handler<AsyncResult<User>> handler) {
        this.refresh(user).onComplete(handler);
        return this;
    }

    public Future<User> refresh(User var1);

    @Fluent
    default public OAuth2Auth revoke(User user, String tokenType, Handler<AsyncResult<Void>> handler) {
        this.revoke(user, tokenType).onComplete(handler);
        return this;
    }

    @Fluent
    default public OAuth2Auth revoke(User user, Handler<AsyncResult<Void>> handler) {
        this.revoke(user, "access_token").onComplete(handler);
        return this;
    }

    public Future<Void> revoke(User var1, String var2);

    default public Future<Void> revoke(User user) {
        return this.revoke(user, "access_token");
    }

    @Fluent
    default public OAuth2Auth userInfo(User user, Handler<AsyncResult<JsonObject>> handler) {
        this.userInfo(user).onComplete(handler);
        return this;
    }

    public Future<JsonObject> userInfo(User var1);

    public String endSessionURL(User var1, JsonObject var2);

    default public String endSessionURL(User user) {
        return this.endSessionURL(user, new JsonObject());
    }

    public void close();
}

