/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.location;

import com.google.common.base.Optional;
import java.util.Map;
import org.apache.brooklyn.api.location.MachineDetails;
import org.apache.brooklyn.api.location.MachineLocation;
import org.apache.brooklyn.api.location.OsDetails;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.core.location.AbstractLocation;
import org.apache.brooklyn.core.location.BasicHardwareDetails;
import org.apache.brooklyn.core.location.BasicMachineDetails;
import org.apache.brooklyn.core.location.BasicOsDetails;
import org.apache.brooklyn.util.collections.MutableMap;
import org.apache.brooklyn.util.core.mutex.MutexSupport;
import org.apache.brooklyn.util.core.mutex.WithMutexes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMachineLocation
extends AbstractLocation
implements MachineLocation {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractMachineLocation.class);
    public static final ConfigKey<MachineDetails> MACHINE_DETAILS = ConfigKeys.newConfigKey(MachineDetails.class, "machineDetails");
    public static final ConfigKey<Boolean> DETECT_MACHINE_DETAILS = ConfigKeys.newBooleanConfigKey("detectMachineDetails", "Attempt to detect machine details automatically.", true);
    protected static final MachineDetails UNKNOWN_MACHINE_DETAILS = new BasicMachineDetails(new BasicHardwareDetails(-1, -1), new BasicOsDetails("UNKNOWN", "UNKNOWN", "UNKNOWN"));
    private volatile MachineDetails machineDetails;
    private final Object machineDetailsLock = new Object();
    private transient WithMutexes mutexSupport;
    private final transient Object mutexSupportCreationLock = new Object();

    public AbstractMachineLocation() {
        this((Map<?, ?>)MutableMap.of());
    }

    public AbstractMachineLocation(Map<?, ?> properties) {
        super(properties);
    }

    protected Optional<MachineDetails> getOptionalMachineDetails() {
        MachineDetails result = this.machineDetails != null ? this.machineDetails : (MachineDetails)this.config().get(MACHINE_DETAILS);
        return Optional.fromNullable((Object)result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MachineDetails getMachineDetails() {
        Object object = this.machineDetailsLock;
        synchronized (object) {
            if (this.machineDetails == null) {
                this.machineDetails = this.getConfig(MACHINE_DETAILS);
                if (this.machineDetails != null) {
                    LOG.debug("Location {} using machine-details from config: {}", (Object)this, (Object)this.machineDetails);
                }
            }
            if (this.machineDetails == null) {
                boolean detectionEnabled = this.getConfig(DETECT_MACHINE_DETAILS);
                if (!detectionEnabled || !this.isManaged()) {
                    return UNKNOWN_MACHINE_DETAILS;
                }
                this.machineDetails = this.detectMachineDetails();
            }
            return this.machineDetails;
        }
    }

    public OsDetails getOsDetails() {
        return this.getMachineDetails().getOsDetails();
    }

    protected abstract MachineDetails detectMachineDetails();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WithMutexes mutexes() {
        Object object = this.mutexSupportCreationLock;
        synchronized (object) {
            if (this.mutexSupport == null) {
                this.mutexSupport = new MutexSupport();
            }
            return this.mutexSupport;
        }
    }
}

