/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azurecompute.arm.domain.vpn;

import org.jclouds.azurecompute.arm.domain.AddressSpace;
import org.jclouds.azurecompute.arm.domain.vpn.AutoValue_IPSecPolicy;
import org.jclouds.azurecompute.arm.domain.vpn.DHGroup;
import org.jclouds.azurecompute.arm.domain.vpn.IPSecEncryption;
import org.jclouds.azurecompute.arm.domain.vpn.IPSecIntegrity;
import org.jclouds.azurecompute.arm.domain.vpn.IkeEncryption;
import org.jclouds.azurecompute.arm.domain.vpn.IkeIntegrity;
import org.jclouds.azurecompute.arm.domain.vpn.PFSGroup;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.json.SerializedNames;

public abstract class IPSecPolicy {
    @Nullable
    public abstract String radiusServerAddress();

    @Nullable
    public abstract String radiusServerSecret();

    @Nullable
    public abstract AddressSpace vpnClientAddressPool();

    @Nullable
    public abstract DHGroup dhGroup();

    @Nullable
    public abstract IkeEncryption ikeEncryption();

    @Nullable
    public abstract IkeIntegrity ikeIntegrity();

    @Nullable
    public abstract IPSecEncryption ipsecEncryption();

    @Nullable
    public abstract IPSecIntegrity ipsecIntegrity();

    @Nullable
    public abstract PFSGroup pfsGroup();

    @Nullable
    public abstract Integer saDataSizeKilobytes();

    @Nullable
    public abstract Integer saLifeTimeSeconds();

    IPSecPolicy() {
    }

    @SerializedNames(value={"radiusServerAddress", "radiusServerSecret", "vpnClientAddressPool", "dhGroup", "ikeEncryption", "ikeIntegrity", "ipsecEncryption", "ipsecIntegrity", "pfsGroup", "saDataSizeKilobytes", "saLifeTimeSeconds"})
    public static IPSecPolicy create(String radiusServerAddress, String radiusServerSecret, AddressSpace vpnClientAddressPool, DHGroup dhGroup, IkeEncryption ikeEncryption, IkeIntegrity ikeIntegrity, IPSecEncryption ipsecEncryption, IPSecIntegrity ipsecIntegrity, PFSGroup pfsGroup, Integer saDataSizeKilobytes, Integer saLifeTimeSeconds) {
        return IPSecPolicy.builder().radiusServerAddress(radiusServerAddress).radiusServerSecret(radiusServerSecret).vpnClientAddressPool(vpnClientAddressPool).dhGroup(dhGroup).ikeEncryption(ikeEncryption).ikeIntegrity(ikeIntegrity).ipsecEncryption(ipsecEncryption).ipsecIntegrity(ipsecIntegrity).pfsGroup(pfsGroup).saDataSizeKilobytes(saDataSizeKilobytes).saLifeTimeSeconds(saLifeTimeSeconds).build();
    }

    public static Builder builder() {
        return new AutoValue_IPSecPolicy.Builder();
    }

    public abstract Builder toBuilder();

    public static abstract class Builder {
        public abstract Builder radiusServerAddress(String var1);

        public abstract Builder radiusServerSecret(String var1);

        public abstract Builder vpnClientAddressPool(AddressSpace var1);

        public abstract Builder dhGroup(DHGroup var1);

        public abstract Builder ikeEncryption(IkeEncryption var1);

        public abstract Builder ikeIntegrity(IkeIntegrity var1);

        public abstract Builder ipsecEncryption(IPSecEncryption var1);

        public abstract Builder ipsecIntegrity(IPSecIntegrity var1);

        public abstract Builder pfsGroup(PFSGroup var1);

        public abstract Builder saDataSizeKilobytes(Integer var1);

        public abstract Builder saLifeTimeSeconds(Integer var1);

        public abstract IPSecPolicy build();
    }
}

