/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.enricher.stock;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.reflect.TypeToken;
import java.util.Collection;
import java.util.Set;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.entity.EntityLocal;
import org.apache.brooklyn.api.entity.Group;
import org.apache.brooklyn.api.sensor.Sensor;
import org.apache.brooklyn.api.sensor.SensorEvent;
import org.apache.brooklyn.api.sensor.SensorEventListener;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.core.enricher.AbstractEnricher;
import org.apache.brooklyn.core.entity.AbstractEntity;
import org.apache.brooklyn.core.entity.trait.Changeable;
import org.apache.brooklyn.util.collections.MutableList;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.guava.Maybe;
import org.apache.brooklyn.util.text.StringPredicates;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractAggregator<T, U>
extends AbstractEnricher
implements SensorEventListener<T> {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractAggregator.class);
    public static final ConfigKey<Entity> PRODUCER = ConfigKeys.newConfigKey(Entity.class, "enricher.producer", "The entity whose children/members will be aggregated");
    public static final ConfigKey<Sensor<?>> TARGET_SENSOR = ConfigKeys.newConfigKey(new TypeToken<Sensor<?>>(){}, "enricher.targetSensor", "The sensor to be set on the associated entity with the value computed here");
    public static final ConfigKey<?> DEFAULT_MEMBER_VALUE = ConfigKeys.newConfigKey(Object.class, "enricher.defaultMemberValue", "The value to use for a new producer if its source sensor is null");
    public static final ConfigKey<Set<? extends Entity>> FROM_HARDCODED_PRODUCERS = ConfigKeys.newConfigKey(new TypeToken<Set<? extends Entity>>(){}, "enricher.aggregating.fromHardcodedProducers", "The producers to be aggregated (this an alternative way of configuring it, rather than using members or children)");
    public static final ConfigKey<Boolean> FROM_MEMBERS = ConfigKeys.newBooleanConfigKey("enricher.aggregating.fromMembers", "Whether this enricher looks at members; only supported if a Group producer is supplier; defaults to true for Group entities");
    public static final ConfigKey<Boolean> FROM_CHILDREN = ConfigKeys.newBooleanConfigKey("enricher.aggregating.fromChildren", "Whether this enricher looks at children; this is the default for non-Group producers");
    public static final ConfigKey<Predicate<? super Entity>> ENTITY_FILTER = ConfigKeys.newConfigKey(new TypeToken<Predicate<? super Entity>>(){}, "enricher.aggregating.entityFilter", "A filter of the possible producers");
    public static final ConfigKey<Predicate<?>> VALUE_FILTER = ConfigKeys.newConfigKey(new TypeToken<Predicate<?>>(){}, "enricher.aggregating.valueFilter", "A filter of the possible producers, based on their sensor value");
    public static final ConfigKey<Boolean> EXCLUDE_BLANK = ConfigKeys.newBooleanConfigKey("enricher.aggregator.excludeBlank", "Whether explicit nulls or blank strings should be excluded (default false); may only apply if no value filter set", false);
    protected Entity producer;
    protected Sensor<U> targetSensor;
    protected T defaultMemberValue;
    protected Set<? extends Entity> fromHardcodedProducers;
    protected Boolean fromMembers;
    protected Boolean fromChildren;
    protected Predicate<? super Entity> entityFilter;
    protected Predicate<? super T> valueFilter;

    @Override
    public void setEntity(EntityLocal entity) {
        super.setEntity(entity);
        this.setEntityLoadingConfig();
        if (this.fromHardcodedProducers == null && this.producer == null) {
            this.producer = entity;
        }
        Preconditions.checkState((boolean)(this.fromHardcodedProducers != null ^ this.producer != null), (String)"must specify one of %s (%s) or %s (%s)", (Object[])new Object[]{PRODUCER.getName(), this.producer, FROM_HARDCODED_PRODUCERS.getName(), this.fromHardcodedProducers});
        MutableList producers = MutableList.of();
        if (this.fromHardcodedProducers != null) {
            for (Entity producer : Iterables.filter(this.fromHardcodedProducers, this.entityFilter)) {
                producers.add(producer);
                this.addProducerHardcoded(producer);
            }
        }
        if (this.isAggregatingMembers()) {
            producers.add(0, "members");
            this.setEntityBeforeSubscribingProducerMemberEvents(entity);
            this.setEntitySubscribeProducerMemberEvents();
            this.setEntityAfterSubscribingProducerMemberEvents();
        }
        if (this.isAggregatingChildren()) {
            producers.add(0, "children");
            this.setEntityBeforeSubscribingProducerChildrenEvents();
            this.setEntitySubscribingProducerChildrenEvents();
            this.setEntityAfterSubscribingProducerChildrenEvents();
        }
        this.highlightTriggers(this.getSourceSensors(), producers);
        this.onUpdated();
    }

    protected void setEntityLoadingConfig() {
        this.producer = this.getConfig(PRODUCER);
        this.fromHardcodedProducers = this.getConfig(FROM_HARDCODED_PRODUCERS);
        this.defaultMemberValue = this.getConfig(DEFAULT_MEMBER_VALUE);
        this.fromMembers = (Boolean)Maybe.fromNullable((Object)this.getConfig(FROM_MEMBERS)).or((Object)this.fromMembers);
        this.fromChildren = (Boolean)Maybe.fromNullable((Object)this.getConfig(FROM_CHILDREN)).or((Object)this.fromChildren);
        this.entityFilter = this.getConfig(ENTITY_FILTER) == null ? Predicates.alwaysTrue() : this.getConfig(ENTITY_FILTER);
        this.valueFilter = this.getConfig(VALUE_FILTER) == null ? this.getDefaultValueFilter() : this.getConfig(VALUE_FILTER);
        this.setEntityLoadingTargetConfig();
    }

    protected abstract Collection<Sensor<?>> getSourceSensors();

    protected Predicate<?> getDefaultValueFilter() {
        if (this.getConfig(EXCLUDE_BLANK).booleanValue()) {
            return StringPredicates.isNonBlank();
        }
        return Predicates.alwaysTrue();
    }

    protected void setEntityLoadingTargetConfig() {
        this.targetSensor = this.getRequiredConfig(TARGET_SENSOR);
    }

    protected void setEntityBeforeSubscribingProducerMemberEvents(EntityLocal entity) {
        Preconditions.checkState((boolean)(this.producer instanceof Group), (String)"Producer must be a group when fromMembers true: producer=%s; entity=%s; hardcodedProducers=%s", (Object[])new Object[]{this.getConfig(PRODUCER), entity, this.fromHardcodedProducers});
    }

    protected void setEntitySubscribeProducerMemberEvents() {
        this.subscriptions().subscribe(this.producer, Changeable.MEMBER_ADDED, new SensorEventListener<Entity>(){

            public void onEvent(SensorEvent<Entity> event) {
                if (AbstractAggregator.this.entityFilter.apply(event.getValue())) {
                    AbstractAggregator.this.addProducerMember((Entity)event.getValue());
                    AbstractAggregator.this.onUpdated();
                }
            }
        });
        this.subscriptions().subscribe(this.producer, Changeable.MEMBER_REMOVED, new SensorEventListener<Entity>(){

            public void onEvent(SensorEvent<Entity> event) {
                AbstractAggregator.this.removeProducer((Entity)event.getValue());
                AbstractAggregator.this.onUpdated();
            }
        });
    }

    protected void setEntityAfterSubscribingProducerMemberEvents() {
        if (this.producer instanceof Group) {
            for (Entity member : Iterables.filter((Iterable)((Group)this.producer).getMembers(), this.entityFilter)) {
                this.addProducerMember(member);
            }
        }
    }

    protected void setEntityBeforeSubscribingProducerChildrenEvents() {
    }

    protected void setEntitySubscribingProducerChildrenEvents() {
        this.subscriptions().subscribe(this.producer, AbstractEntity.CHILD_REMOVED, new SensorEventListener<Entity>(){

            public void onEvent(SensorEvent<Entity> event) {
                AbstractAggregator.this.removeProducer((Entity)event.getValue());
                AbstractAggregator.this.onUpdated();
            }
        });
        this.subscriptions().subscribe(this.producer, AbstractEntity.CHILD_ADDED, new SensorEventListener<Entity>(){

            public void onEvent(SensorEvent<Entity> event) {
                if (AbstractAggregator.this.entityFilter.apply(event.getValue())) {
                    AbstractAggregator.this.addProducerChild((Entity)event.getValue());
                    AbstractAggregator.this.onUpdated();
                }
            }
        });
    }

    protected void setEntityAfterSubscribingProducerChildrenEvents() {
        for (Entity child : Iterables.filter((Iterable)this.producer.getChildren(), this.entityFilter)) {
            this.addProducerChild(child);
        }
    }

    protected boolean isAggregatingMembers() {
        if (Boolean.TRUE.equals(this.fromMembers)) {
            return true;
        }
        if (Boolean.TRUE.equals(this.fromChildren)) {
            return false;
        }
        if (this.fromHardcodedProducers != null) {
            return false;
        }
        return this.producer instanceof Group;
    }

    protected boolean isAggregatingChildren() {
        if (Boolean.TRUE.equals(this.fromChildren)) {
            return true;
        }
        if (Boolean.TRUE.equals(this.fromMembers)) {
            return false;
        }
        if (this.fromHardcodedProducers != null) {
            return false;
        }
        return !(this.producer instanceof Group);
    }

    protected abstract void addProducerHardcoded(Entity var1);

    protected abstract void addProducerMember(Entity var1);

    protected abstract void addProducerChild(Entity var1);

    protected void removeProducer(Entity producer) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} stopped listening to {}", new Object[]{this, producer});
        }
        this.subscriptions().unsubscribe(producer);
        this.onProducerRemoved(producer);
    }

    protected abstract void onProducerAdded(Entity var1);

    protected abstract void onProducerRemoved(Entity var1);

    protected void onUpdated() {
        try {
            this.emit(this.targetSensor, this.compute());
        }
        catch (Throwable t) {
            LOG.warn("Error calculating and setting aggregate for enricher " + this, t);
            throw Exceptions.propagate((Throwable)t);
        }
    }

    protected abstract Object compute();
}

