/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.mgmt.internal;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.apache.brooklyn.api.location.Location;
import org.apache.brooklyn.api.location.LocationSpec;
import org.apache.brooklyn.api.mgmt.ManagementContext;
import org.apache.brooklyn.api.objs.BrooklynObject;
import org.apache.brooklyn.core.mgmt.internal.LocationManagerInternal;
import org.apache.brooklyn.core.mgmt.internal.ManagementTransitionMode;
import org.apache.brooklyn.core.mgmt.internal.NonDeploymentManagementContext;

public class NonDeploymentLocationManager
implements LocationManagerInternal {
    private final ManagementContext initialManagementContext;

    public NonDeploymentLocationManager(ManagementContext initialManagementContext) {
        this.initialManagementContext = initialManagementContext;
    }

    public <T extends Location> T createLocation(LocationSpec<T> spec) {
        if (this.isInitialManagementContextReal()) {
            return (T)this.initialManagementContext.getLocationManager().createLocation(spec);
        }
        throw new IllegalStateException("Non-deployment context " + this + " is not valid for this operation: cannot create " + spec);
    }

    public <T extends Location> T createLocation(Map<?, ?> config, Class<T> type) {
        if (this.isInitialManagementContextReal()) {
            return (T)this.initialManagementContext.getLocationManager().createLocation(config, type);
        }
        throw new IllegalStateException("Non-deployment context " + this + " is not valid for this operation: cannot create " + type);
    }

    public Collection<Location> getLocations() {
        if (this.isInitialManagementContextReal()) {
            return this.initialManagementContext.getLocationManager().getLocations();
        }
        return Collections.emptyList();
    }

    public Location getLocation(String id) {
        if (this.isInitialManagementContextReal()) {
            return this.initialManagementContext.getLocationManager().getLocation(id);
        }
        return null;
    }

    @Override
    public Iterable<String> getLocationIds() {
        if (this.isInitialManagementContextReal()) {
            return ((LocationManagerInternal)this.initialManagementContext.getLocationManager()).getLocationIds();
        }
        return Collections.emptyList();
    }

    public boolean isManaged(Location loc) {
        return false;
    }

    @Override
    public void manageRebindedRoot(Location loc) {
        if (!this.isInitialManagementContextReal()) {
            throw new IllegalStateException("Non-deployment context " + this + " is not valid for this operation: cannot manage " + loc);
        }
        ((LocationManagerInternal)this.initialManagementContext.getLocationManager()).manageRebindedRoot((BrooklynObject)loc);
    }

    @Deprecated
    public Location manage(Location loc) {
        if (this.isInitialManagementContextReal()) {
            return this.initialManagementContext.getLocationManager().manage(loc);
        }
        throw new IllegalStateException("Non-deployment context " + this + " is not valid for this operation: cannot manage " + loc);
    }

    @Override
    public ManagementTransitionMode getLastManagementTransitionMode(String itemId) {
        if (this.isInitialManagementContextReal()) {
            return ((LocationManagerInternal)this.initialManagementContext.getLocationManager()).getLastManagementTransitionMode(itemId);
        }
        throw new IllegalStateException("Non-deployment context " + this + " is not valid for this operation");
    }

    @Override
    public void setManagementTransitionMode(Location item, ManagementTransitionMode mode) {
        if (!this.isInitialManagementContextReal()) {
            throw new IllegalStateException("Non-deployment context " + this + " is not valid for this operation");
        }
        ((LocationManagerInternal)this.initialManagementContext.getLocationManager()).setManagementTransitionMode((BrooklynObject)item, mode);
    }

    @Override
    public void unmanage(Location item, ManagementTransitionMode info) {
        if (!this.isInitialManagementContextReal()) {
            throw new IllegalStateException("Non-deployment context " + this + " is not valid for this operation");
        }
        ((LocationManagerInternal)this.initialManagementContext.getLocationManager()).unmanage((BrooklynObject)item, info);
    }

    public void unmanage(Location loc) {
        if (!this.isInitialManagementContextReal()) {
            throw new IllegalStateException("Non-deployment context " + this + " is not valid for this operation: cannot unmanage " + loc);
        }
        this.initialManagementContext.getLocationManager().unmanage(loc);
    }

    private boolean isInitialManagementContextReal() {
        return this.initialManagementContext != null && !(this.initialManagementContext instanceof NonDeploymentManagementContext);
    }
}

