/*
 * Decompiled with CFR 0.152.
 */
package org.apache.distributedlog.client;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.twitter.finagle.CancelledRequestException;
import com.twitter.finagle.ConnectionFailedException;
import com.twitter.finagle.Failure;
import com.twitter.finagle.NoBrokersAvailableException;
import com.twitter.finagle.RequestTimeoutException;
import com.twitter.finagle.ServiceException;
import com.twitter.finagle.ServiceTimeoutException;
import com.twitter.finagle.WriteException;
import com.twitter.finagle.builder.ClientBuilder;
import com.twitter.finagle.stats.StatsReceiver;
import com.twitter.finagle.thrift.ClientId;
import com.twitter.util.Duration;
import com.twitter.util.Function;
import com.twitter.util.Future;
import com.twitter.util.FutureEventListener;
import com.twitter.util.Promise;
import com.twitter.util.Return;
import com.twitter.util.Throw;
import com.twitter.util.Try;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.distributedlog.DLSN;
import org.apache.distributedlog.LogRecordSetBuffer;
import org.apache.distributedlog.client.ClientConfig;
import org.apache.distributedlog.client.monitor.MonitorServiceClient;
import org.apache.distributedlog.client.ownership.OwnershipCache;
import org.apache.distributedlog.client.proxy.ClusterClient;
import org.apache.distributedlog.client.proxy.HostProvider;
import org.apache.distributedlog.client.proxy.ProxyClient;
import org.apache.distributedlog.client.proxy.ProxyClientManager;
import org.apache.distributedlog.client.proxy.ProxyListener;
import org.apache.distributedlog.client.resolver.RegionResolver;
import org.apache.distributedlog.client.routing.RoutingService;
import org.apache.distributedlog.client.stats.ClientStats;
import org.apache.distributedlog.client.stats.OpStats;
import org.apache.distributedlog.exceptions.DLClientClosedException;
import org.apache.distributedlog.exceptions.ServiceUnavailableException;
import org.apache.distributedlog.exceptions.StreamUnavailableException;
import org.apache.distributedlog.protocol.util.ProtocolUtils;
import org.apache.distributedlog.service.DLSocketAddress;
import org.apache.distributedlog.service.DistributedLogClient;
import org.apache.distributedlog.thrift.service.BulkWriteResponse;
import org.apache.distributedlog.thrift.service.HeartbeatOptions;
import org.apache.distributedlog.thrift.service.ResponseHeader;
import org.apache.distributedlog.thrift.service.ServerInfo;
import org.apache.distributedlog.thrift.service.ServerStatus;
import org.apache.distributedlog.thrift.service.StatusCode;
import org.apache.distributedlog.thrift.service.WriteContext;
import org.apache.distributedlog.thrift.service.WriteResponse;
import org.apache.thrift.TApplicationException;
import org.jboss.netty.channel.ChannelException;
import org.jboss.netty.util.HashedWheelTimer;
import org.jboss.netty.util.Timeout;
import org.jboss.netty.util.TimerTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.collection.JavaConversions;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.runtime.AbstractFunction1;

public class DistributedLogClientImpl
implements DistributedLogClient,
MonitorServiceClient,
RoutingService.RoutingListener,
ProxyListener,
HostProvider {
    private static final Logger logger = LoggerFactory.getLogger(DistributedLogClientImpl.class);
    private final String clientName;
    private final ClientId clientId;
    private final ClientConfig clientConfig;
    private final RoutingService routingService;
    private final ProxyClient.Builder clientBuilder;
    private final boolean streamFailfast;
    private final Pattern streamNameRegexPattern;
    private final HashedWheelTimer dlTimer;
    private final RegionResolver regionResolver;
    private final OwnershipCache ownershipCache;
    private final ProxyClientManager clientManager;
    private final Optional<ClusterClient> clusterClient;
    private boolean closed = false;
    private final ReentrantReadWriteLock closeLock = new ReentrantReadWriteLock();
    private final ClientStats clientStats;

    public DistributedLogClientImpl(String name, ClientId clientId, RoutingService routingService, ClientBuilder clientBuilder, ClientConfig clientConfig, Optional<ClusterClient> clusterClient, StatsReceiver statsReceiver, StatsReceiver streamStatsReceiver, RegionResolver regionResolver, boolean enableRegionStats) {
        this.clientName = name;
        this.clientId = clientId;
        this.routingService = routingService;
        this.clientConfig = clientConfig;
        this.streamFailfast = clientConfig.getStreamFailfast();
        this.streamNameRegexPattern = Pattern.compile(clientConfig.getStreamNameRegex());
        this.regionResolver = regionResolver;
        this.dlTimer = new HashedWheelTimer(new ThreadFactoryBuilder().setNameFormat("DLClient-" + name + "-timer-%d").build(), (long)this.clientConfig.getRedirectBackoffStartMs(), TimeUnit.MILLISECONDS);
        this.routingService.registerListener(this);
        this.ownershipCache = new OwnershipCache(this.clientConfig, this.dlTimer, statsReceiver, streamStatsReceiver);
        this.clientStats = new ClientStats(statsReceiver, enableRegionStats, regionResolver);
        this.clientBuilder = ProxyClient.newBuilder(this.clientName, clientId, clientBuilder, clientConfig, this.clientStats);
        this.clientManager = new ProxyClientManager(this.clientConfig, this.clientBuilder, this.dlTimer, this, this.clientStats);
        this.clusterClient = clusterClient;
        this.clientManager.registerProxyListener(this);
        StatsReceiver cacheStatReceiver = statsReceiver.scope("cache");
        List numCachedStreamsGaugeName = JavaConversions.asScalaBuffer(Arrays.asList("num_streams")).toList();
        cacheStatReceiver.provideGauge((Seq)numCachedStreamsGaugeName, (Function0)new com.twitter.util.Function0<Object>(){

            public Object apply() {
                return Float.valueOf(DistributedLogClientImpl.this.ownershipCache.getNumCachedStreams());
            }
        });
        List numCachedHostsGaugeName = JavaConversions.asScalaBuffer(Arrays.asList("num_hosts")).toList();
        cacheStatReceiver.provideGauge((Seq)numCachedHostsGaugeName, (Function0)new com.twitter.util.Function0<Object>(){

            public Object apply() {
                return Float.valueOf(DistributedLogClientImpl.this.clientManager.getNumProxies());
            }
        });
        logger.info("Build distributedlog client : name = {}, client_id = {}, routing_service = {}, stats_receiver = {}, thriftmux = {}", new Object[]{name, clientId, routingService.getClass(), statsReceiver.getClass(), clientConfig.getThriftMux()});
    }

    @Override
    public Set<SocketAddress> getHosts() {
        HashSet hosts = Sets.newHashSet();
        if (!this.clusterClient.isPresent()) {
            hosts.addAll(this.routingService.getHosts());
        }
        hosts.addAll(this.ownershipCache.getStreamOwnershipDistribution().keySet());
        return hosts;
    }

    @Override
    public void onHandshakeSuccess(SocketAddress address, ProxyClient client, ServerInfo serverInfo) {
        if (null != serverInfo && serverInfo.isSetServerStatus() && ServerStatus.DOWN == serverInfo.getServerStatus()) {
            logger.info("{} is detected as DOWN during handshaking", (Object)address);
            this.handleServiceUnavailable(address, client, (Optional<StreamOp>)Optional.absent());
            return;
        }
        if (null != serverInfo && serverInfo.isSetOwnerships()) {
            Map ownerships = serverInfo.getOwnerships();
            logger.debug("Handshaked with {} : {} ownerships returned.", (Object)address, (Object)ownerships.size());
            for (Map.Entry entry : ownerships.entrySet()) {
                Matcher matcher = this.streamNameRegexPattern.matcher((CharSequence)entry.getKey());
                if (!matcher.matches()) continue;
                this.updateOwnership((String)entry.getKey(), (String)entry.getValue());
            }
        } else {
            logger.debug("Handshaked with {} : no ownerships returned", (Object)address);
        }
    }

    @Override
    public void onHandshakeFailure(SocketAddress address, ProxyClient client, Throwable cause) {
        cause = this.showRootCause((Optional<StreamOp>)Optional.absent(), cause);
        this.handleRequestException(address, client, (Optional<StreamOp>)Optional.absent(), cause);
    }

    @VisibleForTesting
    public void handshake() {
        this.clientManager.handshake();
        logger.info("Handshaked with {} hosts, cached {} streams", (Object)this.clientManager.getNumProxies(), (Object)this.ownershipCache.getNumCachedStreams());
    }

    @Override
    public void onServerLeft(SocketAddress address) {
        this.onServerLeft(address, null);
    }

    private void onServerLeft(SocketAddress address, ProxyClient sc) {
        this.ownershipCache.removeAllStreamsFromOwner(address);
        if (null == sc) {
            this.clientManager.removeClient(address);
        } else {
            this.clientManager.removeClient(address, sc);
        }
    }

    @Override
    public void onServerJoin(SocketAddress address) {
        if (!this.clusterClient.isPresent()) {
            this.clientManager.createClient(address);
        }
    }

    @Override
    public void close() {
        this.closeLock.writeLock().lock();
        try {
            if (this.closed) {
                return;
            }
            this.closed = true;
        }
        finally {
            this.closeLock.writeLock().unlock();
        }
        this.clientManager.close();
        this.routingService.unregisterListener(this);
        this.routingService.stopService();
        this.dlTimer.stop();
    }

    @Override
    public Future<Void> check(String stream) {
        HeartbeatOp op = new HeartbeatOp(stream, false);
        this.sendRequest(op);
        return op.result();
    }

    @Override
    public Future<Void> heartbeat(String stream) {
        HeartbeatOp op = new HeartbeatOp(stream, true);
        this.sendRequest(op);
        return op.result();
    }

    @Override
    public Map<SocketAddress, Set<String>> getStreamOwnershipDistribution() {
        return this.ownershipCache.getStreamOwnershipDistribution();
    }

    @Override
    public Future<Void> setAcceptNewStream(boolean enabled) {
        Map<SocketAddress, ProxyClient> snapshot = this.clientManager.getAllClients();
        ArrayList<Future> futures = new ArrayList<Future>(snapshot.size());
        for (Map.Entry<SocketAddress, ProxyClient> entry : snapshot.entrySet()) {
            futures.add(entry.getValue().getService().setAcceptNewStream(enabled));
        }
        return Future.collect(futures).map((Function1)new Function<java.util.List<Void>, Void>(){

            public Void apply(java.util.List<Void> list) {
                return null;
            }
        });
    }

    @Override
    public Future<DLSN> write(String stream, ByteBuffer data) {
        WriteOp op = new WriteOp(stream, data);
        this.sendRequest(op);
        return op.result();
    }

    @Override
    public Future<DLSN> writeRecordSet(String stream, LogRecordSetBuffer recordSet) {
        WriteRecordSetOp op = new WriteRecordSetOp(stream, recordSet);
        this.sendRequest(op);
        return op.result();
    }

    @Override
    public java.util.List<Future<DLSN>> writeBulk(String stream, java.util.List<ByteBuffer> data) {
        if (data.size() > 0) {
            BulkWriteOp op = new BulkWriteOp(stream, data);
            this.sendRequest(op);
            return op.result();
        }
        return Collections.emptyList();
    }

    @Override
    public Future<Boolean> truncate(String stream, DLSN dlsn) {
        TruncateOp op = new TruncateOp(stream, dlsn);
        this.sendRequest(op);
        return op.result();
    }

    @Override
    public Future<Void> delete(String stream) {
        DeleteOp op = new DeleteOp(stream);
        this.sendRequest(op);
        return op.result();
    }

    @Override
    public Future<Void> release(String stream) {
        ReleaseOp op = new ReleaseOp(stream);
        this.sendRequest(op);
        return op.result();
    }

    @Override
    public Future<Void> create(String stream) {
        CreateOp op = new CreateOp(stream);
        this.sendRequest(op);
        return op.result();
    }

    private void sendRequest(StreamOp op) {
        this.closeLock.readLock().lock();
        try {
            if (this.closed) {
                op.fail(null, (Throwable)new DLClientClosedException("Client " + this.clientName + " is closed."));
            } else {
                this.doSend(op, null);
            }
        }
        finally {
            this.closeLock.readLock().unlock();
        }
    }

    private void doSend(final StreamOp op, SocketAddress previousAddr) {
        SocketAddress address;
        if (null != previousAddr) {
            op.routingContext.addTriedHost(previousAddr, StatusCode.WRITE_EXCEPTION);
        }
        if (null == (address = this.ownershipCache.getOwner(op.stream)) || op.routingContext.isTriedHost(address)) {
            this.getOwner(op).addEventListener((FutureEventListener)new FutureEventListener<SocketAddress>(){

                public void onFailure(Throwable cause) {
                    op.fail(null, cause);
                }

                public void onSuccess(SocketAddress ownerAddr) {
                    op.send(ownerAddr);
                }
            });
        } else {
            op.send(address);
        }
    }

    private void retryGetOwnerFromResourcePlacementServer(StreamOp op, Promise<SocketAddress> getOwnerPromise, Throwable cause) {
        if (op.shouldTimeout()) {
            op.fail(null, cause);
            return;
        }
        this.getOwnerFromResourcePlacementServer(op, getOwnerPromise);
    }

    private void getOwnerFromResourcePlacementServer(final StreamOp op, final Promise<SocketAddress> getOwnerPromise) {
        ((ClusterClient)this.clusterClient.get()).getService().getOwner(op.stream, op.ctx).addEventListener((FutureEventListener)new FutureEventListener<WriteResponse>(){

            public void onFailure(Throwable cause) {
                getOwnerPromise.updateIfEmpty((Try)new Throw(cause));
            }

            public void onSuccess(WriteResponse value) {
                if (StatusCode.FOUND == value.getHeader().getCode() && null != value.getHeader().getLocation()) {
                    try {
                        InetSocketAddress addr = DLSocketAddress.deserialize(value.getHeader().getLocation()).getSocketAddress();
                        getOwnerPromise.updateIfEmpty((Try)new Return((Object)addr));
                    }
                    catch (IOException e) {
                        logger.error("ERROR in getOwner", (Throwable)e);
                        DistributedLogClientImpl.this.retryGetOwnerFromResourcePlacementServer(op, (Promise<SocketAddress>)getOwnerPromise, e);
                        return;
                    }
                } else {
                    DistributedLogClientImpl.this.retryGetOwnerFromResourcePlacementServer(op, (Promise<SocketAddress>)getOwnerPromise, (Throwable)new StreamUnavailableException("Stream " + op.stream + "'s owner is unknown"));
                }
            }
        });
    }

    private Future<SocketAddress> getOwner(StreamOp op) {
        if (this.clusterClient.isPresent()) {
            Promise getOwnerPromise = new Promise();
            this.getOwnerFromResourcePlacementServer(op, (Promise<SocketAddress>)getOwnerPromise);
            return getOwnerPromise;
        }
        try {
            return Future.value((Object)this.routingService.getHost(op.stream, op.routingContext));
        }
        catch (NoBrokersAvailableException nbae) {
            return Future.exception((Throwable)nbae);
        }
    }

    private void sendWriteRequest(final SocketAddress addr, final StreamOp op) {
        final ProxyClient sc = this.clientManager.getClient(addr);
        final long startTimeNanos = System.nanoTime();
        op.sendRequest(sc).addEventListener((FutureEventListener)new FutureEventListener<ResponseHeader>(){

            public void onSuccess(ResponseHeader header) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Received response; header: {}", (Object)header);
                }
                DistributedLogClientImpl.this.clientStats.completeProxyRequest(addr, header.getCode(), startTimeNanos);
                op.routingContext.addTriedHost(addr, header.getCode());
                switch (header.getCode()) {
                    case SUCCESS: {
                        break;
                    }
                    case FOUND: {
                        DistributedLogClientImpl.this.handleRedirectResponse(header, op, addr);
                        break;
                    }
                    case OVER_CAPACITY: {
                        logger.debug("Failed to write request to {} : {}", (Object)op.stream, (Object)header);
                        op.fail(addr, (Throwable)ProtocolUtils.exception((ResponseHeader)header));
                        break;
                    }
                    case NOT_IMPLEMENTED: 
                    case METADATA_EXCEPTION: 
                    case LOG_EMPTY: 
                    case LOG_NOT_FOUND: 
                    case TRUNCATED_TRANSACTION: 
                    case END_OF_STREAM: 
                    case TRANSACTION_OUT_OF_ORDER: 
                    case INVALID_STREAM_NAME: 
                    case REQUEST_DENIED: 
                    case TOO_LARGE_RECORD: 
                    case CHECKSUM_FAILED: 
                    case STREAM_NOT_READY: {
                        op.fail(addr, (Throwable)ProtocolUtils.exception((ResponseHeader)header));
                        break;
                    }
                    case SERVICE_UNAVAILABLE: {
                        DistributedLogClientImpl.this.handleServiceUnavailable(addr, sc, (Optional<StreamOp>)Optional.of((Object)op));
                        break;
                    }
                    case REGION_UNAVAILABLE: {
                        DistributedLogClientImpl.this.redirect(op, null);
                        break;
                    }
                    case TOO_MANY_STREAMS: {
                        DistributedLogClientImpl.this.handleRedirectableError(addr, op, header);
                        break;
                    }
                    default: {
                        DistributedLogClientImpl.this.ownershipCache.removeOwnerFromStream(op.stream, addr, header.getCode().name());
                        DistributedLogClientImpl.this.handleRedirectableError(addr, op, header);
                    }
                }
            }

            public void onFailure(Throwable cause) {
                Optional opOptional = Optional.of((Object)op);
                cause = DistributedLogClientImpl.this.showRootCause((Optional<StreamOp>)opOptional, cause);
                DistributedLogClientImpl.this.clientStats.failProxyRequest(addr, cause, startTimeNanos);
                DistributedLogClientImpl.this.handleRequestException(addr, sc, (Optional<StreamOp>)opOptional, cause);
            }
        });
    }

    Throwable showRootCause(Optional<StreamOp> op, Throwable cause) {
        Failure failure;
        if (cause instanceof Failure && (failure = (Failure)cause).isFlagged(Failure.Wrapped())) {
            try {
                cause = failure.show();
            }
            catch (IllegalArgumentException iae) {
                if (op.isPresent()) {
                    logger.warn("Failed to unwrap finagle failure of stream {} : ", (Object)((StreamOp)op.get()).stream, (Object)iae);
                }
                logger.warn("Failed to unwrap finagle failure : ", (Throwable)iae);
            }
        }
        return cause;
    }

    private void handleRedirectableError(SocketAddress addr, StreamOp op, ResponseHeader header) {
        if (this.streamFailfast) {
            op.fail(addr, (Throwable)ProtocolUtils.exception((ResponseHeader)header));
        } else {
            this.redirect(op, null);
        }
    }

    void handleServiceUnavailable(SocketAddress addr, ProxyClient sc, Optional<StreamOp> op) {
        this.routingService.removeHost(addr, (Throwable)new ServiceUnavailableException(addr + " is unavailable now."));
        this.onServerLeft(addr);
        if (op.isPresent()) {
            this.ownershipCache.removeOwnerFromStream(((StreamOp)op.get()).stream, addr, addr + " is unavailable now.");
            this.redirect((StreamOp)op.get(), null);
        }
    }

    void handleRequestException(SocketAddress addr, ProxyClient sc, Optional<StreamOp> op, Throwable cause) {
        boolean resendOp = false;
        boolean removeOwnerFromStream = false;
        SocketAddress previousAddr = addr;
        String reason = cause.getMessage();
        if (cause instanceof ConnectionFailedException || cause instanceof ConnectException) {
            this.routingService.removeHost(addr, cause);
            this.onServerLeft(addr, sc);
            removeOwnerFromStream = true;
            resendOp = true;
        } else if (cause instanceof ChannelException) {
            if (cause.getCause() instanceof ConnectException) {
                this.routingService.removeHost(addr, cause.getCause());
                this.onServerLeft(addr);
                reason = cause.getCause().getMessage();
            } else {
                this.routingService.removeHost(addr, cause);
                reason = cause.getMessage();
            }
            removeOwnerFromStream = true;
            resendOp = true;
        } else if (cause instanceof ServiceTimeoutException) {
            resendOp = true;
            previousAddr = null;
        } else if (cause instanceof WriteException) {
            resendOp = true;
        } else if (cause instanceof ServiceException) {
            this.clientManager.removeClient(addr, sc);
            resendOp = true;
        } else if (cause instanceof TApplicationException) {
            this.handleTApplicationException(cause, op, addr, sc);
        } else if (cause instanceof Failure) {
            this.handleFinagleFailure((Failure)cause, op, addr);
        } else {
            this.handleException(cause, op, addr);
        }
        if (op.isPresent()) {
            if (removeOwnerFromStream) {
                this.ownershipCache.removeOwnerFromStream(((StreamOp)op.get()).stream, addr, reason);
            }
            if (resendOp) {
                this.doSend((StreamOp)op.get(), previousAddr);
            }
        }
    }

    void redirect(StreamOp op, SocketAddress newAddr) {
        this.ownershipCache.getOwnershipStatsLogger().onRedirect(op.stream);
        if (null != newAddr) {
            logger.debug("Redirect request {} to new owner {}.", (Object)op, (Object)newAddr);
            op.send(newAddr);
        } else {
            this.doSend(op, null);
        }
    }

    void handleFinagleFailure(Failure failure, Optional<StreamOp> op, SocketAddress addr) {
        if (failure.isFlagged(Failure.Restartable())) {
            if (op.isPresent()) {
                this.doSend((StreamOp)op.get(), addr);
            }
        } else {
            this.handleException((Throwable)failure, op, addr);
        }
    }

    void handleException(Throwable cause, Optional<StreamOp> op, SocketAddress addr) {
        if (op.isPresent()) {
            logger.error("Failed to write request to {} @ {} : {}", new Object[]{((StreamOp)op.get()).stream, addr, cause.toString()});
            ((StreamOp)op.get()).fail(addr, cause);
        }
    }

    void handleTApplicationException(Throwable cause, Optional<StreamOp> op, SocketAddress addr, ProxyClient sc) {
        TApplicationException ex = (TApplicationException)cause;
        if (ex.getType() == 1) {
            this.routingService.removeHost(addr, cause);
            this.onServerLeft(addr, sc);
            if (op.isPresent()) {
                this.ownershipCache.removeOwnerFromStream(((StreamOp)op.get()).stream, addr, cause.getMessage());
                this.doSend((StreamOp)op.get(), addr);
            }
        } else {
            this.handleException(cause, op, addr);
        }
    }

    void handleRedirectResponse(ResponseHeader header, StreamOp op, SocketAddress curAddr) {
        InetSocketAddress ownerAddr = null;
        if (header.isSetLocation()) {
            String owner = header.getLocation();
            try {
                ownerAddr = DLSocketAddress.deserialize(owner).getSocketAddress();
                if (curAddr.equals(ownerAddr)) {
                    logger.warn("Request to stream {} is redirected to same server {}!", (Object)op.stream, (Object)curAddr);
                    ownerAddr = null;
                } else {
                    this.ownershipCache.updateOwner(op.stream, ownerAddr);
                }
            }
            catch (IOException e) {
                ownerAddr = null;
            }
        }
        this.redirect(op, ownerAddr);
    }

    void updateOwnership(String stream, String location) {
        try {
            InetSocketAddress ownerAddr = DLSocketAddress.deserialize(location).getSocketAddress();
            this.ownershipCache.updateOwner(stream, ownerAddr);
        }
        catch (IOException e) {
            logger.warn("Invalid ownership {} found for stream {} : ", new Object[]{location, stream, e});
        }
    }

    static /* synthetic */ RegionResolver access$000(DistributedLogClientImpl x0) {
        return x0.regionResolver;
    }

    class HeartbeatOp
    extends AbstractWriteOp {
        HeartbeatOptions options;

        HeartbeatOp(String name, boolean sendReaderHeartBeat) {
            super(name, DistributedLogClientImpl.this.clientStats.getOpStats("heartbeat"));
            this.options = new HeartbeatOptions();
            this.options.setSendHeartBeatToReader(sendReaderHeartBeat);
        }

        @Override
        Future<WriteResponse> sendWriteRequest(ProxyClient sc) {
            return sc.getService().heartbeatWithOptions(this.stream, this.ctx, this.options);
        }

        Future<Void> result() {
            return this.result.map((Function1)new AbstractFunction1<WriteResponse, Void>(){

                public Void apply(WriteResponse response) {
                    return null;
                }
            });
        }
    }

    class CreateOp
    extends AbstractWriteOp {
        CreateOp(String name) {
            super(name, DistributedLogClientImpl.this.clientStats.getOpStats("create"));
        }

        @Override
        Future<WriteResponse> sendWriteRequest(ProxyClient sc) {
            return sc.getService().create(this.stream, this.ctx);
        }

        @Override
        void beforeComplete(ProxyClient sc, ResponseHeader header) {
            DistributedLogClientImpl.this.ownershipCache.updateOwner(this.stream, sc.getAddress());
        }

        Future<Void> result() {
            return this.result.map((Function1)new AbstractFunction1<WriteResponse, Void>(){

                public Void apply(WriteResponse v1) {
                    return null;
                }
            }).voided();
        }
    }

    class DeleteOp
    extends AbstractWriteOp {
        DeleteOp(String name) {
            super(name, DistributedLogClientImpl.this.clientStats.getOpStats("delete"));
        }

        @Override
        Future<WriteResponse> sendWriteRequest(ProxyClient sc) {
            return sc.getService().delete(this.stream, this.ctx);
        }

        @Override
        void beforeComplete(ProxyClient sc, ResponseHeader header) {
            DistributedLogClientImpl.this.ownershipCache.removeOwnerFromStream(this.stream, sc.getAddress(), "Stream Deleted");
        }

        Future<Void> result() {
            return this.result.map((Function1)new AbstractFunction1<WriteResponse, Void>(){

                public Void apply(WriteResponse v1) {
                    return null;
                }
            });
        }
    }

    class ReleaseOp
    extends AbstractWriteOp {
        ReleaseOp(String name) {
            super(name, DistributedLogClientImpl.this.clientStats.getOpStats("release"));
        }

        @Override
        Future<WriteResponse> sendWriteRequest(ProxyClient sc) {
            return sc.getService().release(this.stream, this.ctx);
        }

        @Override
        void beforeComplete(ProxyClient sc, ResponseHeader header) {
            DistributedLogClientImpl.this.ownershipCache.removeOwnerFromStream(this.stream, sc.getAddress(), "Stream Deleted");
        }

        Future<Void> result() {
            return this.result.map((Function1)new AbstractFunction1<WriteResponse, Void>(){

                public Void apply(WriteResponse response) {
                    return null;
                }
            });
        }
    }

    class WriteRecordSetOp
    extends WriteOp {
        WriteRecordSetOp(String name, LogRecordSetBuffer recordSet) {
            super(name, recordSet.getBuffer());
            this.ctx.setIsRecordSet(true);
        }
    }

    class TruncateOp
    extends AbstractWriteOp {
        final DLSN dlsn;

        TruncateOp(String name, DLSN dlsn) {
            super(name, DistributedLogClientImpl.this.clientStats.getOpStats("truncate"));
            this.dlsn = dlsn;
        }

        @Override
        Long computeChecksum() {
            if (null == this.crc32) {
                this.crc32 = ProtocolUtils.truncateOpCRC32((String)this.stream, (DLSN)this.dlsn);
            }
            return this.crc32;
        }

        @Override
        Future<WriteResponse> sendWriteRequest(ProxyClient sc) {
            return sc.getService().truncate(this.stream, this.dlsn.serialize(), this.ctx);
        }

        Future<Boolean> result() {
            return this.result.map((Function1)new AbstractFunction1<WriteResponse, Boolean>(){

                public Boolean apply(WriteResponse response) {
                    return true;
                }
            });
        }
    }

    class WriteOp
    extends AbstractWriteOp {
        final ByteBuf dataBuf;
        final ByteBuffer data;

        WriteOp(String name, ByteBuf dataBuf) {
            super(name, DistributedLogClientImpl.this.clientStats.getOpStats("write"));
            if (dataBuf.hasArray()) {
                this.dataBuf = dataBuf;
                this.data = dataBuf.nioBuffer();
            } else {
                this.dataBuf = Unpooled.copiedBuffer((ByteBuf)dataBuf);
                dataBuf.release();
                this.data = this.dataBuf.nioBuffer();
            }
        }

        WriteOp(String name, ByteBuffer data) {
            super(name, DistributedLogClientImpl.this.clientStats.getOpStats("write"));
            if (data.hasArray()) {
                this.data = data;
                this.dataBuf = Unpooled.wrappedBuffer((ByteBuffer)data);
            } else {
                this.dataBuf = Unpooled.copiedBuffer((ByteBuffer)data);
                this.data = this.dataBuf.nioBuffer();
            }
        }

        @Override
        void complete(SocketAddress address, WriteResponse response) {
            super.complete(address, response);
            this.release();
        }

        @Override
        void fail(SocketAddress address, Throwable t) {
            super.fail(address, t);
            this.release();
        }

        @Override
        Future<WriteResponse> sendWriteRequest(ProxyClient sc) {
            this.dataBuf.retain();
            return sc.getService().writeWithContext(this.stream, this.data.duplicate(), this.ctx);
        }

        @Override
        void onSendWriteRequestCompleted() {
            this.dataBuf.release();
        }

        @Override
        Long computeChecksum() {
            if (null == this.crc32) {
                this.crc32 = ProtocolUtils.writeOpCRC32((String)this.stream, (ByteBuffer)this.data.duplicate());
            }
            return this.crc32;
        }

        Future<DLSN> result() {
            return this.result.map((Function1)new AbstractFunction1<WriteResponse, DLSN>(){

                public DLSN apply(WriteResponse response) {
                    return DLSN.deserialize((String)response.getDlsn());
                }
            });
        }

        void release() {
            if (null != this.dataBuf) {
                this.dataBuf.release();
            }
        }
    }

    abstract class AbstractWriteOp
    extends StreamOp {
        final Promise<WriteResponse> result;
        Long crc32;

        AbstractWriteOp(String name, OpStats opStats) {
            super(name, opStats);
            this.result = new Promise();
            this.crc32 = null;
        }

        void complete(SocketAddress address, WriteResponse response) {
            super.complete(address);
            this.result.setValue((Object)response);
        }

        @Override
        void fail(SocketAddress address, Throwable t) {
            super.fail(address, t);
            this.result.setException(t);
        }

        @Override
        Long computeChecksum() {
            if (null == this.crc32) {
                this.crc32 = ProtocolUtils.streamOpCRC32((String)this.stream);
            }
            return this.crc32;
        }

        @Override
        Future<ResponseHeader> sendRequest(final ProxyClient sc) {
            return this.sendWriteRequest(sc).addEventListener((FutureEventListener)new FutureEventListener<WriteResponse>(){

                public void onSuccess(WriteResponse response) {
                    if (response.getHeader().getCode() == StatusCode.SUCCESS) {
                        AbstractWriteOp.this.beforeComplete(sc, response.getHeader());
                        AbstractWriteOp.this.complete(sc.getAddress(), response);
                    }
                    AbstractWriteOp.this.onSendWriteRequestCompleted();
                }

                public void onFailure(Throwable cause) {
                    AbstractWriteOp.this.onSendWriteRequestCompleted();
                }
            }).map((Function1)new AbstractFunction1<WriteResponse, ResponseHeader>(){

                public ResponseHeader apply(WriteResponse response) {
                    return response.getHeader();
                }
            });
        }

        abstract Future<WriteResponse> sendWriteRequest(ProxyClient var1);

        void onSendWriteRequestCompleted() {
        }
    }

    class BulkWriteOp
    extends StreamOp {
        final java.util.List<ByteBuffer> data;
        final ArrayList<Promise<DLSN>> results;

        BulkWriteOp(String name, java.util.List<ByteBuffer> data) {
            super(name, DistributedLogClientImpl.this.clientStats.getOpStats("bulk_write"));
            this.data = data;
            this.results = new ArrayList(data.size());
            for (int i = 0; i < data.size(); ++i) {
                Preconditions.checkNotNull((Object)data.get(i));
                this.results.add((Promise<DLSN>)new Promise());
            }
        }

        @Override
        Future<ResponseHeader> sendRequest(final ProxyClient sc) {
            return sc.getService().writeBulkWithContext(this.stream, this.data, this.ctx).addEventListener((FutureEventListener)new FutureEventListener<BulkWriteResponse>(){

                public void onSuccess(BulkWriteResponse response) {
                    if (response.getHeader().getCode() == StatusCode.SUCCESS) {
                        BulkWriteOp.this.beforeComplete(sc, response.getHeader());
                        BulkWriteOp.this.complete(sc.getAddress(), response);
                        if (response.getWriteResponses().size() == 0 && BulkWriteOp.this.data.size() > 0) {
                            logger.error("non-empty bulk write got back empty response without failure for stream {}", (Object)BulkWriteOp.this.stream);
                        }
                    }
                }

                public void onFailure(Throwable cause) {
                }
            }).map((Function1)new AbstractFunction1<BulkWriteResponse, ResponseHeader>(){

                public ResponseHeader apply(BulkWriteResponse response) {
                    return response.getHeader();
                }
            });
        }

        void complete(SocketAddress address, BulkWriteResponse bulkWriteResponse) {
            super.complete(address);
            Iterator writeResponseIterator = bulkWriteResponse.getWriteResponses().iterator();
            Iterator<Promise<DLSN>> resultIterator = this.results.iterator();
            while (resultIterator.hasNext() && writeResponseIterator.hasNext()) {
                Promise<DLSN> result = resultIterator.next();
                WriteResponse writeResponse = (WriteResponse)writeResponseIterator.next();
                if (StatusCode.SUCCESS == writeResponse.getHeader().getCode()) {
                    result.setValue((Object)DLSN.deserialize((String)writeResponse.getDlsn()));
                    continue;
                }
                result.setException((Throwable)ProtocolUtils.exception((ResponseHeader)writeResponse.getHeader()));
            }
            if (bulkWriteResponse.getWriteResponses().size() != this.data.size()) {
                logger.error("wrong number of results, response = {} records = {}", (Object)bulkWriteResponse.getWriteResponses().size(), (Object)this.data.size());
            }
        }

        @Override
        void fail(SocketAddress address, Throwable t) {
            Promise<DLSN> result;
            super.fail(address, t);
            Iterator<Promise<DLSN>> resultIterator = this.results.iterator();
            if (resultIterator.hasNext()) {
                result = resultIterator.next();
                result.setException(t);
            }
            while (resultIterator.hasNext()) {
                result = resultIterator.next();
                result.setException((Throwable)new CancelledRequestException());
            }
        }

        java.util.List<Future<DLSN>> result() {
            return this.results;
        }
    }

    abstract class StreamOp
    implements TimerTask {
        final String stream;
        final AtomicInteger tries = new AtomicInteger(0);
        final RoutingService.RoutingContext routingContext = RoutingService.RoutingContext.of(DistributedLogClientImpl.access$000(DistributedLogClientImpl.this));
        final WriteContext ctx = new WriteContext();
        final Stopwatch stopwatch;
        final OpStats opStats;
        SocketAddress nextAddressToSend;

        StreamOp(String stream, OpStats opStats) {
            this.stream = stream;
            this.stopwatch = Stopwatch.createStarted();
            this.opStats = opStats;
        }

        boolean shouldTimeout() {
            long elapsedMs = this.stopwatch.elapsed(TimeUnit.MILLISECONDS);
            return this.shouldTimeout(elapsedMs);
        }

        boolean shouldTimeout(long elapsedMs) {
            return DistributedLogClientImpl.this.clientConfig.getRequestTimeoutMs() > 0 && elapsedMs >= (long)DistributedLogClientImpl.this.clientConfig.getRequestTimeoutMs();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void send(SocketAddress address) {
            long elapsedMs = this.stopwatch.elapsed(TimeUnit.MILLISECONDS);
            if (DistributedLogClientImpl.this.clientConfig.getMaxRedirects() > 0 && this.tries.get() >= DistributedLogClientImpl.this.clientConfig.getMaxRedirects()) {
                this.fail(address, (Throwable)new RequestTimeoutException(Duration.fromMilliseconds((long)elapsedMs), "Exhausted max redirects in " + elapsedMs + " ms"));
                return;
            }
            if (this.shouldTimeout(elapsedMs)) {
                this.fail(address, (Throwable)new RequestTimeoutException(Duration.fromMilliseconds((long)elapsedMs), "Exhausted max request timeout " + DistributedLogClientImpl.this.clientConfig.getRequestTimeoutMs() + " in " + elapsedMs + " ms"));
                return;
            }
            StreamOp streamOp = this;
            synchronized (streamOp) {
                String addrStr = address.toString();
                if (this.ctx.isSetTriedHosts() && this.ctx.getTriedHosts().contains(addrStr)) {
                    this.nextAddressToSend = address;
                    DistributedLogClientImpl.this.dlTimer.newTimeout((TimerTask)this, (long)Math.min(DistributedLogClientImpl.this.clientConfig.getRedirectBackoffMaxMs(), this.tries.get() * DistributedLogClientImpl.this.clientConfig.getRedirectBackoffStartMs()), TimeUnit.MILLISECONDS);
                } else {
                    this.doSend(address);
                }
            }
        }

        abstract Future<ResponseHeader> sendRequest(ProxyClient var1);

        void doSend(SocketAddress address) {
            Long crc32;
            this.ctx.addToTriedHosts(address.toString());
            if (DistributedLogClientImpl.this.clientConfig.isChecksumEnabled() && null != (crc32 = this.computeChecksum())) {
                this.ctx.setCrc32(crc32.longValue());
            }
            this.tries.incrementAndGet();
            DistributedLogClientImpl.this.sendWriteRequest(address, this);
        }

        void beforeComplete(ProxyClient sc, ResponseHeader responseHeader) {
            DistributedLogClientImpl.this.ownershipCache.updateOwner(this.stream, sc.getAddress());
        }

        void complete(SocketAddress address) {
            this.stopwatch.stop();
            this.opStats.completeRequest(address, this.stopwatch.elapsed(TimeUnit.MICROSECONDS), this.tries.get());
        }

        void fail(SocketAddress address, Throwable t) {
            this.stopwatch.stop();
            this.opStats.failRequest(address, this.stopwatch.elapsed(TimeUnit.MICROSECONDS), this.tries.get());
        }

        Long computeChecksum() {
            return null;
        }

        public synchronized void run(Timeout timeout) throws Exception {
            if (!timeout.isCancelled() && null != this.nextAddressToSend) {
                this.doSend(this.nextAddressToSend);
            } else {
                this.fail(null, (Throwable)new CancelledRequestException());
            }
        }
    }
}

