/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.common.io;

import com.google.common.base.Preconditions;
import com.twitter.common.base.ExceptionalClosure;
import com.twitter.common.base.ExceptionalFunction;
import java.io.File;
import java.io.IOException;
import java.util.UUID;
import org.apache.commons.lang.SystemUtils;

public final class FileUtils {
    public static final Temporary SYSTEM_TMP = new Temporary(SystemUtils.getJavaIoTmpDir());

    public static File createTempDir() {
        return SYSTEM_TMP.createDir();
    }

    private FileUtils() {
    }

    public static class Temporary {
        private static final int MAX_TMP_DIR_TRIES = 5;
        private final File basedir;

        public Temporary(File basedir) {
            Preconditions.checkNotNull((Object)basedir);
            this.basedir = basedir;
        }

        public File createDir() {
            File tempDir;
            int tries = 0;
            do {
                if (++tries <= 5) continue;
                throw new IllegalStateException("Failed to create a new temp directory in 5 attempts, giving up");
            } while (!(tempDir = new File(this.basedir, UUID.randomUUID().toString())).mkdir());
            return tempDir;
        }

        public File createFile() throws IOException {
            return this.createFile(".tempfile");
        }

        public File createFile(String suffix) throws IOException {
            return File.createTempFile(FileUtils.class.getName(), suffix, this.basedir);
        }

        public <E extends Exception> void doWithDir(final ExceptionalClosure<File, E> work) throws E {
            Preconditions.checkNotNull(work);
            this.doWithDir(new ExceptionalFunction<File, Void, E>(){

                public Void apply(File dir) throws Exception {
                    work.execute((Object)dir);
                    return null;
                }
            });
        }

        public <T, E extends Exception> T doWithDir(ExceptionalFunction<File, T, E> work) throws E {
            Preconditions.checkNotNull(work);
            return Temporary.doWithTemp(this.createDir(), work);
        }

        public <E extends Exception> void doWithFile(final ExceptionalClosure<File, E> work) throws E, IOException {
            Preconditions.checkNotNull(work);
            this.doWithFile(new ExceptionalFunction<File, Void, E>(){

                public Void apply(File dir) throws Exception {
                    work.execute((Object)dir);
                    return null;
                }
            });
        }

        public <T, E extends Exception> T doWithFile(ExceptionalFunction<File, T, E> work) throws E, IOException {
            Preconditions.checkNotNull(work);
            return Temporary.doWithTemp(this.createFile(), work);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static <T, E extends Exception> T doWithTemp(File file, ExceptionalFunction<File, T, E> work) throws E {
            try {
                Object object = work.apply((Object)file);
                return (T)object;
            }
            finally {
                org.apache.commons.io.FileUtils.deleteQuietly((File)file);
            }
        }
    }
}

