/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.tools.javadoc.internal.doclets.toolkit.taglets;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import org.openjdk.source.doctree.DocTree;
import org.openjdk.source.doctree.ParamTree;
import org.openjdk.tools.javadoc.internal.doclets.toolkit.Content;
import org.openjdk.tools.javadoc.internal.doclets.toolkit.taglets.BaseTaglet;
import org.openjdk.tools.javadoc.internal.doclets.toolkit.taglets.InheritableTaglet;
import org.openjdk.tools.javadoc.internal.doclets.toolkit.taglets.TagletWriter;
import org.openjdk.tools.javadoc.internal.doclets.toolkit.util.CommentHelper;
import org.openjdk.tools.javadoc.internal.doclets.toolkit.util.DocFinder;
import org.openjdk.tools.javadoc.internal.doclets.toolkit.util.Utils;

public class ParamTaglet
extends BaseTaglet
implements InheritableTaglet {
    public ParamTaglet() {
        this.name = DocTree.Kind.PARAM.tagName;
    }

    private static Map<String, String> getRankMap(Utils utils, List<? extends Element> params) {
        if (params == null) {
            return null;
        }
        HashMap<String, String> result = new HashMap<String, String>();
        int rank = 0;
        for (Element element : params) {
            String name = utils.isTypeParameterElement(element) ? utils.getTypeName(element.asType(), false) : utils.getSimpleName(element);
            result.put(name, String.valueOf(rank));
            ++rank;
        }
        return result;
    }

    @Override
    public void inherit(DocFinder.Input input, DocFinder.Output output) {
        CommentHelper ch;
        Utils utils = input.utils;
        if (input.tagId == null) {
            input.isTypeVariableParamTag = ((ParamTree)input.docTreeInfo.docTree).isTypeParameter();
            ExecutableElement ee = (ExecutableElement)input.docTreeInfo.element;
            ch = utils.getCommentHelper(ee);
            List<Element> parameters = input.isTypeVariableParamTag ? ee.getTypeParameters() : ee.getParameters();
            String target = ch.getParameterName(input.docTreeInfo.docTree);
            for (int i = 0; i < parameters.size(); ++i) {
                String string;
                Element e = parameters.get(i);
                String string2 = string = input.isTypeVariableParamTag ? utils.getTypeName(e.asType(), false) : utils.getSimpleName(e);
                if (!string.equals(target)) continue;
                input.tagId = String.valueOf(i);
                break;
            }
        }
        ExecutableElement md = (ExecutableElement)input.element;
        ch = utils.getCommentHelper(md);
        List<? extends DocTree> tags = input.isTypeVariableParamTag ? utils.getTypeParamTrees(md) : utils.getParamTrees(md);
        List<Element> parameters = input.isTypeVariableParamTag ? md.getTypeParameters() : md.getParameters();
        Map<String, String> rankMap = ParamTaglet.getRankMap(utils, parameters);
        for (DocTree docTree : tags) {
            String paramName = ch.getParameterName(docTree);
            if (!rankMap.containsKey(paramName) || !rankMap.get(paramName).equals(input.tagId)) continue;
            output.holder = input.element;
            output.holderTag = docTree;
            output.inlineTags = ch.getBody(utils.configuration, docTree);
            return;
        }
    }

    @Override
    public boolean inField() {
        return false;
    }

    @Override
    public boolean inMethod() {
        return true;
    }

    @Override
    public boolean inOverview() {
        return false;
    }

    @Override
    public boolean inPackage() {
        return false;
    }

    @Override
    public boolean inType() {
        return true;
    }

    @Override
    public boolean isInlineTag() {
        return false;
    }

    @Override
    public Content getTagletOutput(Element holder, TagletWriter writer) {
        Utils utils = writer.configuration().utils;
        if (utils.isExecutableElement(holder)) {
            ExecutableElement member = (ExecutableElement)holder;
            Content output = this.getTagletOutput(false, member, writer, member.getTypeParameters(), utils.getTypeParamTrees(member));
            output.addContent(this.getTagletOutput(true, member, writer, member.getParameters(), utils.getParamTrees(member)));
            return output;
        }
        TypeElement typeElement = (TypeElement)holder;
        return this.getTagletOutput(false, typeElement, writer, typeElement.getTypeParameters(), utils.getTypeParamTrees(typeElement));
    }

    private Content getTagletOutput(boolean isParameters, Element holder, TagletWriter writer, List<? extends Element> formalParameters, List<? extends DocTree> paramTags) {
        Content result = writer.getOutputInstance();
        HashSet<String> alreadyDocumented = new HashSet<String>();
        if (!paramTags.isEmpty()) {
            result.addContent(this.processParamTags(holder, isParameters, paramTags, ParamTaglet.getRankMap(writer.configuration().utils, formalParameters), writer, alreadyDocumented));
        }
        if (alreadyDocumented.size() != formalParameters.size()) {
            result.addContent(this.getInheritedTagletOutput(isParameters, holder, writer, formalParameters, alreadyDocumented));
        }
        return result;
    }

    private Content getInheritedTagletOutput(boolean isParameters, Element holder, TagletWriter writer, List<? extends Element> formalParameters, Set<String> alreadyDocumented) {
        Utils utils = writer.configuration().utils;
        Content result = writer.getOutputInstance();
        if (!alreadyDocumented.contains(null) && utils.isExecutableElement(holder)) {
            for (int i = 0; i < formalParameters.size(); ++i) {
                if (alreadyDocumented.contains(String.valueOf(i))) continue;
                DocFinder.Input input = new DocFinder.Input(writer.configuration().utils, holder, this, Integer.toString(i), !isParameters);
                DocFinder.Output inheritedDoc = DocFinder.search(writer.configuration(), input);
                if (inheritedDoc.inlineTags != null && !inheritedDoc.inlineTags.isEmpty()) {
                    Element e = formalParameters.get(i);
                    String lname = isParameters ? utils.getSimpleName(e) : utils.getTypeName(e.asType(), false);
                    CommentHelper ch = utils.getCommentHelper(holder);
                    ch.setOverrideElement(inheritedDoc.holder);
                    Content content = this.processParamTag(holder, isParameters, writer, inheritedDoc.holderTag, lname, alreadyDocumented.isEmpty());
                    result.addContent(content);
                }
                alreadyDocumented.add(String.valueOf(i));
            }
        }
        return result;
    }

    private Content processParamTags(Element e, boolean isParams, List<? extends DocTree> paramTags, Map<String, String> rankMap, TagletWriter writer, Set<String> alreadyDocumented) {
        Content result = writer.getOutputInstance();
        if (!paramTags.isEmpty()) {
            CommentHelper ch = writer.configuration().utils.getCommentHelper(e);
            for (DocTree docTree : paramTags) {
                String rank;
                String paramName;
                String string = paramName = isParams ? ch.getParameterName(docTree) : "<" + ch.getParameterName(docTree) + ">";
                if (!rankMap.containsKey(ch.getParameterName(docTree))) {
                    writer.getMsgRetriever().warning(ch.getDocTreePath(docTree), isParams ? "doclet.Parameters_warn" : "doclet.Type_Parameters_warn", paramName);
                }
                if ((rank = rankMap.get(ch.getParameterName(docTree))) != null && alreadyDocumented.contains(rank)) {
                    writer.getMsgRetriever().warning(ch.getDocTreePath(docTree), isParams ? "doclet.Parameters_dup_warn" : "doclet.Type_Parameters_dup_warn", paramName);
                }
                result.addContent(this.processParamTag(e, isParams, writer, docTree, ch.getParameterName(docTree), alreadyDocumented.isEmpty()));
                alreadyDocumented.add(rank);
            }
        }
        return result;
    }

    private Content processParamTag(Element e, boolean isParams, TagletWriter writer, DocTree paramTag, String name, boolean isFirstParam) {
        Content result = writer.getOutputInstance();
        String header = writer.configuration().getText(isParams ? "doclet.Parameters" : "doclet.TypeParameters");
        if (isFirstParam) {
            result.addContent(writer.getParamHeader(header));
        }
        result.addContent(writer.paramTagOutput(e, paramTag, name));
        return result;
    }
}

