/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.finagle.util;

import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.math.package$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u000113Q!\u0001\u0002\u0001\t)\u00111!R7b\u0015\t\u0019A!\u0001\u0003vi&d'BA\u0003\u0007\u0003\u001d1\u0017N\\1hY\u0016T!a\u0002\u0005\u0002\u000fQ<\u0018\u000e\u001e;fe*\t\u0011\"A\u0002d_6\u001c\"\u0001A\u0006\u0011\u00051yQ\"A\u0007\u000b\u00039\tQa]2bY\u0006L!\u0001E\u0007\u0003\r\u0005s\u0017PU3g\u0011!\u0011\u0002A!A!\u0002\u0013!\u0012AB<j]\u0012|wo\u0001\u0001\u0011\u00051)\u0012B\u0001\f\u000e\u0005\u0011auN\\4\t\u000ba\u0001A\u0011A\r\u0002\rqJg.\u001b;?)\tQB\u0004\u0005\u0002\u001c\u00015\t!\u0001C\u0003\u0013/\u0001\u0007A\u0003\u0003\u0004\u001f\u0001\u0001\u0006K\u0001F\u0001\u0005i&lW\r\u0003\u0004!\u0001\u0001\u0006K!I\u0001\u0004K6\f\u0007C\u0001\u0007#\u0013\t\u0019SB\u0001\u0004E_V\u0014G.\u001a\u0005\u0006K\u0001!\tAJ\u0001\bSN,U\u000e\u001d;z+\u00059\u0003C\u0001\u0007)\u0013\tISBA\u0004C_>dW-\u00198\t\u000b-\u0002A\u0011\u0001\u0017\u0002\rU\u0004H-\u0019;f)\r\tSf\f\u0005\u0006])\u0002\r\u0001F\u0001\u0006gR\fW\u000e\u001d\u0005\u0006a)\u0002\r\u0001F\u0001\u0002q\")!\u0007\u0001C\u0001g\u0005!A.Y:u+\u0005\t\u0003\"B\u001b\u0001\t\u00031\u0014!\u0002:fg\u0016$H#A\u001c\u0011\u00051A\u0014BA\u001d\u000e\u0005\u0011)f.\u001b;\b\rm\u0012\u0001\u0012\u0001\u0003=\u0003\r)U.\u0019\t\u00037u2a!\u0001\u0002\t\u0002\u0011q4CA\u001f\f\u0011\u0015AR\b\"\u0001A)\u0005ad\u0001\u0002\">\u0001\r\u0013\u0001\"T8o_RLW.Z\n\u0003\u0003.AQ\u0001G!\u0005\u0002\u0015#\u0012A\u0012\t\u0003\u000f\u0006k\u0011!\u0010\u0005\u0007e\u0005\u0003\u000b\u0015\u0002\u000b\t\u000b)\u000bE\u0011A&\u0002\u000b9\fgn\\:\u0015\u0003Q\u0001")
public class Ema {
    private final long window;
    private long time;
    private double ema;

    public synchronized boolean isEmpty() {
        return this.time < 0L;
    }

    public synchronized double update(long stamp, long x) {
        if (this.time == Long.MIN_VALUE) {
            this.time = stamp;
            this.ema = x;
        } else {
            long td = stamp - this.time;
            Predef$.MODULE$.assert(td >= 0L, (Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Nonmonotonic timestamp";
                }
            });
            this.time = stamp;
            double w = this.window == 0L ? 0.0 : package$.MODULE$.exp(-((double)td) / (double)this.window);
            this.ema = (double)x * (1.0 - w) + this.ema * w;
        }
        return this.ema;
    }

    public synchronized double last() {
        return this.ema;
    }

    public synchronized void reset() {
        this.time = Long.MIN_VALUE;
        this.ema = 0.0;
    }

    public Ema(long window) {
        this.window = window;
        this.time = Long.MIN_VALUE;
        this.ema = 0.0;
    }

    public static class Monotime {
        private long last = System.nanoTime();

        public synchronized long nanos() {
            long sample = System.nanoTime();
            if (sample - this.last > 0L) {
                this.last = sample;
            }
            return this.last;
        }
    }
}

