/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.input;

import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.asterix.common.api.IApplicationContext;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.common.exceptions.ErrorCode;
import org.apache.asterix.common.external.IExternalFilterEvaluatorFactory;
import org.apache.asterix.external.api.AsterixInputStream;
import org.apache.asterix.external.api.IExternalDataRuntimeContext;
import org.apache.asterix.external.api.IExternalDataSourceFactory;
import org.apache.asterix.external.api.IRecordReader;
import org.apache.asterix.external.api.IRecordReaderFactory;
import org.apache.asterix.external.input.filter.embedder.IExternalFilterValueEmbedder;
import org.apache.asterix.external.input.record.reader.hdfs.HDFSRecordReader;
import org.apache.asterix.external.input.record.reader.hdfs.parquet.ParquetFileRecordReader;
import org.apache.asterix.external.input.record.reader.stream.StreamRecordReader;
import org.apache.asterix.external.input.stream.HDFSInputStream;
import org.apache.asterix.external.provider.StreamRecordReaderProvider;
import org.apache.asterix.external.provider.context.ExternalStreamRuntimeDataContext;
import org.apache.asterix.external.util.ExternalDataUtils;
import org.apache.asterix.external.util.HDFSUtils;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hyracks.algebricks.common.constraints.AlgebricksAbsolutePartitionConstraint;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.api.application.ICCServiceContext;
import org.apache.hyracks.api.application.IServiceContext;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.exceptions.IWarningCollector;
import org.apache.hyracks.api.util.ExceptionUtils;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.hdfs.dataflow.ConfFactory;
import org.apache.hyracks.hdfs.dataflow.InputSplitsFactory;
import org.apache.hyracks.hdfs.scheduler.Scheduler;

public class HDFSDataSourceFactory
implements IRecordReaderFactory<Object>,
IExternalDataSourceFactory {
    private static final long serialVersionUID = 1L;
    private static final List<String> recordReaderNames = Collections.singletonList("hdfs");
    protected transient AlgebricksAbsolutePartitionConstraint clusterLocations;
    protected transient IServiceContext serviceCtx;
    protected String[] readSchedule;
    protected boolean[] read;
    protected InputSplitsFactory inputSplitsFactory;
    protected ConfFactory confFactory;
    protected boolean configured = false;
    protected static Scheduler hdfsScheduler;
    protected static Boolean initialized;
    protected static Object initLock;
    protected Map<String, String> configuration;
    protected Class<?> recordClass;
    private JobConf conf;
    private InputSplit[] inputSplits;
    private String nodeName;
    private Class recordReaderClazz;
    private IExternalFilterEvaluatorFactory filterEvaluatorFactory;

    @Override
    public void configure(IServiceContext serviceCtx, Map<String, String> configuration, IWarningCollector warningCollector, IExternalFilterEvaluatorFactory filterEvaluatorFactory) throws AlgebricksException, HyracksDataException {
        JobConf hdfsConf = this.prepareHDFSConf(serviceCtx, configuration, filterEvaluatorFactory);
        this.configureHdfsConf(hdfsConf, configuration);
    }

    protected JobConf prepareHDFSConf(IServiceContext serviceCtx, Map<String, String> configuration, IExternalFilterEvaluatorFactory filterEvaluatorFactory) throws HyracksDataException {
        this.serviceCtx = serviceCtx;
        this.configuration = configuration;
        this.filterEvaluatorFactory = filterEvaluatorFactory;
        HDFSDataSourceFactory.init((ICCServiceContext)serviceCtx);
        return HDFSUtils.configureHDFSJobConf(configuration);
    }

    protected void configureHdfsConf(JobConf conf, Map<String, String> configuration) throws AlgebricksException {
        String formatString = configuration.get("format");
        try {
            this.confFactory = new ConfFactory(conf);
            this.clusterLocations = this.getPartitionConstraint();
            int numPartitions = this.clusterLocations.getLocations().length;
            InputSplit[] configInputSplits = this.getInputSplits(conf, numPartitions);
            this.readSchedule = hdfsScheduler.getLocationConstraints(configInputSplits);
            this.inputSplitsFactory = new InputSplitsFactory(configInputSplits);
            this.read = new boolean[this.readSchedule.length];
            Arrays.fill(this.read, false);
            if (formatString == null || formatString.equals("hdfs-writable")) {
                RecordReader reader = conf.getInputFormat().getRecordReader(configInputSplits[0], conf, Reporter.NULL);
                this.recordClass = reader.createValue().getClass();
                reader.close();
            } else if (formatString.equals("parquet")) {
                this.recordClass = IValueReference.class;
            } else {
                this.recordReaderClazz = StreamRecordReaderProvider.getRecordReaderClazz(configuration);
                this.recordClass = char[].class;
            }
        }
        catch (IOException e) {
            throw new CompilationException(ErrorCode.EXTERNAL_SOURCE_ERROR, (Throwable)e, new Serializable[]{ExceptionUtils.getMessageOrToString((Throwable)e)});
        }
        catch (Exception e) {
            if ("parquet".equals(formatString)) {
                String containerName = configuration.get("container");
                if (containerName != null && containerName.contains(".")) {
                    throw new CompilationException(ErrorCode.EXTERNAL_SOURCE_ERROR, (Throwable)e, new Serializable[]{ExceptionUtils.getMessageOrToString((Throwable)e) + " Buckets with '.' in the name can cause issues."});
                }
                throw e;
            }
            throw e;
        }
    }

    private InputSplit[] getInputSplits(JobConf conf, int numPartitions) throws IOException {
        if (HDFSUtils.isEmpty(conf)) {
            return Scheduler.EMPTY_INPUT_SPLITS;
        }
        return conf.getInputFormat().getSplits(conf, numPartitions);
    }

    public AsterixInputStream createInputStream(IHyracksTaskContext ctx) throws HyracksDataException {
        try {
            this.restoreConfig(ctx);
            return new HDFSInputStream(this.read, this.inputSplits, this.readSchedule, this.nodeName, this.conf, this.configuration);
        }
        catch (Exception e) {
            throw HyracksDataException.create((Throwable)e);
        }
    }

    private void restoreConfig(IHyracksTaskContext ctx) throws HyracksDataException {
        if (!this.configured) {
            this.conf = this.confFactory.getConf();
            this.inputSplits = this.inputSplitsFactory.getSplits();
            this.nodeName = ctx.getJobletContext().getServiceContext().getNodeId();
            this.configured = true;
        }
    }

    @Override
    public AlgebricksAbsolutePartitionConstraint getPartitionConstraint() {
        this.clusterLocations = HDFSUtils.getPartitionConstraints((IApplicationContext)this.serviceCtx.getApplicationContext(), this.clusterLocations);
        return this.clusterLocations;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void init(ICCServiceContext serviceCtx) throws HyracksDataException {
        if (!initialized.booleanValue()) {
            Object object = initLock;
            synchronized (object) {
                if (!initialized.booleanValue()) {
                    hdfsScheduler = HDFSUtils.initializeHDFSScheduler(serviceCtx);
                    initialized = true;
                }
            }
        }
    }

    @Override
    public IExternalDataSourceFactory.DataSourceType getDataSourceType() {
        return ExternalDataUtils.getDataSourceType(this.configuration);
    }

    @Override
    public IRecordReader<?> createRecordReader(IExternalDataRuntimeContext context) throws HyracksDataException {
        IHyracksTaskContext ctx = context.getTaskContext();
        try {
            if (this.recordReaderClazz != null) {
                StreamRecordReader streamReader = (StreamRecordReader)this.recordReaderClazz.getConstructor(new Class[0]).newInstance(new Object[0]);
                streamReader.configure(ctx, this.createInputStream(ctx), this.configuration);
                return streamReader;
            }
            this.restoreConfig(ctx);
            JobConf readerConf = this.conf;
            if (ctx.getWarningCollector().shouldWarn() && this.configuration.get("input-format".trim()).equals("parquet-input-format")) {
                readerConf = this.confFactory.getConf();
            }
            return HDFSDataSourceFactory.createRecordReader(this.configuration, this.read, this.inputSplits, this.readSchedule, this.nodeName, readerConf, context);
        }
        catch (Exception e) {
            throw HyracksDataException.create((Throwable)e);
        }
    }

    @Override
    public Class<?> getRecordClass() {
        return this.recordClass;
    }

    @Override
    public List<String> getRecordReaderNames() {
        return recordReaderNames;
    }

    @Override
    public IExternalDataRuntimeContext createExternalDataRuntimeContext(IHyracksTaskContext context, int partition) {
        IExternalFilterValueEmbedder valueEmbedder = (IExternalFilterValueEmbedder)this.filterEvaluatorFactory.createValueEmbedder(context.getWarningCollector());
        return new ExternalStreamRuntimeDataContext(context, partition, valueEmbedder);
    }

    private static IRecordReader<?> createRecordReader(Map<String, String> configuration, boolean[] read, InputSplit[] inputSplits, String[] readSchedule, String nodeName, JobConf conf, IExternalDataRuntimeContext context) {
        if (configuration.get("input-format".trim()).equals("parquet-input-format")) {
            return new ParquetFileRecordReader(read, inputSplits, readSchedule, nodeName, conf, context);
        }
        return new HDFSRecordReader(read, inputSplits, readSchedule, nodeName, conf);
    }

    static {
        initialized = false;
        initLock = new Object();
    }
}

