/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.algebricks.runtime.operators.writer;

import java.nio.ByteBuffer;
import org.apache.hyracks.algebricks.runtime.operators.base.AbstractOneInputSinkPushRuntime;
import org.apache.hyracks.algebricks.runtime.writers.IExternalWriter;
import org.apache.hyracks.api.comm.IFrameTupleAccessor;
import org.apache.hyracks.api.comm.IFrameWriter;
import org.apache.hyracks.api.dataflow.value.IBinaryComparator;
import org.apache.hyracks.api.dataflow.value.RecordDescriptor;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.VoidPointable;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.dataflow.common.comm.io.FrameTupleAccessor;
import org.apache.hyracks.dataflow.common.data.accessors.FrameTupleReference;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;
import org.apache.hyracks.dataflow.common.data.accessors.PermutingFrameTupleReference;
import org.apache.hyracks.dataflow.common.data.accessors.PointableTupleReference;
import org.apache.hyracks.dataflow.std.group.preclustered.PreclusteredGroupWriter;

final class SinkExternalWriterRuntime
extends AbstractOneInputSinkPushRuntime {
    private final int sourceColumn;
    private final int[] partitionColumns;
    private final IPointable sourceValue;
    private final PointableTupleReference partitionColumnsPrevCopy;
    private final PermutingFrameTupleReference partitionColumnsRef;
    private final IBinaryComparator[] partitionComparators;
    private final IExternalWriter writer;
    private FrameTupleAccessor tupleAccessor;
    private FrameTupleReference tupleRef;
    private boolean first;
    private IFrameWriter frameWriter;

    SinkExternalWriterRuntime(int sourceColumn, int[] partitionColumns, IBinaryComparator[] partitionComparators, RecordDescriptor inputRecordDesc, IExternalWriter writer) {
        this.sourceColumn = sourceColumn;
        this.partitionColumns = partitionColumns;
        this.sourceValue = new VoidPointable();
        this.partitionColumnsRef = new PermutingFrameTupleReference(partitionColumns);
        this.partitionColumnsPrevCopy = PointableTupleReference.create((int)partitionColumns.length, ArrayBackedValueStorage::new);
        this.partitionComparators = partitionComparators;
        this.inputRecordDesc = inputRecordDesc;
        this.writer = writer;
        this.first = true;
    }

    public void open() throws HyracksDataException {
        if (this.tupleAccessor == null) {
            this.writer.open();
            this.tupleAccessor = new FrameTupleAccessor(this.inputRecordDesc);
            this.tupleRef = new FrameTupleReference();
        }
        this.frameWriter.open();
    }

    public void nextFrame(ByteBuffer buffer) throws HyracksDataException {
        this.tupleAccessor.reset(buffer);
        for (int i = 0; i < this.tupleAccessor.getTupleCount(); ++i) {
            this.tupleRef.reset((IFrameTupleAccessor)this.tupleAccessor, i);
            if (this.isNewPartition(i)) {
                this.writer.initNewPartition((IFrameTupleReference)this.tupleRef);
            }
            this.setValue((IFrameTupleReference)this.tupleRef, this.sourceColumn, this.sourceValue);
            this.writer.write((IValueReference)this.sourceValue);
            this.partitionColumnsRef.reset((IFrameTupleAccessor)this.tupleAccessor, i);
            this.partitionColumnsPrevCopy.set((ITupleReference)this.partitionColumnsRef);
        }
    }

    public void fail() throws HyracksDataException {
        this.writer.abort();
        this.frameWriter.fail();
    }

    public void close() throws HyracksDataException {
        this.writer.close();
        this.frameWriter.close();
    }

    @Override
    public void setOutputFrameWriter(int index, IFrameWriter frameWriter, RecordDescriptor recordDesc) {
        this.frameWriter = frameWriter;
    }

    private boolean isNewPartition(int index) throws HyracksDataException {
        if (this.first) {
            this.first = false;
            return true;
        }
        return !PreclusteredGroupWriter.sameGroup((ITupleReference)this.partitionColumnsPrevCopy, (IFrameTupleAccessor)this.tupleAccessor, (int)index, (int[])this.partitionColumns, (IBinaryComparator[])this.partitionComparators);
    }

    private void setValue(IFrameTupleReference tuple, int column, IPointable value) {
        byte[] data = tuple.getFieldData(column);
        int start = tuple.getFieldStart(column);
        int length = tuple.getFieldLength(column);
        value.set(data, start, length);
    }
}

