/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.common.metadata;

import java.io.File;
import org.apache.asterix.common.api.INamespacePathResolver;
import org.apache.asterix.common.metadata.DataverseName;
import org.apache.asterix.common.metadata.MetadataConstants;
import org.apache.asterix.common.metadata.Namespace;
import org.apache.asterix.common.utils.StoragePathUtil;

public class NamespacePathResolver
implements INamespacePathResolver {
    private final boolean usingDatabase;

    public NamespacePathResolver(boolean usingDatabase) {
        this.usingDatabase = usingDatabase;
    }

    @Override
    public String resolve(Namespace namespace) {
        DataverseName dataverseName = namespace.getDataverseName();
        if (this.usingDatabase) {
            if (MetadataConstants.METADATA_DATAVERSE_NAME.equals(dataverseName)) {
                return StoragePathUtil.prepareDataverseName(dataverseName);
            }
            return namespace.getDatabaseName() + File.separatorChar + StoragePathUtil.prepareDataverseName(dataverseName);
        }
        return StoragePathUtil.prepareDataverseName(dataverseName);
    }

    @Override
    public String resolve(String databaseName, DataverseName dataverseName) {
        if (this.usingDatabase) {
            if (MetadataConstants.METADATA_DATAVERSE_NAME.equals(dataverseName)) {
                return StoragePathUtil.prepareDataverseName(dataverseName);
            }
            return databaseName + File.separatorChar + StoragePathUtil.prepareDataverseName(dataverseName);
        }
        return StoragePathUtil.prepareDataverseName(dataverseName);
    }

    @Override
    public boolean usingDatabase() {
        return this.usingDatabase;
    }
}

