/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.common.config;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.asterix.common.cluster.ClusterPartition;
import org.apache.asterix.common.config.AsterixExtension;
import org.apache.asterix.common.config.AsterixProperties;
import org.apache.asterix.common.config.NodeProperties;
import org.apache.asterix.common.exceptions.AsterixException;
import org.apache.asterix.common.exceptions.ErrorCode;
import org.apache.asterix.common.utils.PrintUtil;
import org.apache.commons.lang3.mutable.MutableInt;
import org.apache.hyracks.algebricks.common.utils.Pair;
import org.apache.hyracks.api.config.IApplicationConfig;
import org.apache.hyracks.api.config.IOption;
import org.apache.hyracks.api.config.IOptionType;
import org.apache.hyracks.api.config.Section;
import org.apache.hyracks.control.common.application.ConfigManagerApplicationConfig;
import org.apache.hyracks.control.common.config.ConfigManager;
import org.apache.hyracks.control.common.controllers.NCConfig;
import org.apache.hyracks.util.file.FileUtil;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;

public class PropertiesAccessor
implements IApplicationConfig {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Map<IApplicationConfig, PropertiesAccessor> instances = new ConcurrentHashMap<IApplicationConfig, PropertiesAccessor>();
    private final Map<String, String[]> stores = new HashMap<String, String[]>();
    private final Map<String, String> coredumpConfig = new HashMap<String, String>();
    private final IApplicationConfig cfg;
    private final Map<String, String> transactionLogDirs = new HashMap<String, String>();
    private final Map<String, String> asterixBuildProperties = new HashMap<String, String>();
    private final Map<String, ClusterPartition[]> nodePartitionsMap;
    private final SortedMap<Integer, ClusterPartition> clusterPartitions;
    private final List<AsterixExtension> extensions;

    private PropertiesAccessor(IApplicationConfig cfg) throws AsterixException {
        this.cfg = cfg;
        this.nodePartitionsMap = new ConcurrentHashMap<String, ClusterPartition[]>();
        this.clusterPartitions = Collections.synchronizedSortedMap(new TreeMap());
        this.extensions = new ArrayList<AsterixExtension>();
        ConfigManager configManager = ((ConfigManagerApplicationConfig)cfg).getConfigManager();
        MutableInt uniquePartitionId = new MutableInt(0);
        for (String ncName : cfg.getNCNames()) {
            this.configureNc(configManager, ncName, uniquePartitionId);
        }
        LOGGER.info("configured partitions: {} from config {}", new Supplier[]{() -> PrintUtil.toString(this.nodePartitionsMap), () -> cfg});
        for (String section : cfg.getSectionNames()) {
            if (!section.startsWith("extension/")) continue;
            String className = AsterixProperties.getSectionId("extension/", section);
            this.configureExtension(className, section);
        }
        this.loadAsterixBuildProperties();
    }

    private void configureExtension(String className, String section) {
        Set keys = this.cfg.getKeys(section);
        ArrayList<Pair<String, String>> kvs = new ArrayList<Pair<String, String>>();
        for (String key : keys) {
            String value = this.cfg.getString(section, key);
            kvs.add((Pair<String, String>)new Pair((Object)key, (Object)value));
        }
        this.extensions.add(new AsterixExtension(className, kvs));
    }

    private void configureNc(ConfigManager configManager, String ncId, MutableInt uniquePartitionId) throws AsterixException {
        IApplicationConfig nodeCfg = this.cfg.getNCEffectiveConfig(ncId);
        this.coredumpConfig.put(ncId, nodeCfg.getString((IOption)NodeProperties.Option.CORE_DUMP_DIR));
        this.transactionLogDirs.put(ncId, nodeCfg.getString((IOption)NodeProperties.Option.TXN_LOG_DIR));
        int partitionId = nodeCfg.getInt((IOption)NodeProperties.Option.STARTING_PARTITION_ID);
        if (partitionId != -1) {
            uniquePartitionId.setValue(partitionId);
        } else {
            configManager.set(ncId, (IOption)NodeProperties.Option.STARTING_PARTITION_ID, (Object)uniquePartitionId.getValue());
        }
        String[] iodevices = nodeCfg.getStringArray((IOption)NCConfig.Option.IODEVICES);
        String[] nodeStores = new String[iodevices.length];
        ClusterPartition[] nodePartitions = new ClusterPartition[iodevices.length];
        for (int i = 0; i < nodePartitions.length; ++i) {
            nodeStores[i] = FileUtil.joinPath((String[])new String[]{iodevices[i], "storage"});
            ClusterPartition partition = new ClusterPartition(uniquePartitionId.getAndIncrement(), ncId, i);
            ClusterPartition orig = this.clusterPartitions.put(partition.getPartitionId(), partition);
            if (orig != null) {
                throw AsterixException.create(ErrorCode.DUPLICATE_PARTITION_ID, new Serializable[]{Integer.valueOf(partition.getPartitionId()), ncId, orig.getNodeId()});
            }
            nodePartitions[i] = partition;
        }
        this.stores.put(ncId, nodeStores);
        this.nodePartitionsMap.put(ncId, nodePartitions);
    }

    private void loadAsterixBuildProperties() throws AsterixException {
        Properties gitProperties = new Properties();
        try {
            InputStream propertyStream = this.getClass().getClassLoader().getResourceAsStream("git.properties");
            if (propertyStream != null) {
                gitProperties.load(propertyStream);
                for (String name : gitProperties.stringPropertyNames()) {
                    this.asterixBuildProperties.put(name, gitProperties.getProperty(name));
                }
            } else {
                LOGGER.info("Build properties not found on classpath. Version API will return empty object");
            }
        }
        catch (IOException e) {
            throw new AsterixException(e);
        }
    }

    public Map<String, String[]> getStores() {
        return this.stores;
    }

    public String getCoredumpPath(String nodeId) {
        return this.coredumpConfig.get(nodeId);
    }

    public Map<String, String> getTransactionLogDirs() {
        return this.transactionLogDirs;
    }

    public Map<String, String> getCoredumpConfig() {
        return this.coredumpConfig;
    }

    public Map<String, String> getBuildProperties() {
        return this.asterixBuildProperties;
    }

    public <T> T getProperty(String property, T defaultValue, IOptionType<T> interpreter) {
        String value = this.cfg.getString("common", property);
        try {
            return (T)(value == null ? defaultValue : interpreter.parse(value));
        }
        catch (IllegalArgumentException e) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error("Invalid property value '" + value + "' for property '" + property + "'.\nDefault = " + defaultValue);
            }
            throw e;
        }
    }

    public Map<String, ClusterPartition[]> getNodePartitions() {
        return this.nodePartitionsMap;
    }

    public SortedMap<Integer, ClusterPartition> getClusterPartitions() {
        return this.clusterPartitions;
    }

    public Set<Integer> getNodePartitions(String nodeId) {
        ClusterPartition[] nodeClusterPartitions = this.nodePartitionsMap.get(nodeId);
        return Arrays.stream(nodeClusterPartitions).map(ClusterPartition::getPartitionId).collect(Collectors.toSet());
    }

    public List<AsterixExtension> getExtensions() {
        return this.extensions;
    }

    public static PropertiesAccessor getInstance(IApplicationConfig cfg) throws AsterixException {
        PropertiesAccessor accessor = instances.get(cfg);
        if (accessor == null && instances.putIfAbsent(cfg, accessor = new PropertiesAccessor(cfg)) != null) {
            return instances.get(cfg);
        }
        return accessor;
    }

    public Object getStatic(IOption option) {
        return this.cfg.getStatic(option);
    }

    public String getString(String section, String key) {
        return this.cfg.getString(section, key);
    }

    public int getInt(String section, String key) {
        return this.cfg.getInt(section, key);
    }

    public long getLong(String section, String key) {
        return this.cfg.getLong(section, key);
    }

    public Set<String> getSectionNames() {
        return this.cfg.getSectionNames();
    }

    public Set<String> getKeys(String section) {
        return this.cfg.getKeys(section);
    }

    public List<String> getNCNames() {
        return this.cfg.getNCNames();
    }

    public IOption lookupOption(String sectionName, String propertyName) {
        return this.cfg.lookupOption(sectionName, propertyName);
    }

    public IApplicationConfig getNCEffectiveConfig(String nodeId) {
        return this.cfg.getNCEffectiveConfig(nodeId);
    }

    public Set<IOption> getOptions() {
        return this.cfg.getOptions();
    }

    public Set<IOption> getOptions(Section section) {
        return this.cfg.getOptions(section);
    }

    public Set<Section> getSections() {
        return this.cfg.getSections();
    }

    public Set<Section> getSections(Predicate<Section> predicate) {
        return this.cfg.getSections(predicate);
    }
}

