/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.column.bytes.decoder;

import java.io.IOException;
import java.io.InputStream;
import org.apache.asterix.column.bytes.decoder.AbstractParquetValuesReader;
import org.apache.asterix.column.bytes.decoder.ParquetDeltaBinaryPackingValuesReader;
import org.apache.asterix.column.bytes.stream.in.AbstractBytesInputStream;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.VoidPointable;
import org.apache.parquet.bytes.BytesUtils;
import org.apache.parquet.io.ParquetDecodingException;

public class ParquetDeltaLengthByteArrayValuesReader
extends AbstractParquetValuesReader {
    private final VoidPointable value;
    private final AbstractParquetValuesReader lengthReader = new ParquetDeltaBinaryPackingValuesReader();
    private AbstractBytesInputStream in;

    public ParquetDeltaLengthByteArrayValuesReader() {
        this.value = new VoidPointable();
    }

    @Override
    public void initFromPage(AbstractBytesInputStream stream) throws IOException {
        AbstractBytesInputStream lengthStream = stream.sliceStream(BytesUtils.readUnsignedVarInt((InputStream)stream));
        this.lengthReader.initFromPage(lengthStream);
        this.in = stream;
    }

    @Override
    public void skip() {
        int length = this.lengthReader.readInteger();
        try {
            this.in.skipFully(length);
        }
        catch (IOException e) {
            throw new ParquetDecodingException("Failed to skip " + length + " bytes");
        }
    }

    @Override
    public IValueReference readBytes() {
        int length = this.lengthReader.readInteger();
        try {
            this.in.read((IPointable)this.value, length);
            return this.value;
        }
        catch (IOException e) {
            throw new ParquetDecodingException("Failed to read " + length + " bytes");
        }
    }
}

