/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.lang.sqlpp.visitor;

import java.io.Serializable;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.common.exceptions.ErrorCode;
import org.apache.asterix.common.functions.FunctionSignature;
import org.apache.asterix.lang.common.base.IVisitorExtension;
import org.apache.asterix.lang.common.expression.CallExpr;
import org.apache.asterix.lang.common.visitor.base.ILangVisitor;
import org.apache.asterix.lang.sqlpp.visitor.base.AbstractSqlppContainsExpressionVisitor;
import org.apache.asterix.metadata.declared.MetadataProvider;
import org.apache.asterix.metadata.entities.Function;
import org.apache.asterix.om.functions.BuiltinFunctionInfo;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;

public final class CheckNonFunctionalExpressionVisitor
extends AbstractSqlppContainsExpressionVisitor<Void> {
    private final MetadataProvider metadataProvider;

    public CheckNonFunctionalExpressionVisitor(MetadataProvider metadataProvider) {
        this.metadataProvider = metadataProvider;
    }

    @Override
    public Boolean visit(CallExpr callExpr, Void arg) throws CompilationException {
        FunctionSignature fs = callExpr.getFunctionSignature();
        BuiltinFunctionInfo finfo = BuiltinFunctions.getBuiltinFunctionInfo((FunctionIdentifier)fs.createFunctionIdentifier());
        if (finfo != null) {
            if (!finfo.isFunctional()) {
                return true;
            }
        } else {
            Function function;
            try {
                function = this.metadataProvider.lookupUserDefinedFunction(fs);
            }
            catch (AlgebricksException e) {
                throw new CompilationException(ErrorCode.METADATA_ERROR, (Throwable)e, callExpr.getSourceLocation(), new Serializable[]{e.toString()});
            }
            if (function == null || function.getDeterministic() == null) {
                throw new CompilationException(ErrorCode.COMPILATION_ILLEGAL_STATE, callExpr.getSourceLocation(), new Serializable[]{fs});
            }
            if (!function.getDeterministic().booleanValue()) {
                return true;
            }
        }
        return super.visit(callExpr, (Object)arg);
    }

    public Boolean visit(IVisitorExtension ve, Void arg) throws CompilationException {
        return ve.checkNonFunctionalDispatch((ILangVisitor)this);
    }
}

