/*
 * Decompiled with CFR 0.152.
 */
package io.opencensus.implcore.stats;

import com.google.common.base.Preconditions;
import io.opencensus.common.Clock;
import io.opencensus.implcore.internal.CurrentState;
import io.opencensus.implcore.internal.EventQueue;
import io.opencensus.implcore.stats.MetricProducerImpl;
import io.opencensus.implcore.stats.StatsManager;
import io.opencensus.implcore.stats.StatsRecorderImpl;
import io.opencensus.implcore.stats.ViewManagerImpl;
import io.opencensus.metrics.Metrics;
import io.opencensus.metrics.export.MetricProducer;
import io.opencensus.stats.StatsCollectionState;
import io.opencensus.stats.StatsComponent;

public class StatsComponentImplBase
extends StatsComponent {
    private static final CurrentState.State DEFAULT_STATE = CurrentState.State.ENABLED;
    private final CurrentState currentState = new CurrentState(DEFAULT_STATE);
    private final ViewManagerImpl viewManager;
    private final StatsRecorderImpl statsRecorder;

    public StatsComponentImplBase(EventQueue queue, Clock clock) {
        StatsManager statsManager = new StatsManager(queue, clock, this.currentState);
        this.viewManager = new ViewManagerImpl(statsManager);
        this.statsRecorder = new StatsRecorderImpl(statsManager);
        MetricProducerImpl metricProducer = new MetricProducerImpl(statsManager);
        Metrics.getExportComponent().getMetricProducerManager().add((MetricProducer)metricProducer);
    }

    public ViewManagerImpl getViewManager() {
        return this.viewManager;
    }

    public StatsRecorderImpl getStatsRecorder() {
        return this.statsRecorder;
    }

    public StatsCollectionState getState() {
        return StatsComponentImplBase.stateToStatsState(this.currentState.get());
    }

    public synchronized void setState(StatsCollectionState newState) {
        boolean stateChanged = this.currentState.set(StatsComponentImplBase.statsStateToState((StatsCollectionState)Preconditions.checkNotNull((Object)newState, (Object)"newState")));
        if (stateChanged) {
            if (newState == StatsCollectionState.DISABLED) {
                this.viewManager.clearStats();
            } else {
                this.viewManager.resumeStatsCollection();
            }
        }
    }

    private static CurrentState.State statsStateToState(StatsCollectionState statsCollectionState) {
        return statsCollectionState == StatsCollectionState.ENABLED ? CurrentState.State.ENABLED : CurrentState.State.DISABLED;
    }

    private static StatsCollectionState stateToStatsState(CurrentState.State state) {
        return state == CurrentState.State.ENABLED ? StatsCollectionState.ENABLED : StatsCollectionState.DISABLED;
    }
}

