/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.control.nc.io;

import java.io.File;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.io.IFileDeviceResolver;
import org.apache.hyracks.api.io.IODeviceHandle;

public class DefaultDeviceResolver
implements IFileDeviceResolver {
    private AtomicInteger next = new AtomicInteger(0);

    public IODeviceHandle resolve(String relPath, List<IODeviceHandle> devices) throws HyracksDataException {
        int numDevices = devices.size();
        String path = relPath;
        if (numDevices == 1) {
            return devices.get(0);
        }
        int nextSeparator = path.lastIndexOf(File.separator);
        while (nextSeparator > 0) {
            for (IODeviceHandle dev : devices) {
                if (!dev.contains(path)) continue;
                return dev;
            }
            path = path.substring(0, nextSeparator);
            nextSeparator = path.lastIndexOf(File.separator);
        }
        for (IODeviceHandle dev : devices) {
            if (!dev.contains(path)) continue;
            return dev;
        }
        return devices.get(this.next.getAndIncrement() % numDevices);
    }
}

