/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.input.stream;

import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import org.apache.asterix.external.api.AsterixInputStream;
import org.apache.hyracks.algebricks.common.utils.Pair;

public class SocketClientInputStream
extends AsterixInputStream {
    private final Socket socket;
    private InputStream in;

    public SocketClientInputStream(Pair<String, Integer> address) throws IOException {
        this.socket = new Socket((String)address.first, (int)((Integer)address.second));
        this.in = this.socket.getInputStream();
    }

    @Override
    public int read() throws IOException {
        return this.in.read();
    }

    @Override
    public int read(byte[] buffer, int offset, int length) throws IOException {
        return this.in.read(buffer, offset, length);
    }

    @Override
    public boolean stop() throws Exception {
        if (!this.socket.isClosed()) {
            this.socket.close();
        }
        return true;
    }

    @Override
    public boolean handleException(Throwable th) {
        return false;
    }
}

