/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.om.typecomputer.impl;

import org.apache.asterix.om.exceptions.TypeMismatchException;
import org.apache.asterix.om.typecomputer.base.IResultTypeComputer;
import org.apache.asterix.om.typecomputer.impl.TypeComputeUtils;
import org.apache.asterix.om.types.AOrderedListType;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.IAType;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.AbstractFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.IVariableTypeEnvironment;
import org.apache.hyracks.algebricks.core.algebra.metadata.IMetadataProvider;

public class ScalarArrayAggTypeComputer
implements IResultTypeComputer {
    public static final IResultTypeComputer INSTANCE = new ScalarArrayAggTypeComputer();

    private ScalarArrayAggTypeComputer() {
    }

    @Override
    public IAType computeType(ILogicalExpression expression, IVariableTypeEnvironment env, IMetadataProvider<?, ?> metadataProvider) throws AlgebricksException {
        AbstractFunctionCallExpression fun = (AbstractFunctionCallExpression)expression;
        IAType argType = (IAType)env.getType((ILogicalExpression)((Mutable)fun.getArguments().get(0)).getValue());
        IAType itemType = TypeComputeUtils.extractListItemType(argType);
        if (itemType == null) {
            throw new TypeMismatchException(fun.getSourceLocation(), fun.getFunctionIdentifier(), 0, argType.getTypeTag(), ATypeTag.MULTISET, ATypeTag.ARRAY);
        }
        return new AOrderedListType(itemType, null);
    }
}

