/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.api.dataflow;

import java.util.HashMap;
import org.apache.hyracks.api.comm.IFrameWriter;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.IOperatorNodePushable;
import org.apache.hyracks.api.dataflow.IPassableTimer;
import org.apache.hyracks.api.dataflow.TimedFrameWriter;
import org.apache.hyracks.api.dataflow.value.RecordDescriptor;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.job.profiling.IStatsCollector;
import org.apache.hyracks.api.rewriter.runtime.SuperActivityOperatorNodePushable;

public class TimedOperatorNodePushable
extends TimedFrameWriter
implements IOperatorNodePushable,
IPassableTimer {
    IOperatorNodePushable op;
    HashMap<Integer, IFrameWriter> inputs;
    long frameStart;

    TimedOperatorNodePushable(IOperatorNodePushable op, IStatsCollector collector) throws HyracksDataException {
        super(null, collector, op.getDisplayName());
        this.op = op;
        this.inputs = new HashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initialize() throws HyracksDataException {
        IStatsCollector iStatsCollector = this.collector;
        synchronized (iStatsCollector) {
            this.startClock();
            this.op.initialize();
            this.stopClock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deinitialize() throws HyracksDataException {
        IStatsCollector iStatsCollector = this.collector;
        synchronized (iStatsCollector) {
            this.startClock();
            this.op.deinitialize();
            this.stopClock();
        }
    }

    @Override
    public int getInputArity() {
        return this.op.getInputArity();
    }

    @Override
    public void setOutputFrameWriter(int index, IFrameWriter writer, RecordDescriptor recordDesc) throws HyracksDataException {
        this.op.setOutputFrameWriter(index, writer, recordDesc);
    }

    @Override
    public IFrameWriter getInputFrameWriter(int index) {
        IFrameWriter ifw = this.op.getInputFrameWriter(index);
        if (!(this.op instanceof TimedFrameWriter) && ifw.equals(this.op)) {
            return new TimedFrameWriter(this.op.getInputFrameWriter(index), this.collector, this.op.getDisplayName(), this.counter);
        }
        return this.op.getInputFrameWriter(index);
    }

    @Override
    public String getDisplayName() {
        return this.op.getDisplayName();
    }

    private void stopClock() {
        this.pause();
        this.collector.giveClock(this);
    }

    private void startClock() {
        if (this.frameStart > 0L) {
            return;
        }
        this.frameStart = this.collector.takeClock(this);
    }

    @Override
    public void resume() {
        long nt;
        if (this.frameStart > 0L) {
            return;
        }
        this.frameStart = nt = System.nanoTime();
    }

    @Override
    public void pause() {
        if (this.frameStart > 0L) {
            long nt = System.nanoTime();
            long delta = nt - this.frameStart;
            this.counter.update(delta);
            this.frameStart = -1L;
        }
    }

    public static IOperatorNodePushable time(IOperatorNodePushable op, IHyracksTaskContext ctx) throws HyracksDataException {
        if (!(op instanceof TimedOperatorNodePushable) && !(op instanceof SuperActivityOperatorNodePushable)) {
            return new TimedOperatorNodePushable(op, ctx.getStatsCollector());
        }
        return op;
    }
}

