/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.om.base.temporal;

import java.io.DataOutput;
import java.io.IOException;
import org.apache.asterix.om.base.temporal.ADateParserFactory;
import org.apache.asterix.om.base.temporal.ATimeParserFactory;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.dataflow.common.data.parsers.IValueParser;
import org.apache.hyracks.dataflow.common.data.parsers.IValueParserFactory;

public class ADateTimeParserFactory
implements IValueParserFactory {
    public static final IValueParserFactory INSTANCE = new ADateTimeParserFactory();
    private static final long serialVersionUID = 1L;
    private static final String dateTimeErrorMessage = "Wrong Input Format for a DateTime Value";

    private ADateTimeParserFactory() {
    }

    public IValueParser createValueParser() {
        return new IValueParser(){

            public boolean parse(char[] buffer, int start, int length, DataOutput out) throws HyracksDataException {
                long parsedDateTime = ADateTimeParserFactory.parseDateTimePart(buffer, start, length);
                try {
                    out.writeLong(parsedDateTime);
                    return true;
                }
                catch (IOException ex) {
                    throw HyracksDataException.create((Throwable)ex);
                }
            }
        };
    }

    public static long parseDateTimePart(String dateTimeString, int start, int length) throws HyracksDataException {
        long chrononTimeInMs = 0L;
        short timeOffset = (short)(dateTimeString.charAt(start) == '-' ? 1 : 0);
        timeOffset = (short)(timeOffset + 8);
        if (dateTimeString.charAt(start + timeOffset) != 'T' && dateTimeString.charAt(start + (timeOffset = (short)(timeOffset + 2))) != 'T') {
            throw new HyracksDataException("Wrong Input Format for a DateTime Value: missing T");
        }
        chrononTimeInMs = ADateParserFactory.parseDatePart(dateTimeString, start, (int)timeOffset);
        return chrononTimeInMs + (long)ATimeParserFactory.parseTimePart(dateTimeString, start + timeOffset + 1, length - timeOffset - 1);
    }

    public static long parseDateTimePart(char[] dateTimeString, int start, int length) throws HyracksDataException {
        long chrononTimeInMs = 0L;
        short timeOffset = (short)(dateTimeString[start] == '-' ? 1 : 0);
        timeOffset = (short)(timeOffset + 8);
        if (dateTimeString[start + timeOffset] != 'T' && dateTimeString[start + (timeOffset = (short)(timeOffset + 2))] != 'T') {
            throw new HyracksDataException("Wrong Input Format for a DateTime Value: missing T");
        }
        chrononTimeInMs = ADateParserFactory.parseDatePart(dateTimeString, start, (int)timeOffset);
        return chrononTimeInMs + (long)ATimeParserFactory.parseTimePart(dateTimeString, start + timeOffset + 1, length - timeOffset - 1);
    }
}

