/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.http.brave;

import brave.Span;
import brave.propagation.CurrentTraceContext;
import brave.propagation.TraceContext;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOutboundHandlerAdapter;
import io.netty.channel.ChannelPromise;
import reactor.netty.channel.ChannelOperations;
import reactor.netty.http.brave.ReactorNettyHttpTracing;
import reactor.netty.http.client.HttpClientRequest;

final class TracingChannelOutboundHandler
extends ChannelOutboundHandlerAdapter {
    static final String NAME = "reactor.right.tracingChannelOutboundHandler";
    final CurrentTraceContext currentTraceContext;

    TracingChannelOutboundHandler(CurrentTraceContext currentTraceContext) {
        this.currentTraceContext = currentTraceContext;
    }

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) {
        TraceContext parent;
        Span span = (Span)ctx.channel().attr(ReactorNettyHttpTracing.SPAN_ATTR_KEY).get();
        if (span != null) {
            try (CurrentTraceContext.Scope scope = this.currentTraceContext.maybeScope(span.context());){
                ctx.write(msg, promise);
            }
            return;
        }
        ChannelOperations ops = ChannelOperations.get((Channel)ctx.channel());
        if (ops instanceof HttpClientRequest && (parent = (TraceContext)((HttpClientRequest)ops).currentContextView().getOrDefault(TraceContext.class, null)) != null) {
            try (CurrentTraceContext.Scope scope = this.currentTraceContext.maybeScope(parent);){
                ctx.write(msg, promise);
            }
            return;
        }
        ctx.write(msg, promise);
    }

    public boolean isSharable() {
        return true;
    }
}

