/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.serde2.typeinfo;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.typeinfo.BaseCharTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.CharTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.DecimalTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.ListTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.MapTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.StructTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.hadoop.hive.serde2.typeinfo.UnionTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.VarcharTypeInfo;

public final class TypeInfoFactory {
    private static Log LOG = LogFactory.getLog(TypeInfoFactory.class);
    public static final PrimitiveTypeInfo voidTypeInfo = new PrimitiveTypeInfo("void");
    public static final PrimitiveTypeInfo booleanTypeInfo = new PrimitiveTypeInfo("boolean");
    public static final PrimitiveTypeInfo intTypeInfo = new PrimitiveTypeInfo("int");
    public static final PrimitiveTypeInfo longTypeInfo = new PrimitiveTypeInfo("bigint");
    public static final PrimitiveTypeInfo stringTypeInfo = new PrimitiveTypeInfo("string");
    public static final PrimitiveTypeInfo charTypeInfo = new CharTypeInfo(255);
    public static final PrimitiveTypeInfo varcharTypeInfo = new VarcharTypeInfo(65535);
    public static final PrimitiveTypeInfo floatTypeInfo = new PrimitiveTypeInfo("float");
    public static final PrimitiveTypeInfo doubleTypeInfo = new PrimitiveTypeInfo("double");
    public static final PrimitiveTypeInfo byteTypeInfo = new PrimitiveTypeInfo("tinyint");
    public static final PrimitiveTypeInfo shortTypeInfo = new PrimitiveTypeInfo("smallint");
    public static final PrimitiveTypeInfo dateTypeInfo = new PrimitiveTypeInfo("date");
    public static final PrimitiveTypeInfo timestampTypeInfo = new PrimitiveTypeInfo("timestamp");
    public static final PrimitiveTypeInfo binaryTypeInfo = new PrimitiveTypeInfo("binary");
    public static final DecimalTypeInfo decimalTypeInfo = new DecimalTypeInfo(38, 18);
    public static final PrimitiveTypeInfo unknownTypeInfo = new PrimitiveTypeInfo("unknown");
    private static ConcurrentHashMap<String, PrimitiveTypeInfo> cachedPrimitiveTypeInfo = new ConcurrentHashMap();
    static ConcurrentHashMap<ArrayList<List<?>>, TypeInfo> cachedStructTypeInfo;
    static ConcurrentHashMap<List<?>, TypeInfo> cachedUnionTypeInfo;
    static ConcurrentHashMap<TypeInfo, TypeInfo> cachedListTypeInfo;
    static ConcurrentHashMap<ArrayList<TypeInfo>, TypeInfo> cachedMapTypeInfo;

    private TypeInfoFactory() {
    }

    public static PrimitiveTypeInfo getPrimitiveTypeInfo(String typeName) {
        PrimitiveTypeInfo result = cachedPrimitiveTypeInfo.get(typeName);
        if (result != null) {
            return result;
        }
        result = TypeInfoFactory.createPrimitiveTypeInfo(typeName);
        if (result == null) {
            throw new RuntimeException("Error creating PrimitiveTypeInfo instance for " + typeName);
        }
        cachedPrimitiveTypeInfo.put(typeName, result);
        return result;
    }

    private static PrimitiveTypeInfo createPrimitiveTypeInfo(String fullName) {
        String baseName = TypeInfoUtils.getBaseName(fullName);
        PrimitiveObjectInspectorUtils.PrimitiveTypeEntry typeEntry = PrimitiveObjectInspectorUtils.getTypeEntryFromTypeName(baseName);
        if (null == typeEntry) {
            throw new RuntimeException("Unknown type " + fullName);
        }
        TypeInfoUtils.PrimitiveParts parts = TypeInfoUtils.parsePrimitiveParts(fullName);
        if (parts.typeParams == null || parts.typeParams.length < 1) {
            return null;
        }
        switch (typeEntry.primitiveCategory) {
            case CHAR: {
                if (parts.typeParams.length != 1) {
                    return null;
                }
                return new CharTypeInfo(Integer.valueOf(parts.typeParams[0]));
            }
            case VARCHAR: {
                if (parts.typeParams.length != 1) {
                    return null;
                }
                return new VarcharTypeInfo(Integer.valueOf(parts.typeParams[0]));
            }
            case DECIMAL: {
                if (parts.typeParams.length != 2) {
                    return null;
                }
                return new DecimalTypeInfo(Integer.valueOf(parts.typeParams[0]), Integer.valueOf(parts.typeParams[1]));
            }
        }
        return null;
    }

    public static CharTypeInfo getCharTypeInfo(int length) {
        String fullName = BaseCharTypeInfo.getQualifiedName("char", length);
        return (CharTypeInfo)TypeInfoFactory.getPrimitiveTypeInfo(fullName);
    }

    public static VarcharTypeInfo getVarcharTypeInfo(int length) {
        String fullName = BaseCharTypeInfo.getQualifiedName("varchar", length);
        return (VarcharTypeInfo)TypeInfoFactory.getPrimitiveTypeInfo(fullName);
    }

    public static DecimalTypeInfo getDecimalTypeInfo(int precision, int scale) {
        String fullName = DecimalTypeInfo.getQualifiedName(precision, scale);
        return (DecimalTypeInfo)TypeInfoFactory.getPrimitiveTypeInfo(fullName);
    }

    public static TypeInfo getPrimitiveTypeInfoFromPrimitiveWritable(Class<?> clazz) {
        String typeName = PrimitiveObjectInspectorUtils.getTypeNameFromPrimitiveWritable(clazz);
        if (typeName == null) {
            throw new RuntimeException("Internal error: Cannot get typeName for " + clazz);
        }
        return TypeInfoFactory.getPrimitiveTypeInfo(typeName);
    }

    public static TypeInfo getPrimitiveTypeInfoFromJavaPrimitive(Class<?> clazz) {
        return TypeInfoFactory.getPrimitiveTypeInfo(PrimitiveObjectInspectorUtils.getTypeNameFromPrimitiveJava(clazz));
    }

    public static TypeInfo getStructTypeInfo(List<String> names, List<TypeInfo> typeInfos) {
        ArrayList<List<Object>> signature = new ArrayList<List<Object>>(2);
        signature.add(names);
        signature.add(typeInfos);
        TypeInfo result = cachedStructTypeInfo.get(signature);
        if (result == null) {
            result = new StructTypeInfo(names, typeInfos);
            cachedStructTypeInfo.put(signature, result);
        }
        return result;
    }

    public static TypeInfo getUnionTypeInfo(List<TypeInfo> typeInfos) {
        TypeInfo result = cachedUnionTypeInfo.get(typeInfos);
        if (result == null) {
            result = new UnionTypeInfo(typeInfos);
            cachedUnionTypeInfo.put(typeInfos, result);
        }
        return result;
    }

    public static TypeInfo getListTypeInfo(TypeInfo elementTypeInfo) {
        TypeInfo result = cachedListTypeInfo.get(elementTypeInfo);
        if (result == null) {
            result = new ListTypeInfo(elementTypeInfo);
            cachedListTypeInfo.put(elementTypeInfo, result);
        }
        return result;
    }

    public static TypeInfo getMapTypeInfo(TypeInfo keyTypeInfo, TypeInfo valueTypeInfo) {
        ArrayList<TypeInfo> signature = new ArrayList<TypeInfo>(2);
        signature.add(keyTypeInfo);
        signature.add(valueTypeInfo);
        TypeInfo result = cachedMapTypeInfo.get(signature);
        if (result == null) {
            result = new MapTypeInfo(keyTypeInfo, valueTypeInfo);
            cachedMapTypeInfo.put(signature, result);
        }
        return result;
    }

    static {
        cachedPrimitiveTypeInfo.put("void", voidTypeInfo);
        cachedPrimitiveTypeInfo.put("boolean", booleanTypeInfo);
        cachedPrimitiveTypeInfo.put("int", intTypeInfo);
        cachedPrimitiveTypeInfo.put("bigint", longTypeInfo);
        cachedPrimitiveTypeInfo.put("string", stringTypeInfo);
        cachedPrimitiveTypeInfo.put(charTypeInfo.getQualifiedName(), charTypeInfo);
        cachedPrimitiveTypeInfo.put(varcharTypeInfo.getQualifiedName(), varcharTypeInfo);
        cachedPrimitiveTypeInfo.put("float", floatTypeInfo);
        cachedPrimitiveTypeInfo.put("double", doubleTypeInfo);
        cachedPrimitiveTypeInfo.put("tinyint", byteTypeInfo);
        cachedPrimitiveTypeInfo.put("smallint", shortTypeInfo);
        cachedPrimitiveTypeInfo.put("date", dateTypeInfo);
        cachedPrimitiveTypeInfo.put("timestamp", timestampTypeInfo);
        cachedPrimitiveTypeInfo.put("binary", binaryTypeInfo);
        cachedPrimitiveTypeInfo.put(decimalTypeInfo.getQualifiedName(), decimalTypeInfo);
        cachedPrimitiveTypeInfo.put("unknown", unknownTypeInfo);
        cachedStructTypeInfo = new ConcurrentHashMap();
        cachedUnionTypeInfo = new ConcurrentHashMap();
        cachedListTypeInfo = new ConcurrentHashMap();
        cachedMapTypeInfo = new ConcurrentHashMap();
    }
}

