/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.replication.logging;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.asterix.common.replication.IReplicationDestination;
import org.apache.asterix.common.transactions.ILogRecord;
import org.apache.asterix.replication.logging.TxnAck;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TxnAckTracker {
    private static final Logger LOGGER = LogManager.getLogger();
    private final Map<Long, TxnAck> txnsAcks = new HashMap<Long, TxnAck>();

    public synchronized void track(ILogRecord logRecord, Set<IReplicationDestination> replicas) {
        if (replicas.isEmpty()) {
            logRecord.setReplicated(true);
            return;
        }
        long txnId = logRecord.getTxnId();
        this.txnsAcks.put(txnId, new TxnAck(logRecord, replicas));
    }

    public synchronized void ack(long txnId, IReplicationDestination replica) {
        if (!this.txnsAcks.containsKey(txnId)) {
            LOGGER.warn("Received ack for unknown txn {}", (Object)txnId);
            return;
        }
        TxnAck txnAcks = this.txnsAcks.get(txnId);
        txnAcks.ack(replica);
        if (txnAcks.allAcked()) {
            this.txnsAcks.remove(txnId);
        }
    }

    public synchronized void unregister(IReplicationDestination replica) {
        HashSet<Long> pendingTxn = new HashSet<Long>(this.txnsAcks.keySet());
        pendingTxn.forEach(txnId -> this.ack((long)txnId, replica));
    }
}

