/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.lang.common.visitor;

import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import org.apache.asterix.common.config.DatasetConfig;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.common.functions.FunctionSignature;
import org.apache.asterix.lang.common.base.Expression;
import org.apache.asterix.lang.common.base.Literal;
import org.apache.asterix.lang.common.clause.LetClause;
import org.apache.asterix.lang.common.clause.LimitClause;
import org.apache.asterix.lang.common.clause.OrderbyClause;
import org.apache.asterix.lang.common.clause.WhereClause;
import org.apache.asterix.lang.common.expression.CallExpr;
import org.apache.asterix.lang.common.expression.FieldAccessor;
import org.apache.asterix.lang.common.expression.FieldBinding;
import org.apache.asterix.lang.common.expression.IfExpr;
import org.apache.asterix.lang.common.expression.IndexAccessor;
import org.apache.asterix.lang.common.expression.ListConstructor;
import org.apache.asterix.lang.common.expression.LiteralExpr;
import org.apache.asterix.lang.common.expression.OperatorExpr;
import org.apache.asterix.lang.common.expression.OrderedListTypeDefinition;
import org.apache.asterix.lang.common.expression.QuantifiedExpression;
import org.apache.asterix.lang.common.expression.RecordConstructor;
import org.apache.asterix.lang.common.expression.RecordTypeDefinition;
import org.apache.asterix.lang.common.expression.TypeExpression;
import org.apache.asterix.lang.common.expression.TypeReferenceExpression;
import org.apache.asterix.lang.common.expression.UnaryExpr;
import org.apache.asterix.lang.common.expression.UnorderedListTypeDefinition;
import org.apache.asterix.lang.common.expression.VariableExpr;
import org.apache.asterix.lang.common.statement.DatasetDecl;
import org.apache.asterix.lang.common.statement.DataverseDecl;
import org.apache.asterix.lang.common.statement.DisconnectFeedStatement;
import org.apache.asterix.lang.common.statement.FunctionDecl;
import org.apache.asterix.lang.common.statement.InternalDetailsDecl;
import org.apache.asterix.lang.common.statement.Query;
import org.apache.asterix.lang.common.statement.SetStatement;
import org.apache.asterix.lang.common.statement.TypeDecl;
import org.apache.asterix.lang.common.statement.WriteStatement;
import org.apache.asterix.lang.common.struct.Identifier;
import org.apache.asterix.lang.common.struct.OperatorType;
import org.apache.asterix.lang.common.struct.QuantifiedPair;
import org.apache.asterix.lang.common.visitor.base.AbstractQueryExpressionVisitor;

public abstract class QueryPrintVisitor
extends AbstractQueryExpressionVisitor<Void, Integer> {
    protected final PrintWriter out;

    protected QueryPrintVisitor(PrintWriter out) {
        this.out = out;
    }

    protected String skip(int step) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < step; ++i) {
            sb.append("  ");
        }
        return sb.toString();
    }

    @Override
    public Void visit(Query q, Integer step) throws CompilationException {
        if (q.getBody() != null) {
            this.out.println("Query:");
            q.getBody().accept(this, step);
        } else {
            this.out.println("No query.");
        }
        return null;
    }

    @Override
    public Void visit(LiteralExpr l, Integer step) {
        Literal lc = l.getValue();
        if (lc.getLiteralType().equals((Object)Literal.Type.TRUE) || lc.getLiteralType().equals((Object)Literal.Type.FALSE) || lc.getLiteralType().equals((Object)Literal.Type.NULL) || lc.getLiteralType().equals((Object)Literal.Type.MISSING)) {
            this.out.println(this.skip(step) + "LiteralExpr [" + (Object)((Object)l.getValue().getLiteralType()) + "]");
        } else {
            this.out.println(this.skip(step) + "LiteralExpr [" + (Object)((Object)l.getValue().getLiteralType()) + "] [" + l.getValue().getStringValue() + "]");
        }
        return null;
    }

    @Override
    public Void visit(VariableExpr v, Integer step) {
        this.out.println(this.skip(step) + "Variable [ Name=" + v.getVar().getValue() + " ]");
        return null;
    }

    @Override
    public Void visit(ListConstructor lc, Integer step) throws CompilationException {
        boolean ordered = false;
        if (lc.getType().equals((Object)ListConstructor.Type.ORDERED_LIST_CONSTRUCTOR)) {
            ordered = true;
        }
        this.out.println(this.skip(step) + (ordered ? "OrderedListConstructor " : "UnorderedListConstructor ") + "[");
        for (Expression e : lc.getExprList()) {
            e.accept(this, step + 1);
        }
        this.out.println(this.skip(step) + "]");
        return null;
    }

    @Override
    public Void visit(RecordConstructor rc, Integer step) throws CompilationException {
        this.out.println(this.skip(step) + "RecordConstructor [");
        for (FieldBinding fb : rc.getFbList()) {
            this.out.println(this.skip(step + 1) + "(");
            fb.getLeftExpr().accept(this, step + 2);
            this.out.println(this.skip(step + 2) + ":");
            fb.getRightExpr().accept(this, step + 2);
            this.out.println(this.skip(step + 1) + ")");
        }
        this.out.println(this.skip(step) + "]");
        return null;
    }

    @Override
    public Void visit(CallExpr callExpr, Integer step) throws CompilationException {
        return this.printFunctionCall(callExpr.getFunctionSignature(), callExpr.getFunctionSignature().getArity(), callExpr.getExprList(), callExpr.getAggregateFilterExpr(), step);
    }

    protected Void printFunctionCall(FunctionSignature fs, int arity, List<Expression> argList, Expression aggFilterExpr, Integer step) throws CompilationException {
        this.out.print(this.skip(step) + "FunctionCall ");
        QueryPrintVisitor.printFunctionSignature(this.out, fs, arity);
        this.out.println("[");
        for (Expression expr : argList) {
            expr.accept(this, step + 1);
        }
        this.out.print(this.skip(step) + "]");
        if (aggFilterExpr != null) {
            this.out.println(" filter [");
            aggFilterExpr.accept(this, step + 1);
            this.out.print(this.skip(step) + "]");
        }
        this.out.println();
        return null;
    }

    protected static void printFunctionSignature(PrintWriter out, FunctionSignature fs, int arity) {
        out.print(fs.toString(false));
        if (arity != -1) {
            out.print("@");
            out.print(arity);
        }
    }

    @Override
    public Void visit(OperatorExpr ifbo, Integer step) throws CompilationException {
        List<Expression> exprList = ifbo.getExprList();
        List<OperatorType> opList = ifbo.getOpList();
        if (ifbo.isCurrentop()) {
            this.out.println(this.skip(step) + "OperatorExpr [");
            exprList.get(0).accept(this, step + 1);
            for (int i = 1; i < exprList.size(); ++i) {
                this.out.println(this.skip(step + 1) + (Object)((Object)opList.get(i - 1)));
                exprList.get(i).accept(this, step + 1);
            }
            this.out.println(this.skip(step) + "]");
        } else {
            exprList.get(0).accept(this, step);
        }
        return null;
    }

    @Override
    public Void visit(IfExpr ifexpr, Integer step) throws CompilationException {
        this.out.println(this.skip(step) + "IfExpr [");
        this.out.println(this.skip(step + 1) + "Condition:");
        ifexpr.getCondExpr().accept(this, step + 2);
        this.out.println(this.skip(step + 1) + "Then:");
        ifexpr.getThenExpr().accept(this, step + 2);
        this.out.println(this.skip(step + 1) + "Else:");
        ifexpr.getElseExpr().accept(this, step + 2);
        this.out.println(this.skip(step) + "]");
        return null;
    }

    @Override
    public Void visit(QuantifiedExpression qe, Integer step) throws CompilationException {
        this.out.println(this.skip(step) + "QuantifiedExpression " + (Object)((Object)qe.getQuantifier()) + " [");
        for (QuantifiedPair pair : qe.getQuantifiedList()) {
            this.out.print(this.skip(step + 1) + "[");
            pair.getVarExpr().accept(this, 0);
            this.out.println(this.skip(step + 1) + "In");
            pair.getExpr().accept(this, step + 2);
            this.out.println(this.skip(step + 1) + "]");
        }
        this.out.println(this.skip(step + 1) + "Satifies [");
        qe.getSatisfiesExpr().accept(this, step + 2);
        this.out.println(this.skip(step + 1) + "]");
        this.out.println(this.skip(step) + "]");
        return null;
    }

    @Override
    public Void visit(LetClause lc, Integer step) throws CompilationException {
        this.out.print(this.skip(step) + "Let ");
        lc.getVarExpr().accept(this, 0);
        this.out.println(this.skip(step + 1) + ":=");
        lc.getBindingExpr().accept(this, step + 1);
        return null;
    }

    @Override
    public Void visit(WhereClause wc, Integer step) throws CompilationException {
        this.out.println(this.skip(step) + "Where");
        wc.getWhereExpr().accept(this, step + 1);
        return null;
    }

    @Override
    public Void visit(OrderbyClause oc, Integer step) throws CompilationException {
        this.out.println(this.skip(step) + "Orderby");
        List<OrderbyClause.OrderModifier> mlist = oc.getModifierList();
        List<Expression> list = oc.getOrderbyList();
        for (int i = 0; i < list.size(); ++i) {
            list.get(i).accept(this, step + 1);
            this.out.println(this.skip(step + 1) + mlist.get(i).toString());
        }
        this.out.println();
        return null;
    }

    @Override
    public Void visit(LimitClause lc, Integer step) throws CompilationException {
        this.out.println(this.skip(step) + "Limit");
        lc.getLimitExpr().accept(this, step + 1);
        if (lc.getOffset() != null) {
            this.out.println(this.skip(step + 1) + "Offset");
            lc.getOffset().accept(this, step + 2);
        }
        return null;
    }

    @Override
    public Void visit(FunctionDecl fd, Integer step) throws CompilationException {
        this.out.println(this.skip(step) + "FunctionDecl " + fd.getSignature().getName() + "(" + fd.getParamList().toString() + ") {");
        fd.getFuncBody().accept(this, step + 1);
        this.out.println(this.skip(step) + "}");
        this.out.println();
        return null;
    }

    @Override
    public Void visit(UnaryExpr u, Integer step) throws CompilationException {
        if (u.getExprType() != null) {
            this.out.print(this.skip(step) + (Object)((Object)u.getExprType()) + " ");
            u.getExpr().accept(this, 0);
        } else {
            u.getExpr().accept(this, step);
        }
        return null;
    }

    @Override
    public Void visit(FieldAccessor fa, Integer step) throws CompilationException {
        this.out.println(this.skip(step) + "FieldAccessor [");
        fa.getExpr().accept(this, step + 1);
        this.out.println(this.skip(step + 1) + "Field=" + fa.getIdent().getValue());
        this.out.println(this.skip(step) + "]");
        return null;
    }

    @Override
    public Void visit(IndexAccessor ia, Integer step) throws CompilationException {
        this.out.println(this.skip(step) + "IndexAccessor [");
        ia.getExpr().accept(this, step + 1);
        this.out.print(this.skip(step + 1) + "Index: ");
        switch (ia.getIndexKind()) {
            case ANY: {
                this.out.println("ANY");
                break;
            }
            case STAR: {
                this.out.println("STAR");
                break;
            }
            case ELEMENT: {
                ia.getIndexExpr().accept(this, step + 1);
                break;
            }
            default: {
                throw new CompilationException(1038, ia.getSourceLocation(), new Serializable[]{ia.getIndexKind()});
            }
        }
        this.out.println(this.skip(step) + "]");
        return null;
    }

    @Override
    public Void visit(TypeDecl t, Integer step) throws CompilationException {
        this.out.println(this.skip(step) + "TypeDecl " + t.getIdent() + " [");
        t.getTypeDef().accept(this, step + 1);
        this.out.println(this.skip(step) + "]");
        return null;
    }

    @Override
    public Void visit(TypeReferenceExpression t, Integer arg) throws CompilationException {
        if (t.getIdent().first != null && t.getIdent().first != null) {
            this.out.print(t.getIdent().first);
            this.out.print('.');
        }
        this.out.print(((Identifier)t.getIdent().second).getValue());
        return null;
    }

    @Override
    public Void visit(RecordTypeDefinition r, Integer step) throws CompilationException {
        if (r.getRecordKind() == RecordTypeDefinition.RecordKind.CLOSED) {
            this.out.print(this.skip(step) + "closed ");
        } else {
            this.out.print(this.skip(step) + "open ");
        }
        this.out.println("RecordType {");
        Iterator<String> nameIter = r.getFieldNames().iterator();
        Iterator<TypeExpression> typeIter = r.getFieldTypes().iterator();
        Iterator<Boolean> isNullableIter = r.getNullableFields().iterator();
        Iterator<Boolean> isMissableIter = r.getMissableFields().iterator();
        boolean first = true;
        while (nameIter.hasNext()) {
            if (first) {
                first = false;
            } else {
                this.out.println(",");
            }
            String name = nameIter.next();
            TypeExpression texp = typeIter.next();
            Boolean isNullable = isNullableIter.next();
            Boolean isMissable = isMissableIter.next();
            this.out.print(this.skip(step + 1) + name + " : ");
            texp.accept(this, step + 2);
            if (!isNullable.booleanValue() && !isMissable.booleanValue()) continue;
            this.out.print("?");
        }
        this.out.println();
        this.out.println(this.skip(step) + "}");
        return null;
    }

    @Override
    public Void visit(OrderedListTypeDefinition x, Integer step) throws CompilationException {
        this.out.print("OrderedList [");
        x.getItemTypeExpression().accept(this, step + 2);
        this.out.println("]");
        return null;
    }

    @Override
    public Void visit(UnorderedListTypeDefinition x, Integer step) throws CompilationException {
        this.out.print("UnorderedList <");
        x.getItemTypeExpression().accept(this, step + 2);
        this.out.println(">");
        return null;
    }

    @Override
    public Void visit(DatasetDecl dd, Integer step) throws CompilationException {
        if (dd.getDatasetType() == DatasetConfig.DatasetType.INTERNAL) {
            this.out.print(this.skip(step) + "DatasetDecl " + dd.getName() + "(");
            dd.getItemType().accept(this, step + 2);
            this.out.print(this.skip(step) + ") partitioned by " + ((InternalDetailsDecl)dd.getDatasetDetailsDecl()).getPartitioningExprs());
            if (((InternalDetailsDecl)dd.getDatasetDetailsDecl()).isAutogenerated()) {
                this.out.print(" [autogenerated]");
            }
            this.out.println();
        } else if (dd.getDatasetType() == DatasetConfig.DatasetType.EXTERNAL) {
            this.out.print(this.skip(step) + "DatasetDecl " + dd.getName() + "(");
            dd.getItemType().accept(this, step + 2);
            this.out.println(this.skip(step) + ")is an external dataset");
        }
        return null;
    }

    @Override
    public Void visit(DataverseDecl dv, Integer step) throws CompilationException {
        this.out.println(this.skip(step) + "DataverseUse " + dv.getDataverseName());
        return null;
    }

    @Override
    public Void visit(WriteStatement ws, Integer step) throws CompilationException {
        this.out.print(this.skip(step) + "WriteOutputTo " + ws.getNcName() + ":" + ws.getFileName());
        if (ws.getWriterClassName() != null) {
            this.out.print(" using " + ws.getWriterClassName());
        }
        this.out.println();
        return null;
    }

    @Override
    public Void visit(SetStatement ss, Integer step) throws CompilationException {
        this.out.println(this.skip(step) + "Set " + ss.getPropName() + "=" + ss.getPropValue());
        return null;
    }

    @Override
    public Void visit(DisconnectFeedStatement ss, Integer step) throws CompilationException {
        this.out.println(this.skip(step) + this.skip(step) + ss.getFeedName() + this.skip(step) + ss.getDatasetName());
        return null;
    }
}

