/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.algebricks.runtime.operators.aggrun;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.hyracks.algebricks.runtime.base.IEvaluatorContext;
import org.apache.hyracks.algebricks.runtime.base.IRunningAggregateEvaluator;
import org.apache.hyracks.algebricks.runtime.base.IRunningAggregateEvaluatorFactory;
import org.apache.hyracks.algebricks.runtime.evaluators.EvaluatorContext;
import org.apache.hyracks.algebricks.runtime.operators.base.AbstractOneInputOneOutputOneFramePushRuntime;
import org.apache.hyracks.api.comm.IFrameTupleAccessor;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.primitive.VoidPointable;
import org.apache.hyracks.dataflow.common.comm.io.ArrayTupleBuilder;
import org.apache.hyracks.dataflow.common.data.accessors.FrameTupleReference;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;

public abstract class AbstractRunningAggregatePushRuntime<T extends IRunningAggregateEvaluator>
extends AbstractOneInputOneOutputOneFramePushRuntime {
    protected final IEvaluatorContext ctx;
    private final IRunningAggregateEvaluatorFactory[] runningAggFactories;
    private final Class<T> runningAggEvalClass;
    protected final List<T> runningAggEvals;
    private final int[] projectionColumns;
    private final int[] projectionToOutColumns;
    private final IPointable p = VoidPointable.FACTORY.createPointable();
    protected ArrayTupleBuilder tupleBuilder;
    private boolean isFirst;

    public AbstractRunningAggregatePushRuntime(int[] projectionColumns, int[] runningAggOutColumns, IRunningAggregateEvaluatorFactory[] runningAggFactories, Class<T> runningAggEvalClass, IHyracksTaskContext ctx) {
        this.ctx = new EvaluatorContext(ctx);
        this.projectionColumns = projectionColumns;
        this.runningAggFactories = runningAggFactories;
        this.runningAggEvalClass = runningAggEvalClass;
        this.runningAggEvals = new ArrayList<T>(runningAggFactories.length);
        this.projectionToOutColumns = new int[projectionColumns.length];
        for (int j = 0; j < projectionColumns.length; ++j) {
            this.projectionToOutColumns[j] = Arrays.binarySearch(runningAggOutColumns, projectionColumns[j]);
        }
        this.isFirst = true;
    }

    @Override
    public void open() throws HyracksDataException {
        super.open();
        if (this.isFirst) {
            this.isFirst = false;
            this.init();
        }
        for (IRunningAggregateEvaluator runningAggEval : this.runningAggEvals) {
            runningAggEval.init();
        }
    }

    protected void init() throws HyracksDataException {
        this.tupleBuilder = this.createOutputTupleBuilder(this.projectionColumns);
        this.initAccessAppendRef(this.ctx.getTaskContext());
        for (IRunningAggregateEvaluatorFactory runningAggFactory : this.runningAggFactories) {
            IRunningAggregateEvaluator runningAggEval = runningAggFactory.createRunningAggregateEvaluator(this.ctx);
            this.runningAggEvals.add(this.runningAggEvalClass.cast(runningAggEval));
        }
    }

    protected ArrayTupleBuilder createOutputTupleBuilder(int[] projectionList) {
        return new ArrayTupleBuilder(projectionList.length);
    }

    protected void produceTuples(IFrameTupleAccessor accessor, int beginIdx, int endIdx, FrameTupleReference tupleRef) throws HyracksDataException {
        for (int t = beginIdx; t <= endIdx; ++t) {
            tupleRef.reset(accessor, t);
            this.produceTuple(this.tupleBuilder, accessor, t, tupleRef);
            this.appendToFrameFromTupleBuilder(this.tupleBuilder);
        }
    }

    protected void produceTuple(ArrayTupleBuilder tb, IFrameTupleAccessor accessor, int tIndex, FrameTupleReference tupleRef) throws HyracksDataException {
        tb.reset();
        for (int f = 0; f < this.projectionColumns.length; ++f) {
            int k = this.projectionToOutColumns[f];
            if (k >= 0) {
                ((IRunningAggregateEvaluator)this.runningAggEvals.get(k)).step((IFrameTupleReference)tupleRef, this.p);
                tb.addField(this.p.getByteArray(), this.p.getStartOffset(), this.p.getLength());
                continue;
            }
            tb.addField(accessor, tIndex, this.projectionColumns[f]);
        }
    }

    public void flush() throws HyracksDataException {
        this.appender.flush(this.writer);
    }
}

