/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.mapred.ACLsManager;
import org.apache.hadoop.mapred.JSPUtil;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobHistory;

public class RawHistoryFileServlet
extends HttpServlet {
    private ServletContext servletContext;

    @Override
    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        this.servletContext = servletConfig.getServletContext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String logFile = request.getParameter("logFile");
        if (logFile == null) {
            response.sendError(400, "Invalid log file name");
            return;
        }
        FileSystem fs = (FileSystem)this.servletContext.getAttribute("fileSys");
        JobConf jobConf = (JobConf)this.servletContext.getAttribute("jobConf");
        ACLsManager aclsManager = (ACLsManager)this.servletContext.getAttribute("aclManager");
        Path logFilePath = new Path(logFile);
        JobHistory.JobInfo job = null;
        try {
            job = JSPUtil.checkAccessAndGetJobInfo(request, response, jobConf, aclsManager, fs, logFilePath);
        }
        catch (InterruptedException e) {
            response.sendError(500, "Request interrupted");
        }
        if (job == null) {
            response.sendError(301, "Job details doesn't exist");
            return;
        }
        FSDataInputStream in = fs.open(logFilePath);
        try {
            IOUtils.copyBytes((InputStream)in, (OutputStream)response.getOutputStream(), 8192, false);
        }
        finally {
            ((InputStream)in).close();
        }
    }
}

