/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map;

import com.hazelcast.core.MapLoader;
import com.hazelcast.core.MapLoaderLifecycleSupport;
import com.hazelcast.core.MapStore;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;

public class MapStoreWrapper
implements MapStore {
    private final MapLoader mapLoader;
    private final MapStore mapStore;
    private final Object impl;
    private final String mapName;
    private final AtomicBoolean enabled = new AtomicBoolean(false);

    public MapStoreWrapper(Object impl, String mapName, boolean enabled) {
        this.impl = impl;
        this.mapName = mapName;
        MapLoader loader = null;
        MapStore store = null;
        if (impl instanceof MapStore) {
            store = (MapStore)impl;
        }
        if (impl instanceof MapLoader) {
            loader = (MapLoader)impl;
        }
        this.mapLoader = loader;
        this.mapStore = store;
        this.enabled.set(enabled);
    }

    public void enable() {
        this.enabled.set(true);
    }

    public void disable() {
        this.enabled.set(false);
    }

    public boolean isEnabled() {
        return this.enabled.get();
    }

    public void destroy() {
        if (this.impl instanceof MapLoaderLifecycleSupport) {
            ((MapLoaderLifecycleSupport)this.impl).destroy();
        }
    }

    private boolean isMapStore() {
        return this.mapStore != null;
    }

    private boolean isMapLoader() {
        return this.mapLoader != null;
    }

    public void delete(Object key) {
        if (this.isMapStore() && this.enabled.get()) {
            this.mapStore.delete(key);
        }
    }

    public void store(Object key, Object value) {
        if (this.isMapStore() && this.enabled.get()) {
            this.mapStore.store(key, value);
        }
    }

    public void storeAll(Map map) {
        if (this.isMapStore() && this.enabled.get()) {
            this.mapStore.storeAll(map);
        }
    }

    public void deleteAll(Collection keys) {
        if (this.isMapStore() && this.enabled.get()) {
            this.mapStore.deleteAll(keys);
        }
    }

    @Override
    public Set loadAllKeys() {
        if (this.isMapLoader() && this.enabled.get()) {
            return this.mapLoader.loadAllKeys();
        }
        return null;
    }

    @Override
    public Object load(Object key) {
        if (this.isMapLoader() && this.enabled.get()) {
            return this.mapLoader.load(key);
        }
        return null;
    }

    @Override
    public Map loadAll(Collection keys) {
        if (this.isMapLoader() && this.enabled.get()) {
            return this.mapLoader.loadAll(keys);
        }
        return null;
    }

    public String toString() {
        return "MapStoreWrapper{mapName='" + this.mapName + '\'' + ", mapStore=" + this.mapStore + ", mapLoader=" + this.mapLoader + '}';
    }
}

