/*
 * Decompiled with CFR 0.152.
 */
package org.compass.gps.device.jdbc.mapping;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.compass.gps.device.jdbc.mapping.ColumnMapping;
import org.compass.gps.device.jdbc.mapping.ColumnToPropertyMapping;
import org.compass.gps.device.jdbc.mapping.VersionColumnMapping;

public class ResultSetToResourceMapping {
    private String alias;
    private String selectQuery;
    private String versionQuery;
    private List idMappings = new ArrayList();
    private List dataMappings = new ArrayList();
    private Map mappingsMap = new HashMap();
    private List versionMappings = new ArrayList();
    private boolean indexUnMappedColumns = false;

    public ResultSetToResourceMapping() {
    }

    public ResultSetToResourceMapping(String alias, String selectQuery) {
        this(alias, selectQuery, null);
    }

    public ResultSetToResourceMapping(String alias, String selectQuery, ColumnToPropertyMapping idMapping) {
        this.alias = alias;
        this.selectQuery = selectQuery;
        if (idMapping != null) {
            this.idMappings.add(idMapping);
        }
    }

    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public String getSelectQuery() {
        return this.selectQuery;
    }

    public void setSelectQuery(String selectQuery) {
        this.selectQuery = selectQuery;
    }

    public String getVersionQuery() {
        return this.versionQuery;
    }

    public void setVersionQuery(String snapshotQuery) {
        this.versionQuery = snapshotQuery;
    }

    public void addIdMapping(ColumnToPropertyMapping idMapping) {
        this.idMappings.add(idMapping);
        this.addMappingToMap(idMapping);
    }

    public void addDataMapping(ColumnToPropertyMapping dataMapping) {
        this.dataMappings.add(dataMapping);
        this.addMappingToMap(dataMapping);
    }

    public void addVersionMapping(VersionColumnMapping versionColumnMapping) {
        this.versionMappings.add(versionColumnMapping);
        this.addMappingToMap(versionColumnMapping);
    }

    public List getMappingsForColumn(String columnName) {
        return (List)this.mappingsMap.get(columnName);
    }

    public List getMappingsForColumn(int columnIndex) {
        return (List)this.mappingsMap.get("" + columnIndex);
    }

    public void setIdMappings(ColumnToPropertyMapping[] idMappingsArr) {
        for (int i = 0; i < idMappingsArr.length; ++i) {
            this.addIdMapping(idMappingsArr[i]);
        }
    }

    public void setDataMappings(ColumnToPropertyMapping[] dataMappingsArr) {
        for (int i = 0; i < dataMappingsArr.length; ++i) {
            this.addDataMapping(dataMappingsArr[i]);
        }
    }

    public void setVersionMappings(VersionColumnMapping[] versionColumnMappingsArr) {
        for (int i = 0; i < versionColumnMappingsArr.length; ++i) {
            this.addVersionMapping(versionColumnMappingsArr[i]);
        }
    }

    public Iterator idMappingsIt() {
        return this.idMappings.iterator();
    }

    public int idMappingsSize() {
        return this.idMappings.size();
    }

    public Iterator dataMappingsIt() {
        return this.dataMappings.iterator();
    }

    public int dataMappingsSize() {
        return this.dataMappings.size();
    }

    public Iterator versionMappingsIt() {
        return this.versionMappings.iterator();
    }

    public int versionMappingsSize() {
        return this.versionMappings.size();
    }

    public Iterator mappingsIt() {
        return this.mappingsMap.values().iterator();
    }

    public boolean isIndexUnMappedColumns() {
        return this.indexUnMappedColumns;
    }

    public void setIndexUnMappedColumns(boolean indexUnMappedColumns) {
        this.indexUnMappedColumns = indexUnMappedColumns;
    }

    public boolean supportsVersioning() {
        return this.versionMappings.size() != 0;
    }

    private String getColumnKey(ColumnMapping columnMapping) {
        if (columnMapping.isUsingColumnIndex()) {
            return "" + columnMapping.getColumnIndex();
        }
        return columnMapping.getColumnName();
    }

    private void addMappingToMap(ColumnMapping columnMapping) {
        String key = this.getColumnKey(columnMapping);
        ArrayList<ColumnMapping> list = (ArrayList<ColumnMapping>)this.mappingsMap.get(key);
        if (list == null) {
            list = new ArrayList<ColumnMapping>();
            this.mappingsMap.put(key, list);
        }
        list.add(columnMapping);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("alias [" + this.alias + "] ");
        sb.append("select query [" + this.selectQuery + "] ");
        sb.append("version[" + this.supportsVersioning() + "] ");
        if (this.supportsVersioning()) {
            sb.append(" version query [" + this.versionQuery + "] ");
        }
        sb.append("indexUnMappedColumns[" + this.indexUnMappedColumns + "] ");
        sb.append("Id Mappings [");
        Iterator it = this.idMappingsIt();
        while (it.hasNext()) {
            sb.append("{" + it.next() + "}, ");
        }
        if (this.supportsVersioning()) {
            sb.append("] Version Mappings [");
            it = this.versionMappingsIt();
            while (it.hasNext()) {
                sb.append("{" + it.next() + "}, ");
            }
        }
        sb.append("] Data Mappings [");
        it = this.dataMappingsIt();
        while (it.hasNext()) {
            sb.append("{" + it.next() + "}, ");
        }
        sb.append("}");
        return sb.toString();
    }
}

