/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store.jdbc.index;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import org.apache.lucene.store.jdbc.JdbcDirectory;
import org.apache.lucene.store.jdbc.JdbcFileEntrySettings;
import org.apache.lucene.store.jdbc.index.AbstractJdbcIndexOutput;

public class FileJdbcIndexOutput
extends AbstractJdbcIndexOutput {
    private RandomAccessFile file = null;
    private File tempFile;

    public void configure(String name, JdbcDirectory jdbcDirectory, JdbcFileEntrySettings settings) throws IOException {
        super.configure(name, jdbcDirectory, settings);
        this.tempFile = File.createTempFile(jdbcDirectory.getTable().getName() + "_" + name + "_" + System.currentTimeMillis(), ".ljt");
        this.file = new RandomAccessFile(this.tempFile, "rw");
        this.jdbcDirectory = jdbcDirectory;
        this.name = name;
    }

    protected void flushBuffer(byte[] b, int offset, int len) throws IOException {
        this.file.write(b, offset, len);
    }

    public void seek(long pos) throws IOException {
        super.seek(pos);
        this.file.seek(pos);
    }

    public long length() throws IOException {
        return this.file.length();
    }

    protected InputStream openInputStream() throws IOException {
        return new BufferedInputStream(new FileInputStream(this.file.getFD()));
    }

    protected void doBeforeClose() throws IOException {
        this.file.seek(0L);
    }

    protected void doAfterClose() throws IOException {
        this.file.close();
        this.tempFile.delete();
        this.tempFile = null;
        this.file = null;
    }
}

