/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.core.util;

import java.io.InputStream;
import java.net.URL;
import java.util.Dictionary;
import java.util.Hashtable;
import org.apache.axis2.deployment.Deployer;
import org.apache.axis2.deployment.DeploymentEngine;
import org.apache.axis2.engine.AxisConfiguration;
import org.osgi.framework.BundleContext;
import org.wso2.carbon.core.transports.HttpGetRequestProcessor;
import org.wso2.carbon.utils.component.xml.Component;
import org.wso2.carbon.utils.component.xml.ComponentConfigFactory;
import org.wso2.carbon.utils.component.xml.config.HTTPGetRequestProcessorConfig;

public class Utils {
    public static void registerHTTPGetRequestProcessors(BundleContext bundleContext) throws Exception {
        URL url = bundleContext.getBundle().getEntry("META-INF/component.xml");
        if (url == null) {
            return;
        }
        InputStream inputStream = url.openStream();
        Component component = ComponentConfigFactory.build((InputStream)inputStream);
        HTTPGetRequestProcessorConfig[] getRequestProcessorConfigs = null;
        if (component != null) {
            getRequestProcessorConfigs = (HTTPGetRequestProcessorConfig[])component.getComponentConfig("httpGetRequestProcessors");
        }
        if (getRequestProcessorConfigs != null) {
            for (HTTPGetRequestProcessorConfig getRequestProcessorConfig : getRequestProcessorConfigs) {
                Class<?> getRequestProcessorClass;
                try {
                    getRequestProcessorClass = bundleContext.getBundle().loadClass(getRequestProcessorConfig.getClassName());
                }
                catch (ClassNotFoundException e) {
                    getRequestProcessorClass = Class.forName(getRequestProcessorConfig.getClassName());
                }
                HttpGetRequestProcessor getRequestProcessor = (HttpGetRequestProcessor)getRequestProcessorClass.newInstance();
                String item = getRequestProcessorConfig.getItem();
                Hashtable<String, String> propsMap = new Hashtable<String, String>(2);
                ((Dictionary)propsMap).put("item", item);
                ((Dictionary)propsMap).put("org.wso2.carbon.osgi.httpGetRequestProcessorService", HttpGetRequestProcessor.class.getName());
                bundleContext.registerService(HttpGetRequestProcessor.class.getName(), (Object)getRequestProcessor, propsMap);
            }
        }
    }

    public static String replaceSystemProperty(String text) {
        int indexOfClosingBrace;
        int indexOfStartingChars = -1;
        while (indexOfStartingChars < text.indexOf("${") && (indexOfStartingChars = text.indexOf("${")) != -1 && (indexOfClosingBrace = text.indexOf(125)) != -1) {
            String sysProp = text.substring(indexOfStartingChars + 2, indexOfClosingBrace);
            String propValue = System.getProperty(sysProp);
            if (propValue == null) continue;
            text = text.substring(0, indexOfStartingChars) + propValue + text.substring(indexOfClosingBrace + 1);
        }
        return text;
    }

    public static boolean addCAppDeployer(AxisConfiguration axisConfiguration) {
        boolean successfullyAdded = true;
        try {
            String appsRepo = "carbonapps";
            Class<?> deployerClass = Class.forName("org.wso2.carbon.application.deployer.CappAxis2Deployer");
            Deployer deployer = (Deployer)deployerClass.newInstance();
            deployer.setDirectory(appsRepo);
            deployer.setExtension("car");
            DeploymentEngine deploymentEngine = (DeploymentEngine)axisConfiguration.getConfigurator();
            deploymentEngine.addDeployer(deployer, appsRepo, "car");
        }
        catch (Exception e) {
            successfullyAdded = false;
        }
        return successfullyAdded;
    }
}

