/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.document.spec;

import com.amazonaws.event.ProgressListener;
import com.amazonaws.metrics.RequestMetricCollector;
import com.amazonaws.services.dynamodbv2.document.AttributeUpdate;
import com.amazonaws.services.dynamodbv2.document.Expected;
import com.amazonaws.services.dynamodbv2.document.KeyAttribute;
import com.amazonaws.services.dynamodbv2.document.PrimaryKey;
import com.amazonaws.services.dynamodbv2.document.spec.AbstractSpecWithPrimaryKey;
import com.amazonaws.services.dynamodbv2.model.ReturnConsumedCapacity;
import com.amazonaws.services.dynamodbv2.model.ReturnItemCollectionMetrics;
import com.amazonaws.services.dynamodbv2.model.ReturnValue;
import com.amazonaws.services.dynamodbv2.model.UpdateItemRequest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class UpdateItemSpec
extends AbstractSpecWithPrimaryKey<UpdateItemRequest> {
    private List<AttributeUpdate> attributes;
    private Collection<Expected> expected;
    private String updateExpression;
    private String conditionExpression;
    private Map<String, String> nameMap;
    private Map<String, Object> valueMap;

    public UpdateItemSpec() {
        super(new UpdateItemRequest());
    }

    public UpdateItemSpec withPrimaryKey(KeyAttribute ... components) {
        super.withPrimaryKey(components);
        return this;
    }

    public UpdateItemSpec withPrimaryKey(PrimaryKey primaryKey) {
        super.withPrimaryKey(primaryKey);
        return this;
    }

    public UpdateItemSpec withPrimaryKey(String hashKeyName, Object hashKeyValue) {
        super.withPrimaryKey(hashKeyName, hashKeyValue);
        return this;
    }

    public UpdateItemSpec withPrimaryKey(String hashKeyName, Object hashKeyValue, String rangeKeyName, Object rangeKeyValue) {
        super.withPrimaryKey(hashKeyName, hashKeyValue, rangeKeyName, rangeKeyValue);
        return this;
    }

    public List<AttributeUpdate> getAttributeUpdate() {
        return this.attributes;
    }

    public UpdateItemSpec withAttributeUpdate(List<AttributeUpdate> attributeUpdates) {
        this.attributes = attributeUpdates;
        return this;
    }

    public UpdateItemSpec withAttributeUpdate(AttributeUpdate ... attributeUpdates) {
        this.attributes = new ArrayList<AttributeUpdate>(Arrays.asList(attributeUpdates));
        return this;
    }

    public UpdateItemSpec addAttributeUpdate(AttributeUpdate attributeUpdate) {
        if (null == this.attributes) {
            this.attributes = new ArrayList<AttributeUpdate>();
        }
        this.attributes.add(attributeUpdate);
        return this;
    }

    public UpdateItemSpec clearAttributeUpdate() {
        this.attributes = null;
        return this;
    }

    public Collection<Expected> getExpected() {
        return this.expected;
    }

    public UpdateItemSpec withExpected(Expected ... expected) {
        if (expected == null) {
            this.expected = null;
            return this;
        }
        return this.withExpected(Arrays.asList(expected));
    }

    public UpdateItemSpec withExpected(Collection<Expected> expected) {
        if (expected == null) {
            this.expected = null;
            return this;
        }
        HashSet<String> names = new HashSet<String>();
        for (Expected e : expected) {
            names.add(e.getAttribute());
        }
        if (names.size() != expected.size()) {
            throw new IllegalArgumentException("attribute names must not duplicate in the list of expected");
        }
        this.expected = Collections.unmodifiableCollection(expected);
        return this;
    }

    public String getUpdateExpression() {
        return this.updateExpression;
    }

    public UpdateItemSpec withUpdateExpression(String updateExpression) {
        this.updateExpression = updateExpression;
        return this;
    }

    public String getConditionExpression() {
        return this.conditionExpression;
    }

    public UpdateItemSpec withConditionExpression(String conditionExpression) {
        this.conditionExpression = conditionExpression;
        return this;
    }

    public Map<String, String> getNameMap() {
        return this.nameMap;
    }

    public UpdateItemSpec withNameMap(Map<String, String> nameMap) {
        if (nameMap != null) {
            this.nameMap = Collections.unmodifiableMap(nameMap);
        }
        return this;
    }

    public Map<String, Object> getValueMap() {
        return this.valueMap;
    }

    public UpdateItemSpec withValueMap(Map<String, Object> valueMap) {
        this.valueMap = Collections.unmodifiableMap(valueMap);
        return this;
    }

    public String getConditionalOperator() {
        return ((UpdateItemRequest)this.getRequest()).getConditionalOperator();
    }

    public String getReturnConsumedCapacity() {
        return ((UpdateItemRequest)this.getRequest()).getReturnConsumedCapacity();
    }

    public UpdateItemSpec withReturnConsumedCapacity(String returnConsumedCapacity) {
        ((UpdateItemRequest)this.getRequest()).setReturnConsumedCapacity(returnConsumedCapacity);
        return this;
    }

    public UpdateItemSpec withReturnConsumedCapacity(ReturnConsumedCapacity returnConsumedCapacity) {
        ((UpdateItemRequest)this.getRequest()).setReturnConsumedCapacity(returnConsumedCapacity);
        return this;
    }

    public String getReturnItemCollectionMetrics() {
        return ((UpdateItemRequest)this.getRequest()).getReturnItemCollectionMetrics();
    }

    public UpdateItemSpec withReturnItemCollectionMetrics(ReturnItemCollectionMetrics returnItemCollectionMetrics) {
        ((UpdateItemRequest)this.getRequest()).setReturnItemCollectionMetrics(returnItemCollectionMetrics);
        return this;
    }

    public UpdateItemSpec withReturnItemCollectionMetrics(String returnItemCollectionMetrics) {
        ((UpdateItemRequest)this.getRequest()).setReturnItemCollectionMetrics(returnItemCollectionMetrics);
        return this;
    }

    public String getReturnValues() {
        return ((UpdateItemRequest)this.getRequest()).getReturnValues();
    }

    public UpdateItemSpec withReturnValues(ReturnValue returnValues) {
        ((UpdateItemRequest)this.getRequest()).setReturnValues(returnValues);
        return this;
    }

    public UpdateItemSpec withReturnValues(String returnValues) {
        ((UpdateItemRequest)this.getRequest()).setReturnValues(returnValues);
        return this;
    }

    @Override
    public UpdateItemSpec withProgressListener(ProgressListener progressListener) {
        this.setProgressListener(progressListener);
        return this;
    }

    @Override
    public UpdateItemSpec withRequestMetricCollector(RequestMetricCollector requestMetricCollector) {
        this.setRequestMetricCollector(requestMetricCollector);
        return this;
    }
}

