/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.common.utils;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.net.URL;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JTextField;
import javax.swing.Spring;
import javax.swing.SpringLayout;

public class SwingUtil {
    public static final Dimension MINIMUM_SIZE = new Dimension(0, 0);
    public static final int PAD = 6;
    public static final Cursor DEFAULT_CURSOR = new Cursor(0);
    public static final Cursor HAND_CURSOR = new Cursor(12);
    public static final Cursor CROSSHAIR_CURSOR = new Cursor(1);
    public static final Cursor MOVE_CURSOR = new Cursor(13);
    public static final Cursor WAIT_CURSOR = new Cursor(3);
    public static final int WEIGHT_NONE = -1;
    public static final int WEIGHT_EQUALLY = -2;

    public static ImageIcon createImageIcon(String filename) {
        ImageIcon icon = null;
        URL imgURL = SwingUtil.getImageURL(filename);
        if (imgURL != null) {
            icon = new ImageIcon(imgURL);
        }
        return icon;
    }

    public static Image createImage(String filename) {
        Image icon = null;
        URL imgURL = SwingUtil.getImageURL(filename);
        if (imgURL != null) {
            icon = Toolkit.getDefaultToolkit().getImage(imgURL);
        }
        return icon;
    }

    public static URL getImageURL(String filename) {
        String path = "/images/" + filename;
        URL imgURL = SwingUtil.class.getResource(path);
        return imgURL;
    }

    public static Frame getFrame(Component component) {
        Container parent;
        while ((parent = component.getParent()) != null) {
            component = parent;
        }
        Frame frame = component instanceof Frame ? (Frame)component : null;
        return frame;
    }

    public static void layoutToGrid(Container parent, int numRow, int numColumn, int weightedRow, int weightedColumn) {
        GridBagLayout layout = new GridBagLayout();
        parent.setLayout(layout);
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.fill = 1;
        constraints.insets = new Insets(6, 6, 6, 6);
        for (int row = 0; row < numRow; ++row) {
            constraints.gridy = row;
            constraints.weighty = weightedRow == -2 ? 1.0 : (row == weightedRow ? 1.0 : 0.0);
            for (int column = 0; column < numColumn; ++column) {
                constraints.gridx = column;
                constraints.weightx = weightedColumn == -2 ? 1.0 : (column == weightedColumn ? 1.0 : 0.0);
                Component component = parent.getComponent(row * numColumn + column);
                layout.setConstraints(component, constraints);
            }
        }
    }

    public static void layoutToGrid(Container parent, double[] rowWeights, double[] columnWeights) {
        GridBagLayout layout = new GridBagLayout();
        parent.setLayout(layout);
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.fill = 1;
        constraints.insets = new Insets(6, 6, 6, 6);
        for (int row = 0; row < rowWeights.length; ++row) {
            constraints.gridy = row;
            constraints.weighty = rowWeights[row];
            for (int column = 0; column < columnWeights.length; ++column) {
                constraints.gridx = column;
                constraints.weightx = columnWeights[column];
                Component component = parent.getComponent(row * columnWeights.length + column);
                layout.setConstraints(component, constraints);
            }
        }
    }

    public static void layoutToGrid(Container parent, List<Double> rowWeights, List<Double> columnWeights) {
        GridBagLayout layout = new GridBagLayout();
        parent.setLayout(layout);
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.fill = 1;
        constraints.insets = new Insets(6, 6, 6, 6);
        for (int row = 0; row < rowWeights.size(); ++row) {
            constraints.gridy = row;
            constraints.weighty = rowWeights.get(row);
            for (int column = 0; column < columnWeights.size(); ++column) {
                constraints.gridx = column;
                constraints.weightx = columnWeights.get(column);
                Component component = parent.getComponent(row * columnWeights.size() + column);
                layout.setConstraints(component, constraints);
            }
        }
    }

    public static void makeSpringCompactGrid(Container parent, int rows, int cols) {
        SwingUtil.makeSpringCompactGrid(parent, rows, cols, 6, 6, 6, 6);
    }

    private static void makeSpringCompactGrid(Container parent, int rows, int cols, int initialX, int initialY, int xPad, int yPad) {
        SpringLayout layout = new SpringLayout();
        parent.setLayout(layout);
        Spring x = Spring.constant(initialX);
        for (int c = 0; c < cols; ++c) {
            int r;
            Spring width = Spring.constant(0);
            for (r = 0; r < rows; ++r) {
                width = Spring.max(width, SwingUtil.getConstraintsForCell(r, c, parent, cols).getWidth());
            }
            for (r = 0; r < rows; ++r) {
                SpringLayout.Constraints constraints = SwingUtil.getConstraintsForCell(r, c, parent, cols);
                constraints.setX(x);
                constraints.setWidth(width);
            }
            x = Spring.sum(x, Spring.sum(width, Spring.constant(xPad)));
        }
        Spring y = Spring.constant(initialY);
        for (int r = 0; r < rows; ++r) {
            int c;
            Spring height = Spring.constant(0);
            for (c = 0; c < cols; ++c) {
                height = Spring.max(height, SwingUtil.getConstraintsForCell(r, c, parent, cols).getHeight());
            }
            for (c = 0; c < cols; ++c) {
                SpringLayout.Constraints constraints = SwingUtil.getConstraintsForCell(r, c, parent, cols);
                constraints.setY(y);
                constraints.setHeight(height);
            }
            y = Spring.sum(y, Spring.sum(height, Spring.constant(yPad)));
        }
        SpringLayout.Constraints pCons = layout.getConstraints(parent);
        pCons.setConstraint("South", y);
        pCons.setConstraint("East", x);
    }

    private static SpringLayout.Constraints getConstraintsForCell(int row, int col, Container parent, int cols) {
        SpringLayout layout = (SpringLayout)parent.getLayout();
        Component c = parent.getComponent(row * cols + col);
        return layout.getConstraints(c);
    }

    public static void addPlaceHolder(final JTextField field, final String placeHolderText) {
        field.addFocusListener(new FocusListener(){
            private Color fontColor;
            {
                this.fontColor = field.getForeground();
            }

            @Override
            public void focusGained(FocusEvent arg0) {
                if (field.getText().equals(placeHolderText)) {
                    field.setText("");
                }
                field.setForeground(this.fontColor);
            }

            @Override
            public void focusLost(FocusEvent arg0) {
                if (field.getText().trim().equals("")) {
                    this.fontColor = field.getForeground();
                    field.setForeground(Color.GRAY);
                    field.setText(placeHolderText);
                }
            }
        });
        if (field.getText().trim().equals("")) {
            field.setText(placeHolderText);
            field.setForeground(Color.GRAY);
        }
    }
}

