/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.sharing.registry.db.repositories;

import java.util.HashMap;
import java.util.List;
import org.apache.airavata.sharing.registry.db.entities.SharingEntity;
import org.apache.airavata.sharing.registry.db.entities.UserEntity;
import org.apache.airavata.sharing.registry.db.entities.UserPK;
import org.apache.airavata.sharing.registry.db.repositories.AbstractRepository;
import org.apache.airavata.sharing.registry.db.repositories.PermissionTypeRepository;
import org.apache.airavata.sharing.registry.models.SharingRegistryException;
import org.apache.airavata.sharing.registry.models.User;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserRepository
extends AbstractRepository<User, UserEntity, UserPK> {
    private static final Logger logger = LoggerFactory.getLogger(UserRepository.class);

    public UserRepository() {
        super(User.class, UserEntity.class);
    }

    public List<User> getAccessibleUsers(String domainId, String entityId, String permissionTypeId) throws SharingRegistryException {
        HashMap<String, Object> queryParameters = new HashMap<String, Object>();
        String query = "SELECT DISTINCT u from " + UserEntity.class.getSimpleName() + " u, " + SharingEntity.class.getSimpleName() + " s";
        query = query + " WHERE ";
        query = query + "u.userId = s.groupId AND ";
        query = query + "u.domainId = s.domainId AND ";
        query = query + "u.domainId = :domainId AND ";
        query = query + "s.entityId = :entityId AND ";
        query = query + "s.permissionTypeId = :permissionTypeId";
        queryParameters.put("domainId", domainId);
        queryParameters.put("entityId", entityId);
        queryParameters.put("permissionTypeId", permissionTypeId);
        if (permissionTypeId.equals(new PermissionTypeRepository().getOwnerPermissionTypeIdForDomain(domainId))) {
            query = query + " AND s.sharingType LIKE :sharingType";
            queryParameters.put("sharingType", "DIRECT_%");
        }
        query = query + " ORDER BY s.createdTime DESC";
        return this.select(query, queryParameters, 0, -1);
    }
}

