/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.registry.core.app.catalog.resources;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.apache.airavata.common.exception.ApplicationSettingsException;
import org.apache.airavata.common.utils.AiravataUtils;
import org.apache.airavata.registry.core.app.catalog.model.ComputeResource;
import org.apache.airavata.registry.core.app.catalog.resources.AppCatAbstractResource;
import org.apache.airavata.registry.core.app.catalog.resources.AppCatalogResource;
import org.apache.airavata.registry.core.app.catalog.util.AppCatalogJPAUtils;
import org.apache.airavata.registry.core.app.catalog.util.AppCatalogQueryGenerator;
import org.apache.airavata.registry.core.app.catalog.util.AppCatalogResourceType;
import org.apache.airavata.registry.cpi.AppCatalogException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComputeResourceResource
extends AppCatAbstractResource {
    private static final Logger logger = LoggerFactory.getLogger(ComputeResourceResource.class);
    private String resourceDescription;
    private String resourceId;
    private String hostName;
    private Timestamp createdTime;
    private Timestamp updatedTime;
    private int maxMemoryPerNode;
    private int cpusPerNode;
    private int defaultNodeCount;
    private int defaultCPUCount;
    private int defaultWalltime;
    private boolean enabled;
    private boolean gatewayUsageReporting;
    private String gatewayUsageModLoadCMD;
    private String gatewayUsageExec;

    public int getMaxMemoryPerNode() {
        return this.maxMemoryPerNode;
    }

    public void setMaxMemoryPerNode(int maxMemoryPerNode) {
        this.maxMemoryPerNode = maxMemoryPerNode;
    }

    public Timestamp getCreatedTime() {
        return this.createdTime;
    }

    public void setCreatedTime(Timestamp createdTime) {
        this.createdTime = createdTime;
    }

    public Timestamp getUpdatedTime() {
        return this.updatedTime;
    }

    public void setUpdatedTime(Timestamp updatedTime) {
        this.updatedTime = updatedTime;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public int getCpusPerNode() {
        return this.cpusPerNode;
    }

    public void setCpusPerNode(int cpusPerNode) {
        this.cpusPerNode = cpusPerNode;
    }

    public int getDefaultNodeCount() {
        return this.defaultNodeCount;
    }

    public void setDefaultNodeCount(int defaultNodeCount) {
        this.defaultNodeCount = defaultNodeCount;
    }

    public int getDefaultCPUCount() {
        return this.defaultCPUCount;
    }

    public void setDefaultCPUCount(int defaultCPUCount) {
        this.defaultCPUCount = defaultCPUCount;
    }

    public int getDefaultWalltime() {
        return this.defaultWalltime;
    }

    public void setDefaultWalltime(int defaultWalltime) {
        this.defaultWalltime = defaultWalltime;
    }

    @Override
    public void remove(Object identifier) throws AppCatalogException {
        EntityManager em = null;
        try {
            em = AppCatalogJPAUtils.getEntityManager();
            em.getTransaction().begin();
            AppCatalogQueryGenerator generator = new AppCatalogQueryGenerator("ComputeResource", new Object[0][]);
            generator.setParameter("resourceId", identifier);
            Query q = generator.deleteQuery(em);
            q.executeUpdate();
            em.getTransaction().commit();
            if (em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
        catch (ApplicationSettingsException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new AppCatalogException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
    }

    @Override
    public AppCatalogResource get(Object identifier) throws AppCatalogException {
        EntityManager em = null;
        try {
            em = AppCatalogJPAUtils.getEntityManager();
            em.getTransaction().begin();
            AppCatalogQueryGenerator generator = new AppCatalogQueryGenerator("ComputeResource", new Object[0][]);
            generator.setParameter("resourceId", identifier);
            Query q = generator.selectQuery(em);
            ComputeResource computeResource = (ComputeResource)q.getSingleResult();
            ComputeResourceResource computeResourceResource = (ComputeResourceResource)AppCatalogJPAUtils.getResource(AppCatalogResourceType.COMPUTE_RESOURCE, computeResource);
            em.getTransaction().commit();
            if (em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
            ComputeResourceResource computeResourceResource2 = computeResourceResource;
            return computeResourceResource2;
        }
        catch (ApplicationSettingsException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new AppCatalogException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
    }

    @Override
    public List<AppCatalogResource> get(String fieldName, Object value) throws AppCatalogException {
        ArrayList<AppCatalogResource> computeResourceResources = new ArrayList<AppCatalogResource>();
        EntityManager em = null;
        try {
            em = AppCatalogJPAUtils.getEntityManager();
            em.getTransaction().begin();
            AppCatalogQueryGenerator generator = new AppCatalogQueryGenerator("ComputeResource", new Object[0][]);
            if (fieldName.equals("resourceDescription") || fieldName.equals("resourceId") || fieldName.equals("hostName")) {
                generator.setParameter(fieldName, value);
                Query q = generator.selectQuery(em);
                List results = q.getResultList();
                for (Object result : results) {
                    ComputeResource computeResource = (ComputeResource)result;
                    ComputeResourceResource computeResourceResource = (ComputeResourceResource)AppCatalogJPAUtils.getResource(AppCatalogResourceType.COMPUTE_RESOURCE, computeResource);
                    computeResourceResources.add(computeResourceResource);
                }
            } else {
                em.getTransaction().commit();
                if (em.isOpen()) {
                    if (em.getTransaction().isActive()) {
                        em.getTransaction().rollback();
                    }
                    em.close();
                }
                logger.error("Unsupported field name for Compute Resource Resource.", (Throwable)new IllegalArgumentException());
                throw new IllegalArgumentException("Unsupported field name for Compute Resource Resource.");
            }
            em.getTransaction().commit();
            if (em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
        catch (ApplicationSettingsException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new AppCatalogException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
        return computeResourceResources;
    }

    @Override
    public List<AppCatalogResource> getAll() throws AppCatalogException {
        ArrayList<AppCatalogResource> computeResourceResources = new ArrayList<AppCatalogResource>();
        EntityManager em = null;
        try {
            em = AppCatalogJPAUtils.getEntityManager();
            em.getTransaction().begin();
            AppCatalogQueryGenerator generator = new AppCatalogQueryGenerator("ComputeResource", new Object[0][]);
            Query q = generator.selectQuery(em);
            List results = q.getResultList();
            for (Object result : results) {
                ComputeResource computeResource = (ComputeResource)result;
                ComputeResourceResource computeResourceResource = (ComputeResourceResource)AppCatalogJPAUtils.getResource(AppCatalogResourceType.COMPUTE_RESOURCE, computeResource);
                computeResourceResources.add(computeResourceResource);
            }
            em.getTransaction().commit();
            if (em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
        catch (ApplicationSettingsException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new AppCatalogException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
        return computeResourceResources;
    }

    @Override
    public List<String> getAllIds() throws AppCatalogException {
        ArrayList<String> computeResourceResources = new ArrayList<String>();
        EntityManager em = null;
        try {
            em = AppCatalogJPAUtils.getEntityManager();
            em.getTransaction().begin();
            AppCatalogQueryGenerator generator = new AppCatalogQueryGenerator("ComputeResource", new Object[0][]);
            Query q = generator.selectQuery(em);
            List results = q.getResultList();
            for (Object result : results) {
                ComputeResource computeResource = (ComputeResource)result;
                computeResourceResources.add(computeResource.getResourceId());
            }
            em.getTransaction().commit();
            if (em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
        catch (ApplicationSettingsException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new AppCatalogException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
        return computeResourceResources;
    }

    @Override
    public List<String> getIds(String fieldName, Object value) throws AppCatalogException {
        ArrayList<String> computeResourceResourceIDs = new ArrayList<String>();
        EntityManager em = null;
        try {
            em = AppCatalogJPAUtils.getEntityManager();
            em.getTransaction().begin();
            AppCatalogQueryGenerator generator = new AppCatalogQueryGenerator("ComputeResource", new Object[0][]);
            if (fieldName.equals("resourceDescription") || fieldName.equals("resourceId") || fieldName.equals("hostName")) {
                generator.setParameter(fieldName, value);
                Query q = generator.selectQuery(em);
                List results = q.getResultList();
                for (Object result : results) {
                    ComputeResource computeResource = (ComputeResource)result;
                    ComputeResourceResource computeResourceResource = (ComputeResourceResource)AppCatalogJPAUtils.getResource(AppCatalogResourceType.COMPUTE_RESOURCE, computeResource);
                    computeResourceResourceIDs.add(computeResourceResource.getResourceId());
                }
            } else {
                em.getTransaction().commit();
                if (em.isOpen()) {
                    if (em.getTransaction().isActive()) {
                        em.getTransaction().rollback();
                    }
                    em.close();
                }
                logger.error("Unsupported field name for Compute Resource Resource.", (Throwable)new IllegalArgumentException());
                throw new IllegalArgumentException("Unsupported field name for Compute Resource Resource.");
            }
            em.getTransaction().commit();
            if (em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
        catch (ApplicationSettingsException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new AppCatalogException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
        return computeResourceResourceIDs;
    }

    @Override
    public void save() throws AppCatalogException {
        EntityManager em = null;
        try {
            ComputeResource computeResource;
            em = AppCatalogJPAUtils.getEntityManager();
            ComputeResource existingComputeResource = (ComputeResource)em.find(ComputeResource.class, (Object)this.resourceId);
            if (em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
            em = AppCatalogJPAUtils.getEntityManager();
            em.getTransaction().begin();
            if (existingComputeResource == null) {
                computeResource = new ComputeResource();
                computeResource.setCreationTime(AiravataUtils.getCurrentTimestamp());
            } else {
                computeResource = existingComputeResource;
                computeResource.setUpdateTime(AiravataUtils.getCurrentTimestamp());
            }
            computeResource.setResourceDescription(this.getResourceDescription());
            computeResource.setResourceId(this.getResourceId());
            computeResource.setHostName(this.getHostName());
            computeResource.setEnabled(this.isEnabled());
            computeResource.setMaxMemoryPerNode(this.getMaxMemoryPerNode());
            computeResource.setCpusPerNode(this.cpusPerNode);
            computeResource.setDefaultNodeCount(this.defaultNodeCount);
            computeResource.setDefaultCPUCount(this.defaultCPUCount);
            computeResource.setDefaultWalltime(this.defaultWalltime);
            computeResource.setGatewayUsageReporting(this.gatewayUsageReporting);
            computeResource.setGatewayUsageModLoadCMD(this.gatewayUsageModLoadCMD);
            computeResource.setGatewayUsageExec(this.gatewayUsageExec);
            if (existingComputeResource == null) {
                em.persist((Object)computeResource);
            } else {
                em.merge((Object)computeResource);
            }
            em.getTransaction().commit();
            if (em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new AppCatalogException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
    }

    @Override
    public boolean isExists(Object identifier) throws AppCatalogException {
        EntityManager em = null;
        try {
            em = AppCatalogJPAUtils.getEntityManager();
            ComputeResource computeResource = (ComputeResource)em.find(ComputeResource.class, identifier);
            if (em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
            boolean bl = computeResource != null;
            return bl;
        }
        catch (ApplicationSettingsException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new AppCatalogException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
    }

    public String getResourceDescription() {
        return this.resourceDescription;
    }

    public String getResourceId() {
        return this.resourceId;
    }

    public String getHostName() {
        return this.hostName;
    }

    public void setResourceDescription(String resourceDescription) {
        this.resourceDescription = resourceDescription;
    }

    public void setResourceId(String resourceId) {
        this.resourceId = resourceId;
    }

    public void setHostName(String hostName) {
        this.hostName = hostName;
    }

    public boolean isGatewayUsageReporting() {
        return this.gatewayUsageReporting;
    }

    public void setGatewayUsageReporting(boolean gatewayUsageReporting) {
        this.gatewayUsageReporting = gatewayUsageReporting;
    }

    public String getGatewayUsageModLoadCMD() {
        return this.gatewayUsageModLoadCMD;
    }

    public void setGatewayUsageModLoadCMD(String gatewayUsageModLoadCMD) {
        this.gatewayUsageModLoadCMD = gatewayUsageModLoadCMD;
    }

    public String getGatewayUsageExec() {
        return this.gatewayUsageExec;
    }

    public void setGatewayUsageExec(String gatewayUsageExec) {
        this.gatewayUsageExec = gatewayUsageExec;
    }
}

