/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.concurrent.semaphore;

import com.hazelcast.concurrent.semaphore.ReleaseBackupOperation;
import com.hazelcast.concurrent.semaphore.SemaphoreBackupAwareOperation;
import com.hazelcast.concurrent.semaphore.SemaphoreWaitNotifyKey;
import com.hazelcast.spi.Notifier;
import com.hazelcast.spi.Operation;
import com.hazelcast.spi.WaitNotifyKey;

public class ReleaseOperation
extends SemaphoreBackupAwareOperation
implements Notifier {
    public ReleaseOperation() {
    }

    public ReleaseOperation(String name, int permitCount) {
        super(name, permitCount);
    }

    @Override
    public void run() throws Exception {
        this.getPermit().release(this.permitCount, this.getCallerUuid());
        this.response = true;
    }

    @Override
    public boolean shouldNotify() {
        return this.permitCount > 0;
    }

    @Override
    public WaitNotifyKey getNotifiedKey() {
        return new SemaphoreWaitNotifyKey((Object)this.name, "acquire");
    }

    @Override
    public boolean shouldBackup() {
        return this.permitCount > 0;
    }

    @Override
    public Operation getBackupOperation() {
        return new ReleaseBackupOperation(this.name, this.permitCount, this.getCallerUuid());
    }
}

