<?php
namespace Airavata\Service\Profile\Tenant\CPI;
/**
 * Autogenerated by Thrift Compiler (0.9.3)
 *
 * DO NOT EDIT UNLESS YOU ARE SURE THAT YOU KNOW WHAT YOU ARE DOING
 *  @generated
 */
use Thrift\Base\TBase;
use Thrift\Type\TType;
use Thrift\Type\TMessageType;
use Thrift\Exception\TException;
use Thrift\Exception\TProtocolException;
use Thrift\Protocol\TProtocol;
use Thrift\Protocol\TBinaryProtocolAccelerated;
use Thrift\Exception\TApplicationException;


interface TenantProfileServiceIf {
  /**
   * @param \Airavata\Model\Security\AuthzToken $authzToken
   * @return string
   * @throws \Airavata\Service\Profile\Tenant\CPI\Error\TenantProfileServiceException
   * @throws \Airavata\API\Error\AuthorizationException
   */
  public function getAPIVersion(\Airavata\Model\Security\AuthzToken $authzToken);
  /**
   * Return the airavataInternalGatewayId assigned to given gateway.
   * 
   * @param \Airavata\Model\Security\AuthzToken $authzToken
   * @param \Airavata\Model\Workspace\Gateway $gateway
   * @return string
   * @throws \Airavata\Service\Profile\Tenant\CPI\Error\TenantProfileServiceException
   * @throws \Airavata\API\Error\AuthorizationException
   */
  public function addGateway(\Airavata\Model\Security\AuthzToken $authzToken, \Airavata\Model\Workspace\Gateway $gateway);
  /**
   * @param \Airavata\Model\Security\AuthzToken $authzToken
   * @param \Airavata\Model\Workspace\Gateway $updatedGateway
   * @return bool
   * @throws \Airavata\Service\Profile\Tenant\CPI\Error\TenantProfileServiceException
   * @throws \Airavata\API\Error\AuthorizationException
   */
  public function updateGateway(\Airavata\Model\Security\AuthzToken $authzToken, \Airavata\Model\Workspace\Gateway $updatedGateway);
  /**
   * @param \Airavata\Model\Security\AuthzToken $authzToken
   * @param string $airavataInternalGatewayId
   * @return \Airavata\Model\Workspace\Gateway
   * @throws \Airavata\Service\Profile\Tenant\CPI\Error\TenantProfileServiceException
   * @throws \Airavata\API\Error\AuthorizationException
   */
  public function getGateway(\Airavata\Model\Security\AuthzToken $authzToken, $airavataInternalGatewayId);
  /**
   * @param \Airavata\Model\Security\AuthzToken $authzToken
   * @param string $airavataInternalGatewayId
   * @param string $gatewayId
   * @return bool
   * @throws \Airavata\Service\Profile\Tenant\CPI\Error\TenantProfileServiceException
   * @throws \Airavata\API\Error\AuthorizationException
   */
  public function deleteGateway(\Airavata\Model\Security\AuthzToken $authzToken, $airavataInternalGatewayId, $gatewayId);
  /**
   * @param \Airavata\Model\Security\AuthzToken $authzToken
   * @return \Airavata\Model\Workspace\Gateway[]
   * @throws \Airavata\Service\Profile\Tenant\CPI\Error\TenantProfileServiceException
   * @throws \Airavata\API\Error\AuthorizationException
   */
  public function getAllGateways(\Airavata\Model\Security\AuthzToken $authzToken);
  /**
   * @param \Airavata\Model\Security\AuthzToken $authzToken
   * @param string $gatewayId
   * @return bool
   * @throws \Airavata\Service\Profile\Tenant\CPI\Error\TenantProfileServiceException
   * @throws \Airavata\API\Error\AuthorizationException
   */
  public function isGatewayExist(\Airavata\Model\Security\AuthzToken $authzToken, $gatewayId);
  /**
   * @param \Airavata\Model\Security\AuthzToken $authzToken
   * @param string $requesterUsername
   * @return \Airavata\Model\Workspace\Gateway[]
   * @throws \Airavata\Service\Profile\Tenant\CPI\Error\TenantProfileServiceException
   * @throws \Airavata\API\Error\AuthorizationException
   */
  public function getAllGatewaysForUser(\Airavata\Model\Security\AuthzToken $authzToken, $requesterUsername);
}

class TenantProfileServiceClient implements \Airavata\Service\Profile\Tenant\CPI\TenantProfileServiceIf {
  protected $input_ = null;
  protected $output_ = null;

  protected $seqid_ = 0;

  public function __construct($input, $output=null) {
    $this->input_ = $input;
    $this->output_ = $output ? $output : $input;
  }

  public function getAPIVersion(\Airavata\Model\Security\AuthzToken $authzToken)
  {
    $this->send_getAPIVersion($authzToken);
    return $this->recv_getAPIVersion();
  }

  public function send_getAPIVersion(\Airavata\Model\Security\AuthzToken $authzToken)
  {
    $args = new \Airavata\Service\Profile\Tenant\CPI\TenantProfileService_getAPIVersion_args();
    $args->authzToken = $authzToken;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'getAPIVersion', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('getAPIVersion', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_getAPIVersion()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\Service\Profile\Tenant\CPI\TenantProfileService_getAPIVersion_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\Service\Profile\Tenant\CPI\TenantProfileService_getAPIVersion_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->tpe !== null) {
      throw $result->tpe;
    }
    if ($result->ae !== null) {
      throw $result->ae;
    }
    throw new \Exception("getAPIVersion failed: unknown result");
  }

  public function addGateway(\Airavata\Model\Security\AuthzToken $authzToken, \Airavata\Model\Workspace\Gateway $gateway)
  {
    $this->send_addGateway($authzToken, $gateway);
    return $this->recv_addGateway();
  }

  public function send_addGateway(\Airavata\Model\Security\AuthzToken $authzToken, \Airavata\Model\Workspace\Gateway $gateway)
  {
    $args = new \Airavata\Service\Profile\Tenant\CPI\TenantProfileService_addGateway_args();
    $args->authzToken = $authzToken;
    $args->gateway = $gateway;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'addGateway', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('addGateway', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_addGateway()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\Service\Profile\Tenant\CPI\TenantProfileService_addGateway_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\Service\Profile\Tenant\CPI\TenantProfileService_addGateway_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->tpe !== null) {
      throw $result->tpe;
    }
    if ($result->ae !== null) {
      throw $result->ae;
    }
    throw new \Exception("addGateway failed: unknown result");
  }

  public function updateGateway(\Airavata\Model\Security\AuthzToken $authzToken, \Airavata\Model\Workspace\Gateway $updatedGateway)
  {
    $this->send_updateGateway($authzToken, $updatedGateway);
    return $this->recv_updateGateway();
  }

  public function send_updateGateway(\Airavata\Model\Security\AuthzToken $authzToken, \Airavata\Model\Workspace\Gateway $updatedGateway)
  {
    $args = new \Airavata\Service\Profile\Tenant\CPI\TenantProfileService_updateGateway_args();
    $args->authzToken = $authzToken;
    $args->updatedGateway = $updatedGateway;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'updateGateway', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('updateGateway', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_updateGateway()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\Service\Profile\Tenant\CPI\TenantProfileService_updateGateway_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\Service\Profile\Tenant\CPI\TenantProfileService_updateGateway_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->tpe !== null) {
      throw $result->tpe;
    }
    if ($result->ae !== null) {
      throw $result->ae;
    }
    throw new \Exception("updateGateway failed: unknown result");
  }

  public function getGateway(\Airavata\Model\Security\AuthzToken $authzToken, $airavataInternalGatewayId)
  {
    $this->send_getGateway($authzToken, $airavataInternalGatewayId);
    return $this->recv_getGateway();
  }

  public function send_getGateway(\Airavata\Model\Security\AuthzToken $authzToken, $airavataInternalGatewayId)
  {
    $args = new \Airavata\Service\Profile\Tenant\CPI\TenantProfileService_getGateway_args();
    $args->authzToken = $authzToken;
    $args->airavataInternalGatewayId = $airavataInternalGatewayId;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'getGateway', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('getGateway', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_getGateway()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\Service\Profile\Tenant\CPI\TenantProfileService_getGateway_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\Service\Profile\Tenant\CPI\TenantProfileService_getGateway_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->tpe !== null) {
      throw $result->tpe;
    }
    if ($result->ae !== null) {
      throw $result->ae;
    }
    throw new \Exception("getGateway failed: unknown result");
  }

  public function deleteGateway(\Airavata\Model\Security\AuthzToken $authzToken, $airavataInternalGatewayId, $gatewayId)
  {
    $this->send_deleteGateway($authzToken, $airavataInternalGatewayId, $gatewayId);
    return $this->recv_deleteGateway();
  }

  public function send_deleteGateway(\Airavata\Model\Security\AuthzToken $authzToken, $airavataInternalGatewayId, $gatewayId)
  {
    $args = new \Airavata\Service\Profile\Tenant\CPI\TenantProfileService_deleteGateway_args();
    $args->authzToken = $authzToken;
    $args->airavataInternalGatewayId = $airavataInternalGatewayId;
    $args->gatewayId = $gatewayId;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'deleteGateway', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('deleteGateway', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_deleteGateway()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\Service\Profile\Tenant\CPI\TenantProfileService_deleteGateway_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\Service\Profile\Tenant\CPI\TenantProfileService_deleteGateway_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->tpe !== null) {
      throw $result->tpe;
    }
    if ($result->ae !== null) {
      throw $result->ae;
    }
    throw new \Exception("deleteGateway failed: unknown result");
  }

  public function getAllGateways(\Airavata\Model\Security\AuthzToken $authzToken)
  {
    $this->send_getAllGateways($authzToken);
    return $this->recv_getAllGateways();
  }

  public function send_getAllGateways(\Airavata\Model\Security\AuthzToken $authzToken)
  {
    $args = new \Airavata\Service\Profile\Tenant\CPI\TenantProfileService_getAllGateways_args();
    $args->authzToken = $authzToken;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'getAllGateways', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('getAllGateways', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_getAllGateways()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\Service\Profile\Tenant\CPI\TenantProfileService_getAllGateways_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\Service\Profile\Tenant\CPI\TenantProfileService_getAllGateways_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->tpe !== null) {
      throw $result->tpe;
    }
    if ($result->ae !== null) {
      throw $result->ae;
    }
    throw new \Exception("getAllGateways failed: unknown result");
  }

  public function isGatewayExist(\Airavata\Model\Security\AuthzToken $authzToken, $gatewayId)
  {
    $this->send_isGatewayExist($authzToken, $gatewayId);
    return $this->recv_isGatewayExist();
  }

  public function send_isGatewayExist(\Airavata\Model\Security\AuthzToken $authzToken, $gatewayId)
  {
    $args = new \Airavata\Service\Profile\Tenant\CPI\TenantProfileService_isGatewayExist_args();
    $args->authzToken = $authzToken;
    $args->gatewayId = $gatewayId;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'isGatewayExist', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('isGatewayExist', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_isGatewayExist()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\Service\Profile\Tenant\CPI\TenantProfileService_isGatewayExist_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\Service\Profile\Tenant\CPI\TenantProfileService_isGatewayExist_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->tpe !== null) {
      throw $result->tpe;
    }
    if ($result->ae !== null) {
      throw $result->ae;
    }
    throw new \Exception("isGatewayExist failed: unknown result");
  }

  public function getAllGatewaysForUser(\Airavata\Model\Security\AuthzToken $authzToken, $requesterUsername)
  {
    $this->send_getAllGatewaysForUser($authzToken, $requesterUsername);
    return $this->recv_getAllGatewaysForUser();
  }

  public function send_getAllGatewaysForUser(\Airavata\Model\Security\AuthzToken $authzToken, $requesterUsername)
  {
    $args = new \Airavata\Service\Profile\Tenant\CPI\TenantProfileService_getAllGatewaysForUser_args();
    $args->authzToken = $authzToken;
    $args->requesterUsername = $requesterUsername;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'getAllGatewaysForUser', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('getAllGatewaysForUser', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_getAllGatewaysForUser()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\Airavata\Service\Profile\Tenant\CPI\TenantProfileService_getAllGatewaysForUser_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \Airavata\Service\Profile\Tenant\CPI\TenantProfileService_getAllGatewaysForUser_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->tpe !== null) {
      throw $result->tpe;
    }
    if ($result->ae !== null) {
      throw $result->ae;
    }
    throw new \Exception("getAllGatewaysForUser failed: unknown result");
  }

}

// HELPER FUNCTIONS AND STRUCTURES

class TenantProfileService_getAPIVersion_args {
  static $_TSPEC;

  /**
   * @var \Airavata\Model\Security\AuthzToken
   */
  public $authzToken = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'authzToken',
          'type' => TType::STRUCT,
          'class' => '\Airavata\Model\Security\AuthzToken',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['authzToken'])) {
        $this->authzToken = $vals['authzToken'];
      }
    }
  }

  public function getName() {
    return 'TenantProfileService_getAPIVersion_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->authzToken = new \Airavata\Model\Security\AuthzToken();
            $xfer += $this->authzToken->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('TenantProfileService_getAPIVersion_args');
    if ($this->authzToken !== null) {
      if (!is_object($this->authzToken)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('authzToken', TType::STRUCT, 1);
      $xfer += $this->authzToken->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class TenantProfileService_getAPIVersion_result {
  static $_TSPEC;

  /**
   * @var string
   */
  public $success = null;
  /**
   * @var \Airavata\Service\Profile\Tenant\CPI\Error\TenantProfileServiceException
   */
  public $tpe = null;
  /**
   * @var \Airavata\API\Error\AuthorizationException
   */
  public $ae = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::STRING,
          ),
        1 => array(
          'var' => 'tpe',
          'type' => TType::STRUCT,
          'class' => '\Airavata\Service\Profile\Tenant\CPI\Error\TenantProfileServiceException',
          ),
        2 => array(
          'var' => 'ae',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AuthorizationException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['tpe'])) {
        $this->tpe = $vals['tpe'];
      }
      if (isset($vals['ae'])) {
        $this->ae = $vals['ae'];
      }
    }
  }

  public function getName() {
    return 'TenantProfileService_getAPIVersion_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->success);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->tpe = new \Airavata\Service\Profile\Tenant\CPI\Error\TenantProfileServiceException();
            $xfer += $this->tpe->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->ae = new \Airavata\API\Error\AuthorizationException();
            $xfer += $this->ae->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('TenantProfileService_getAPIVersion_result');
    if ($this->success !== null) {
      $xfer += $output->writeFieldBegin('success', TType::STRING, 0);
      $xfer += $output->writeString($this->success);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->tpe !== null) {
      $xfer += $output->writeFieldBegin('tpe', TType::STRUCT, 1);
      $xfer += $this->tpe->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ae !== null) {
      $xfer += $output->writeFieldBegin('ae', TType::STRUCT, 2);
      $xfer += $this->ae->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class TenantProfileService_addGateway_args {
  static $_TSPEC;

  /**
   * @var \Airavata\Model\Security\AuthzToken
   */
  public $authzToken = null;
  /**
   * @var \Airavata\Model\Workspace\Gateway
   */
  public $gateway = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'authzToken',
          'type' => TType::STRUCT,
          'class' => '\Airavata\Model\Security\AuthzToken',
          ),
        2 => array(
          'var' => 'gateway',
          'type' => TType::STRUCT,
          'class' => '\Airavata\Model\Workspace\Gateway',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['authzToken'])) {
        $this->authzToken = $vals['authzToken'];
      }
      if (isset($vals['gateway'])) {
        $this->gateway = $vals['gateway'];
      }
    }
  }

  public function getName() {
    return 'TenantProfileService_addGateway_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->authzToken = new \Airavata\Model\Security\AuthzToken();
            $xfer += $this->authzToken->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->gateway = new \Airavata\Model\Workspace\Gateway();
            $xfer += $this->gateway->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('TenantProfileService_addGateway_args');
    if ($this->authzToken !== null) {
      if (!is_object($this->authzToken)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('authzToken', TType::STRUCT, 1);
      $xfer += $this->authzToken->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->gateway !== null) {
      if (!is_object($this->gateway)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('gateway', TType::STRUCT, 2);
      $xfer += $this->gateway->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class TenantProfileService_addGateway_result {
  static $_TSPEC;

  /**
   * @var string
   */
  public $success = null;
  /**
   * @var \Airavata\Service\Profile\Tenant\CPI\Error\TenantProfileServiceException
   */
  public $tpe = null;
  /**
   * @var \Airavata\API\Error\AuthorizationException
   */
  public $ae = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::STRING,
          ),
        1 => array(
          'var' => 'tpe',
          'type' => TType::STRUCT,
          'class' => '\Airavata\Service\Profile\Tenant\CPI\Error\TenantProfileServiceException',
          ),
        2 => array(
          'var' => 'ae',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AuthorizationException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['tpe'])) {
        $this->tpe = $vals['tpe'];
      }
      if (isset($vals['ae'])) {
        $this->ae = $vals['ae'];
      }
    }
  }

  public function getName() {
    return 'TenantProfileService_addGateway_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->success);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->tpe = new \Airavata\Service\Profile\Tenant\CPI\Error\TenantProfileServiceException();
            $xfer += $this->tpe->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->ae = new \Airavata\API\Error\AuthorizationException();
            $xfer += $this->ae->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('TenantProfileService_addGateway_result');
    if ($this->success !== null) {
      $xfer += $output->writeFieldBegin('success', TType::STRING, 0);
      $xfer += $output->writeString($this->success);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->tpe !== null) {
      $xfer += $output->writeFieldBegin('tpe', TType::STRUCT, 1);
      $xfer += $this->tpe->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ae !== null) {
      $xfer += $output->writeFieldBegin('ae', TType::STRUCT, 2);
      $xfer += $this->ae->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class TenantProfileService_updateGateway_args {
  static $_TSPEC;

  /**
   * @var \Airavata\Model\Security\AuthzToken
   */
  public $authzToken = null;
  /**
   * @var \Airavata\Model\Workspace\Gateway
   */
  public $updatedGateway = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'authzToken',
          'type' => TType::STRUCT,
          'class' => '\Airavata\Model\Security\AuthzToken',
          ),
        2 => array(
          'var' => 'updatedGateway',
          'type' => TType::STRUCT,
          'class' => '\Airavata\Model\Workspace\Gateway',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['authzToken'])) {
        $this->authzToken = $vals['authzToken'];
      }
      if (isset($vals['updatedGateway'])) {
        $this->updatedGateway = $vals['updatedGateway'];
      }
    }
  }

  public function getName() {
    return 'TenantProfileService_updateGateway_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->authzToken = new \Airavata\Model\Security\AuthzToken();
            $xfer += $this->authzToken->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->updatedGateway = new \Airavata\Model\Workspace\Gateway();
            $xfer += $this->updatedGateway->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('TenantProfileService_updateGateway_args');
    if ($this->authzToken !== null) {
      if (!is_object($this->authzToken)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('authzToken', TType::STRUCT, 1);
      $xfer += $this->authzToken->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->updatedGateway !== null) {
      if (!is_object($this->updatedGateway)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('updatedGateway', TType::STRUCT, 2);
      $xfer += $this->updatedGateway->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class TenantProfileService_updateGateway_result {
  static $_TSPEC;

  /**
   * @var bool
   */
  public $success = null;
  /**
   * @var \Airavata\Service\Profile\Tenant\CPI\Error\TenantProfileServiceException
   */
  public $tpe = null;
  /**
   * @var \Airavata\API\Error\AuthorizationException
   */
  public $ae = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::BOOL,
          ),
        1 => array(
          'var' => 'tpe',
          'type' => TType::STRUCT,
          'class' => '\Airavata\Service\Profile\Tenant\CPI\Error\TenantProfileServiceException',
          ),
        2 => array(
          'var' => 'ae',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AuthorizationException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['tpe'])) {
        $this->tpe = $vals['tpe'];
      }
      if (isset($vals['ae'])) {
        $this->ae = $vals['ae'];
      }
    }
  }

  public function getName() {
    return 'TenantProfileService_updateGateway_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::BOOL) {
            $xfer += $input->readBool($this->success);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->tpe = new \Airavata\Service\Profile\Tenant\CPI\Error\TenantProfileServiceException();
            $xfer += $this->tpe->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->ae = new \Airavata\API\Error\AuthorizationException();
            $xfer += $this->ae->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('TenantProfileService_updateGateway_result');
    if ($this->success !== null) {
      $xfer += $output->writeFieldBegin('success', TType::BOOL, 0);
      $xfer += $output->writeBool($this->success);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->tpe !== null) {
      $xfer += $output->writeFieldBegin('tpe', TType::STRUCT, 1);
      $xfer += $this->tpe->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ae !== null) {
      $xfer += $output->writeFieldBegin('ae', TType::STRUCT, 2);
      $xfer += $this->ae->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class TenantProfileService_getGateway_args {
  static $_TSPEC;

  /**
   * @var \Airavata\Model\Security\AuthzToken
   */
  public $authzToken = null;
  /**
   * @var string
   */
  public $airavataInternalGatewayId = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'authzToken',
          'type' => TType::STRUCT,
          'class' => '\Airavata\Model\Security\AuthzToken',
          ),
        2 => array(
          'var' => 'airavataInternalGatewayId',
          'type' => TType::STRING,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['authzToken'])) {
        $this->authzToken = $vals['authzToken'];
      }
      if (isset($vals['airavataInternalGatewayId'])) {
        $this->airavataInternalGatewayId = $vals['airavataInternalGatewayId'];
      }
    }
  }

  public function getName() {
    return 'TenantProfileService_getGateway_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->authzToken = new \Airavata\Model\Security\AuthzToken();
            $xfer += $this->authzToken->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->airavataInternalGatewayId);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('TenantProfileService_getGateway_args');
    if ($this->authzToken !== null) {
      if (!is_object($this->authzToken)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('authzToken', TType::STRUCT, 1);
      $xfer += $this->authzToken->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->airavataInternalGatewayId !== null) {
      $xfer += $output->writeFieldBegin('airavataInternalGatewayId', TType::STRING, 2);
      $xfer += $output->writeString($this->airavataInternalGatewayId);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class TenantProfileService_getGateway_result {
  static $_TSPEC;

  /**
   * @var \Airavata\Model\Workspace\Gateway
   */
  public $success = null;
  /**
   * @var \Airavata\Service\Profile\Tenant\CPI\Error\TenantProfileServiceException
   */
  public $tpe = null;
  /**
   * @var \Airavata\API\Error\AuthorizationException
   */
  public $ae = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::STRUCT,
          'class' => '\Airavata\Model\Workspace\Gateway',
          ),
        1 => array(
          'var' => 'tpe',
          'type' => TType::STRUCT,
          'class' => '\Airavata\Service\Profile\Tenant\CPI\Error\TenantProfileServiceException',
          ),
        2 => array(
          'var' => 'ae',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AuthorizationException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['tpe'])) {
        $this->tpe = $vals['tpe'];
      }
      if (isset($vals['ae'])) {
        $this->ae = $vals['ae'];
      }
    }
  }

  public function getName() {
    return 'TenantProfileService_getGateway_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::STRUCT) {
            $this->success = new \Airavata\Model\Workspace\Gateway();
            $xfer += $this->success->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->tpe = new \Airavata\Service\Profile\Tenant\CPI\Error\TenantProfileServiceException();
            $xfer += $this->tpe->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->ae = new \Airavata\API\Error\AuthorizationException();
            $xfer += $this->ae->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('TenantProfileService_getGateway_result');
    if ($this->success !== null) {
      if (!is_object($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::STRUCT, 0);
      $xfer += $this->success->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->tpe !== null) {
      $xfer += $output->writeFieldBegin('tpe', TType::STRUCT, 1);
      $xfer += $this->tpe->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ae !== null) {
      $xfer += $output->writeFieldBegin('ae', TType::STRUCT, 2);
      $xfer += $this->ae->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class TenantProfileService_deleteGateway_args {
  static $_TSPEC;

  /**
   * @var \Airavata\Model\Security\AuthzToken
   */
  public $authzToken = null;
  /**
   * @var string
   */
  public $airavataInternalGatewayId = null;
  /**
   * @var string
   */
  public $gatewayId = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'authzToken',
          'type' => TType::STRUCT,
          'class' => '\Airavata\Model\Security\AuthzToken',
          ),
        2 => array(
          'var' => 'airavataInternalGatewayId',
          'type' => TType::STRING,
          ),
        3 => array(
          'var' => 'gatewayId',
          'type' => TType::STRING,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['authzToken'])) {
        $this->authzToken = $vals['authzToken'];
      }
      if (isset($vals['airavataInternalGatewayId'])) {
        $this->airavataInternalGatewayId = $vals['airavataInternalGatewayId'];
      }
      if (isset($vals['gatewayId'])) {
        $this->gatewayId = $vals['gatewayId'];
      }
    }
  }

  public function getName() {
    return 'TenantProfileService_deleteGateway_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->authzToken = new \Airavata\Model\Security\AuthzToken();
            $xfer += $this->authzToken->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->airavataInternalGatewayId);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->gatewayId);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('TenantProfileService_deleteGateway_args');
    if ($this->authzToken !== null) {
      if (!is_object($this->authzToken)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('authzToken', TType::STRUCT, 1);
      $xfer += $this->authzToken->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->airavataInternalGatewayId !== null) {
      $xfer += $output->writeFieldBegin('airavataInternalGatewayId', TType::STRING, 2);
      $xfer += $output->writeString($this->airavataInternalGatewayId);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->gatewayId !== null) {
      $xfer += $output->writeFieldBegin('gatewayId', TType::STRING, 3);
      $xfer += $output->writeString($this->gatewayId);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class TenantProfileService_deleteGateway_result {
  static $_TSPEC;

  /**
   * @var bool
   */
  public $success = null;
  /**
   * @var \Airavata\Service\Profile\Tenant\CPI\Error\TenantProfileServiceException
   */
  public $tpe = null;
  /**
   * @var \Airavata\API\Error\AuthorizationException
   */
  public $ae = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::BOOL,
          ),
        1 => array(
          'var' => 'tpe',
          'type' => TType::STRUCT,
          'class' => '\Airavata\Service\Profile\Tenant\CPI\Error\TenantProfileServiceException',
          ),
        2 => array(
          'var' => 'ae',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AuthorizationException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['tpe'])) {
        $this->tpe = $vals['tpe'];
      }
      if (isset($vals['ae'])) {
        $this->ae = $vals['ae'];
      }
    }
  }

  public function getName() {
    return 'TenantProfileService_deleteGateway_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::BOOL) {
            $xfer += $input->readBool($this->success);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->tpe = new \Airavata\Service\Profile\Tenant\CPI\Error\TenantProfileServiceException();
            $xfer += $this->tpe->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->ae = new \Airavata\API\Error\AuthorizationException();
            $xfer += $this->ae->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('TenantProfileService_deleteGateway_result');
    if ($this->success !== null) {
      $xfer += $output->writeFieldBegin('success', TType::BOOL, 0);
      $xfer += $output->writeBool($this->success);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->tpe !== null) {
      $xfer += $output->writeFieldBegin('tpe', TType::STRUCT, 1);
      $xfer += $this->tpe->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ae !== null) {
      $xfer += $output->writeFieldBegin('ae', TType::STRUCT, 2);
      $xfer += $this->ae->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class TenantProfileService_getAllGateways_args {
  static $_TSPEC;

  /**
   * @var \Airavata\Model\Security\AuthzToken
   */
  public $authzToken = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'authzToken',
          'type' => TType::STRUCT,
          'class' => '\Airavata\Model\Security\AuthzToken',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['authzToken'])) {
        $this->authzToken = $vals['authzToken'];
      }
    }
  }

  public function getName() {
    return 'TenantProfileService_getAllGateways_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->authzToken = new \Airavata\Model\Security\AuthzToken();
            $xfer += $this->authzToken->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('TenantProfileService_getAllGateways_args');
    if ($this->authzToken !== null) {
      if (!is_object($this->authzToken)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('authzToken', TType::STRUCT, 1);
      $xfer += $this->authzToken->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class TenantProfileService_getAllGateways_result {
  static $_TSPEC;

  /**
   * @var \Airavata\Model\Workspace\Gateway[]
   */
  public $success = null;
  /**
   * @var \Airavata\Service\Profile\Tenant\CPI\Error\TenantProfileServiceException
   */
  public $tpe = null;
  /**
   * @var \Airavata\API\Error\AuthorizationException
   */
  public $ae = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::LST,
          'etype' => TType::STRUCT,
          'elem' => array(
            'type' => TType::STRUCT,
            'class' => '\Airavata\Model\Workspace\Gateway',
            ),
          ),
        1 => array(
          'var' => 'tpe',
          'type' => TType::STRUCT,
          'class' => '\Airavata\Service\Profile\Tenant\CPI\Error\TenantProfileServiceException',
          ),
        2 => array(
          'var' => 'ae',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AuthorizationException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['tpe'])) {
        $this->tpe = $vals['tpe'];
      }
      if (isset($vals['ae'])) {
        $this->ae = $vals['ae'];
      }
    }
  }

  public function getName() {
    return 'TenantProfileService_getAllGateways_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::LST) {
            $this->success = array();
            $_size0 = 0;
            $_etype3 = 0;
            $xfer += $input->readListBegin($_etype3, $_size0);
            for ($_i4 = 0; $_i4 < $_size0; ++$_i4)
            {
              $elem5 = null;
              $elem5 = new \Airavata\Model\Workspace\Gateway();
              $xfer += $elem5->read($input);
              $this->success []= $elem5;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->tpe = new \Airavata\Service\Profile\Tenant\CPI\Error\TenantProfileServiceException();
            $xfer += $this->tpe->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->ae = new \Airavata\API\Error\AuthorizationException();
            $xfer += $this->ae->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('TenantProfileService_getAllGateways_result');
    if ($this->success !== null) {
      if (!is_array($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::LST, 0);
      {
        $output->writeListBegin(TType::STRUCT, count($this->success));
        {
          foreach ($this->success as $iter6)
          {
            $xfer += $iter6->write($output);
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    if ($this->tpe !== null) {
      $xfer += $output->writeFieldBegin('tpe', TType::STRUCT, 1);
      $xfer += $this->tpe->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ae !== null) {
      $xfer += $output->writeFieldBegin('ae', TType::STRUCT, 2);
      $xfer += $this->ae->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class TenantProfileService_isGatewayExist_args {
  static $_TSPEC;

  /**
   * @var \Airavata\Model\Security\AuthzToken
   */
  public $authzToken = null;
  /**
   * @var string
   */
  public $gatewayId = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'authzToken',
          'type' => TType::STRUCT,
          'class' => '\Airavata\Model\Security\AuthzToken',
          ),
        2 => array(
          'var' => 'gatewayId',
          'type' => TType::STRING,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['authzToken'])) {
        $this->authzToken = $vals['authzToken'];
      }
      if (isset($vals['gatewayId'])) {
        $this->gatewayId = $vals['gatewayId'];
      }
    }
  }

  public function getName() {
    return 'TenantProfileService_isGatewayExist_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->authzToken = new \Airavata\Model\Security\AuthzToken();
            $xfer += $this->authzToken->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->gatewayId);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('TenantProfileService_isGatewayExist_args');
    if ($this->authzToken !== null) {
      if (!is_object($this->authzToken)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('authzToken', TType::STRUCT, 1);
      $xfer += $this->authzToken->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->gatewayId !== null) {
      $xfer += $output->writeFieldBegin('gatewayId', TType::STRING, 2);
      $xfer += $output->writeString($this->gatewayId);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class TenantProfileService_isGatewayExist_result {
  static $_TSPEC;

  /**
   * @var bool
   */
  public $success = null;
  /**
   * @var \Airavata\Service\Profile\Tenant\CPI\Error\TenantProfileServiceException
   */
  public $tpe = null;
  /**
   * @var \Airavata\API\Error\AuthorizationException
   */
  public $ae = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::BOOL,
          ),
        1 => array(
          'var' => 'tpe',
          'type' => TType::STRUCT,
          'class' => '\Airavata\Service\Profile\Tenant\CPI\Error\TenantProfileServiceException',
          ),
        2 => array(
          'var' => 'ae',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AuthorizationException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['tpe'])) {
        $this->tpe = $vals['tpe'];
      }
      if (isset($vals['ae'])) {
        $this->ae = $vals['ae'];
      }
    }
  }

  public function getName() {
    return 'TenantProfileService_isGatewayExist_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::BOOL) {
            $xfer += $input->readBool($this->success);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->tpe = new \Airavata\Service\Profile\Tenant\CPI\Error\TenantProfileServiceException();
            $xfer += $this->tpe->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->ae = new \Airavata\API\Error\AuthorizationException();
            $xfer += $this->ae->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('TenantProfileService_isGatewayExist_result');
    if ($this->success !== null) {
      $xfer += $output->writeFieldBegin('success', TType::BOOL, 0);
      $xfer += $output->writeBool($this->success);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->tpe !== null) {
      $xfer += $output->writeFieldBegin('tpe', TType::STRUCT, 1);
      $xfer += $this->tpe->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ae !== null) {
      $xfer += $output->writeFieldBegin('ae', TType::STRUCT, 2);
      $xfer += $this->ae->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class TenantProfileService_getAllGatewaysForUser_args {
  static $_TSPEC;

  /**
   * @var \Airavata\Model\Security\AuthzToken
   */
  public $authzToken = null;
  /**
   * @var string
   */
  public $requesterUsername = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'authzToken',
          'type' => TType::STRUCT,
          'class' => '\Airavata\Model\Security\AuthzToken',
          ),
        2 => array(
          'var' => 'requesterUsername',
          'type' => TType::STRING,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['authzToken'])) {
        $this->authzToken = $vals['authzToken'];
      }
      if (isset($vals['requesterUsername'])) {
        $this->requesterUsername = $vals['requesterUsername'];
      }
    }
  }

  public function getName() {
    return 'TenantProfileService_getAllGatewaysForUser_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->authzToken = new \Airavata\Model\Security\AuthzToken();
            $xfer += $this->authzToken->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->requesterUsername);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('TenantProfileService_getAllGatewaysForUser_args');
    if ($this->authzToken !== null) {
      if (!is_object($this->authzToken)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('authzToken', TType::STRUCT, 1);
      $xfer += $this->authzToken->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->requesterUsername !== null) {
      $xfer += $output->writeFieldBegin('requesterUsername', TType::STRING, 2);
      $xfer += $output->writeString($this->requesterUsername);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class TenantProfileService_getAllGatewaysForUser_result {
  static $_TSPEC;

  /**
   * @var \Airavata\Model\Workspace\Gateway[]
   */
  public $success = null;
  /**
   * @var \Airavata\Service\Profile\Tenant\CPI\Error\TenantProfileServiceException
   */
  public $tpe = null;
  /**
   * @var \Airavata\API\Error\AuthorizationException
   */
  public $ae = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::LST,
          'etype' => TType::STRUCT,
          'elem' => array(
            'type' => TType::STRUCT,
            'class' => '\Airavata\Model\Workspace\Gateway',
            ),
          ),
        1 => array(
          'var' => 'tpe',
          'type' => TType::STRUCT,
          'class' => '\Airavata\Service\Profile\Tenant\CPI\Error\TenantProfileServiceException',
          ),
        2 => array(
          'var' => 'ae',
          'type' => TType::STRUCT,
          'class' => '\Airavata\API\Error\AuthorizationException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['tpe'])) {
        $this->tpe = $vals['tpe'];
      }
      if (isset($vals['ae'])) {
        $this->ae = $vals['ae'];
      }
    }
  }

  public function getName() {
    return 'TenantProfileService_getAllGatewaysForUser_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::LST) {
            $this->success = array();
            $_size7 = 0;
            $_etype10 = 0;
            $xfer += $input->readListBegin($_etype10, $_size7);
            for ($_i11 = 0; $_i11 < $_size7; ++$_i11)
            {
              $elem12 = null;
              $elem12 = new \Airavata\Model\Workspace\Gateway();
              $xfer += $elem12->read($input);
              $this->success []= $elem12;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->tpe = new \Airavata\Service\Profile\Tenant\CPI\Error\TenantProfileServiceException();
            $xfer += $this->tpe->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->ae = new \Airavata\API\Error\AuthorizationException();
            $xfer += $this->ae->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('TenantProfileService_getAllGatewaysForUser_result');
    if ($this->success !== null) {
      if (!is_array($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::LST, 0);
      {
        $output->writeListBegin(TType::STRUCT, count($this->success));
        {
          foreach ($this->success as $iter13)
          {
            $xfer += $iter13->write($output);
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    if ($this->tpe !== null) {
      $xfer += $output->writeFieldBegin('tpe', TType::STRUCT, 1);
      $xfer += $this->tpe->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ae !== null) {
      $xfer += $output->writeFieldBegin('ae', TType::STRUCT, 2);
      $xfer += $this->ae->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}


