/**
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Autogenerated by Thrift Compiler (0.9.3)
 *
 * DO NOT EDIT UNLESS YOU ARE SURE THAT YOU KNOW WHAT YOU ARE DOING
 *  @generated
 */
#include "compute_resource_model_types.h"

#include <algorithm>
#include <ostream>

#include <thrift/TToString.h>

namespace apache { namespace airavata { namespace model { namespace appcatalog { namespace computeresource {

int _kResourceJobManagerTypeValues[] = {
  ResourceJobManagerType::FORK,
  ResourceJobManagerType::PBS,
  ResourceJobManagerType::SLURM,
  ResourceJobManagerType::LSF,
  ResourceJobManagerType::UGE,
  ResourceJobManagerType::CLOUD,
  ResourceJobManagerType::AIRAVATA_CUSTOM
};
const char* _kResourceJobManagerTypeNames[] = {
  "FORK",
  "PBS",
  "SLURM",
  "LSF",
  "UGE",
  "CLOUD",
  "AIRAVATA_CUSTOM"
};
const std::map<int, const char*> _ResourceJobManagerType_VALUES_TO_NAMES(::apache::thrift::TEnumIterator(7, _kResourceJobManagerTypeValues, _kResourceJobManagerTypeNames), ::apache::thrift::TEnumIterator(-1, NULL, NULL));

int _kJobManagerCommandValues[] = {
  JobManagerCommand::SUBMISSION,
  JobManagerCommand::JOB_MONITORING,
  JobManagerCommand::DELETION,
  JobManagerCommand::CHECK_JOB,
  JobManagerCommand::SHOW_QUEUE,
  JobManagerCommand::SHOW_RESERVATION,
  JobManagerCommand::SHOW_START
};
const char* _kJobManagerCommandNames[] = {
  "SUBMISSION",
  "JOB_MONITORING",
  "DELETION",
  "CHECK_JOB",
  "SHOW_QUEUE",
  "SHOW_RESERVATION",
  "SHOW_START"
};
const std::map<int, const char*> _JobManagerCommand_VALUES_TO_NAMES(::apache::thrift::TEnumIterator(7, _kJobManagerCommandValues, _kJobManagerCommandNames), ::apache::thrift::TEnumIterator(-1, NULL, NULL));

int _kFileSystemsValues[] = {
  FileSystems::HOME,
  FileSystems::WORK,
  FileSystems::LOCALTMP,
  FileSystems::SCRATCH,
  FileSystems::ARCHIVE
};
const char* _kFileSystemsNames[] = {
  "HOME",
  "WORK",
  "LOCALTMP",
  "SCRATCH",
  "ARCHIVE"
};
const std::map<int, const char*> _FileSystems_VALUES_TO_NAMES(::apache::thrift::TEnumIterator(5, _kFileSystemsValues, _kFileSystemsNames), ::apache::thrift::TEnumIterator(-1, NULL, NULL));

int _kJobSubmissionProtocolValues[] = {
  JobSubmissionProtocol::LOCAL,
  JobSubmissionProtocol::SSH,
  JobSubmissionProtocol::GLOBUS,
  JobSubmissionProtocol::UNICORE,
  JobSubmissionProtocol::CLOUD,
  JobSubmissionProtocol::SSH_FORK,
  JobSubmissionProtocol::LOCAL_FORK
};
const char* _kJobSubmissionProtocolNames[] = {
  "LOCAL",
  "SSH",
  "GLOBUS",
  "UNICORE",
  "CLOUD",
  "SSH_FORK",
  "LOCAL_FORK"
};
const std::map<int, const char*> _JobSubmissionProtocol_VALUES_TO_NAMES(::apache::thrift::TEnumIterator(7, _kJobSubmissionProtocolValues, _kJobSubmissionProtocolNames), ::apache::thrift::TEnumIterator(-1, NULL, NULL));

int _kMonitorModeValues[] = {
  MonitorMode::POLL_JOB_MANAGER,
  MonitorMode::CLOUD_JOB_MONITOR,
  MonitorMode::JOB_EMAIL_NOTIFICATION_MONITOR,
  MonitorMode::XSEDE_AMQP_SUBSCRIBE,
  MonitorMode::FORK,
  MonitorMode::LOCAL
};
const char* _kMonitorModeNames[] = {
  "POLL_JOB_MANAGER",
  "CLOUD_JOB_MONITOR",
  "JOB_EMAIL_NOTIFICATION_MONITOR",
  "XSEDE_AMQP_SUBSCRIBE",
  "FORK",
  "LOCAL"
};
const std::map<int, const char*> _MonitorMode_VALUES_TO_NAMES(::apache::thrift::TEnumIterator(6, _kMonitorModeValues, _kMonitorModeNames), ::apache::thrift::TEnumIterator(-1, NULL, NULL));

int _kDMTypeValues[] = {
  DMType::COMPUTE_RESOURCE,
  DMType::STORAGE_RESOURCE
};
const char* _kDMTypeNames[] = {
  "COMPUTE_RESOURCE",
  "STORAGE_RESOURCE"
};
const std::map<int, const char*> _DMType_VALUES_TO_NAMES(::apache::thrift::TEnumIterator(2, _kDMTypeValues, _kDMTypeNames), ::apache::thrift::TEnumIterator(-1, NULL, NULL));

int _kProviderNameValues[] = {
  ProviderName::EC2,
  ProviderName::AWSEC2,
  ProviderName::RACKSPACE
};
const char* _kProviderNameNames[] = {
  "EC2",
  "AWSEC2",
  "RACKSPACE"
};
const std::map<int, const char*> _ProviderName_VALUES_TO_NAMES(::apache::thrift::TEnumIterator(3, _kProviderNameValues, _kProviderNameNames), ::apache::thrift::TEnumIterator(-1, NULL, NULL));


ResourceJobManager::~ResourceJobManager() throw() {
}


void ResourceJobManager::__set_resourceJobManagerId(const std::string& val) {
  this->resourceJobManagerId = val;
}

void ResourceJobManager::__set_resourceJobManagerType(const ResourceJobManagerType::type val) {
  this->resourceJobManagerType = val;
}

void ResourceJobManager::__set_pushMonitoringEndpoint(const std::string& val) {
  this->pushMonitoringEndpoint = val;
__isset.pushMonitoringEndpoint = true;
}

void ResourceJobManager::__set_jobManagerBinPath(const std::string& val) {
  this->jobManagerBinPath = val;
__isset.jobManagerBinPath = true;
}

void ResourceJobManager::__set_jobManagerCommands(const std::map<JobManagerCommand::type, std::string> & val) {
  this->jobManagerCommands = val;
__isset.jobManagerCommands = true;
}

void ResourceJobManager::__set_parallelismPrefix(const std::map< ::apache::airavata::model::appcatalog::parallelism::ApplicationParallelismType::type, std::string> & val) {
  this->parallelismPrefix = val;
__isset.parallelismPrefix = true;
}

uint32_t ResourceJobManager::read(::apache::thrift::protocol::TProtocol* iprot) {

  apache::thrift::protocol::TInputRecursionTracker tracker(*iprot);
  uint32_t xfer = 0;
  std::string fname;
  ::apache::thrift::protocol::TType ftype;
  int16_t fid;

  xfer += iprot->readStructBegin(fname);

  using ::apache::thrift::protocol::TProtocolException;

  bool isset_resourceJobManagerId = false;
  bool isset_resourceJobManagerType = false;

  while (true)
  {
    xfer += iprot->readFieldBegin(fname, ftype, fid);
    if (ftype == ::apache::thrift::protocol::T_STOP) {
      break;
    }
    switch (fid)
    {
      case 1:
        if (ftype == ::apache::thrift::protocol::T_STRING) {
          xfer += iprot->readString(this->resourceJobManagerId);
          isset_resourceJobManagerId = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 2:
        if (ftype == ::apache::thrift::protocol::T_I32) {
          int32_t ecast0;
          xfer += iprot->readI32(ecast0);
          this->resourceJobManagerType = (ResourceJobManagerType::type)ecast0;
          isset_resourceJobManagerType = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 3:
        if (ftype == ::apache::thrift::protocol::T_STRING) {
          xfer += iprot->readString(this->pushMonitoringEndpoint);
          this->__isset.pushMonitoringEndpoint = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 4:
        if (ftype == ::apache::thrift::protocol::T_STRING) {
          xfer += iprot->readString(this->jobManagerBinPath);
          this->__isset.jobManagerBinPath = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 5:
        if (ftype == ::apache::thrift::protocol::T_MAP) {
          {
            this->jobManagerCommands.clear();
            uint32_t _size1;
            ::apache::thrift::protocol::TType _ktype2;
            ::apache::thrift::protocol::TType _vtype3;
            xfer += iprot->readMapBegin(_ktype2, _vtype3, _size1);
            uint32_t _i5;
            for (_i5 = 0; _i5 < _size1; ++_i5)
            {
              JobManagerCommand::type _key6;
              int32_t ecast8;
              xfer += iprot->readI32(ecast8);
              _key6 = (JobManagerCommand::type)ecast8;
              std::string& _val7 = this->jobManagerCommands[_key6];
              xfer += iprot->readString(_val7);
            }
            xfer += iprot->readMapEnd();
          }
          this->__isset.jobManagerCommands = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 6:
        if (ftype == ::apache::thrift::protocol::T_MAP) {
          {
            this->parallelismPrefix.clear();
            uint32_t _size9;
            ::apache::thrift::protocol::TType _ktype10;
            ::apache::thrift::protocol::TType _vtype11;
            xfer += iprot->readMapBegin(_ktype10, _vtype11, _size9);
            uint32_t _i13;
            for (_i13 = 0; _i13 < _size9; ++_i13)
            {
               ::apache::airavata::model::appcatalog::parallelism::ApplicationParallelismType::type _key14;
              int32_t ecast16;
              xfer += iprot->readI32(ecast16);
              _key14 = ( ::apache::airavata::model::appcatalog::parallelism::ApplicationParallelismType::type)ecast16;
              std::string& _val15 = this->parallelismPrefix[_key14];
              xfer += iprot->readString(_val15);
            }
            xfer += iprot->readMapEnd();
          }
          this->__isset.parallelismPrefix = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      default:
        xfer += iprot->skip(ftype);
        break;
    }
    xfer += iprot->readFieldEnd();
  }

  xfer += iprot->readStructEnd();

  if (!isset_resourceJobManagerId)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  if (!isset_resourceJobManagerType)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  return xfer;
}

uint32_t ResourceJobManager::write(::apache::thrift::protocol::TProtocol* oprot) const {
  uint32_t xfer = 0;
  apache::thrift::protocol::TOutputRecursionTracker tracker(*oprot);
  xfer += oprot->writeStructBegin("ResourceJobManager");

  xfer += oprot->writeFieldBegin("resourceJobManagerId", ::apache::thrift::protocol::T_STRING, 1);
  xfer += oprot->writeString(this->resourceJobManagerId);
  xfer += oprot->writeFieldEnd();

  xfer += oprot->writeFieldBegin("resourceJobManagerType", ::apache::thrift::protocol::T_I32, 2);
  xfer += oprot->writeI32((int32_t)this->resourceJobManagerType);
  xfer += oprot->writeFieldEnd();

  if (this->__isset.pushMonitoringEndpoint) {
    xfer += oprot->writeFieldBegin("pushMonitoringEndpoint", ::apache::thrift::protocol::T_STRING, 3);
    xfer += oprot->writeString(this->pushMonitoringEndpoint);
    xfer += oprot->writeFieldEnd();
  }
  if (this->__isset.jobManagerBinPath) {
    xfer += oprot->writeFieldBegin("jobManagerBinPath", ::apache::thrift::protocol::T_STRING, 4);
    xfer += oprot->writeString(this->jobManagerBinPath);
    xfer += oprot->writeFieldEnd();
  }
  if (this->__isset.jobManagerCommands) {
    xfer += oprot->writeFieldBegin("jobManagerCommands", ::apache::thrift::protocol::T_MAP, 5);
    {
      xfer += oprot->writeMapBegin(::apache::thrift::protocol::T_I32, ::apache::thrift::protocol::T_STRING, static_cast<uint32_t>(this->jobManagerCommands.size()));
      std::map<JobManagerCommand::type, std::string> ::const_iterator _iter17;
      for (_iter17 = this->jobManagerCommands.begin(); _iter17 != this->jobManagerCommands.end(); ++_iter17)
      {
        xfer += oprot->writeI32((int32_t)_iter17->first);
        xfer += oprot->writeString(_iter17->second);
      }
      xfer += oprot->writeMapEnd();
    }
    xfer += oprot->writeFieldEnd();
  }
  if (this->__isset.parallelismPrefix) {
    xfer += oprot->writeFieldBegin("parallelismPrefix", ::apache::thrift::protocol::T_MAP, 6);
    {
      xfer += oprot->writeMapBegin(::apache::thrift::protocol::T_I32, ::apache::thrift::protocol::T_STRING, static_cast<uint32_t>(this->parallelismPrefix.size()));
      std::map< ::apache::airavata::model::appcatalog::parallelism::ApplicationParallelismType::type, std::string> ::const_iterator _iter18;
      for (_iter18 = this->parallelismPrefix.begin(); _iter18 != this->parallelismPrefix.end(); ++_iter18)
      {
        xfer += oprot->writeI32((int32_t)_iter18->first);
        xfer += oprot->writeString(_iter18->second);
      }
      xfer += oprot->writeMapEnd();
    }
    xfer += oprot->writeFieldEnd();
  }
  xfer += oprot->writeFieldStop();
  xfer += oprot->writeStructEnd();
  return xfer;
}

void swap(ResourceJobManager &a, ResourceJobManager &b) {
  using ::std::swap;
  swap(a.resourceJobManagerId, b.resourceJobManagerId);
  swap(a.resourceJobManagerType, b.resourceJobManagerType);
  swap(a.pushMonitoringEndpoint, b.pushMonitoringEndpoint);
  swap(a.jobManagerBinPath, b.jobManagerBinPath);
  swap(a.jobManagerCommands, b.jobManagerCommands);
  swap(a.parallelismPrefix, b.parallelismPrefix);
  swap(a.__isset, b.__isset);
}

ResourceJobManager::ResourceJobManager(const ResourceJobManager& other19) {
  resourceJobManagerId = other19.resourceJobManagerId;
  resourceJobManagerType = other19.resourceJobManagerType;
  pushMonitoringEndpoint = other19.pushMonitoringEndpoint;
  jobManagerBinPath = other19.jobManagerBinPath;
  jobManagerCommands = other19.jobManagerCommands;
  parallelismPrefix = other19.parallelismPrefix;
  __isset = other19.__isset;
}
ResourceJobManager& ResourceJobManager::operator=(const ResourceJobManager& other20) {
  resourceJobManagerId = other20.resourceJobManagerId;
  resourceJobManagerType = other20.resourceJobManagerType;
  pushMonitoringEndpoint = other20.pushMonitoringEndpoint;
  jobManagerBinPath = other20.jobManagerBinPath;
  jobManagerCommands = other20.jobManagerCommands;
  parallelismPrefix = other20.parallelismPrefix;
  __isset = other20.__isset;
  return *this;
}
void ResourceJobManager::printTo(std::ostream& out) const {
  using ::apache::thrift::to_string;
  out << "ResourceJobManager(";
  out << "resourceJobManagerId=" << to_string(resourceJobManagerId);
  out << ", " << "resourceJobManagerType=" << to_string(resourceJobManagerType);
  out << ", " << "pushMonitoringEndpoint="; (__isset.pushMonitoringEndpoint ? (out << to_string(pushMonitoringEndpoint)) : (out << "<null>"));
  out << ", " << "jobManagerBinPath="; (__isset.jobManagerBinPath ? (out << to_string(jobManagerBinPath)) : (out << "<null>"));
  out << ", " << "jobManagerCommands="; (__isset.jobManagerCommands ? (out << to_string(jobManagerCommands)) : (out << "<null>"));
  out << ", " << "parallelismPrefix="; (__isset.parallelismPrefix ? (out << to_string(parallelismPrefix)) : (out << "<null>"));
  out << ")";
}


BatchQueue::~BatchQueue() throw() {
}


void BatchQueue::__set_queueName(const std::string& val) {
  this->queueName = val;
}

void BatchQueue::__set_queueDescription(const std::string& val) {
  this->queueDescription = val;
__isset.queueDescription = true;
}

void BatchQueue::__set_maxRunTime(const int32_t val) {
  this->maxRunTime = val;
__isset.maxRunTime = true;
}

void BatchQueue::__set_maxNodes(const int32_t val) {
  this->maxNodes = val;
__isset.maxNodes = true;
}

void BatchQueue::__set_maxProcessors(const int32_t val) {
  this->maxProcessors = val;
__isset.maxProcessors = true;
}

void BatchQueue::__set_maxJobsInQueue(const int32_t val) {
  this->maxJobsInQueue = val;
__isset.maxJobsInQueue = true;
}

void BatchQueue::__set_maxMemory(const int32_t val) {
  this->maxMemory = val;
__isset.maxMemory = true;
}

void BatchQueue::__set_cpuPerNode(const int32_t val) {
  this->cpuPerNode = val;
__isset.cpuPerNode = true;
}

void BatchQueue::__set_defaultNodeCount(const int32_t val) {
  this->defaultNodeCount = val;
__isset.defaultNodeCount = true;
}

void BatchQueue::__set_defaultCPUCount(const int32_t val) {
  this->defaultCPUCount = val;
__isset.defaultCPUCount = true;
}

void BatchQueue::__set_defaultWalltime(const int32_t val) {
  this->defaultWalltime = val;
__isset.defaultWalltime = true;
}

void BatchQueue::__set_queueSpecificMacros(const std::string& val) {
  this->queueSpecificMacros = val;
__isset.queueSpecificMacros = true;
}

void BatchQueue::__set_isDefaultQueue(const bool val) {
  this->isDefaultQueue = val;
__isset.isDefaultQueue = true;
}

uint32_t BatchQueue::read(::apache::thrift::protocol::TProtocol* iprot) {

  apache::thrift::protocol::TInputRecursionTracker tracker(*iprot);
  uint32_t xfer = 0;
  std::string fname;
  ::apache::thrift::protocol::TType ftype;
  int16_t fid;

  xfer += iprot->readStructBegin(fname);

  using ::apache::thrift::protocol::TProtocolException;

  bool isset_queueName = false;

  while (true)
  {
    xfer += iprot->readFieldBegin(fname, ftype, fid);
    if (ftype == ::apache::thrift::protocol::T_STOP) {
      break;
    }
    switch (fid)
    {
      case 1:
        if (ftype == ::apache::thrift::protocol::T_STRING) {
          xfer += iprot->readString(this->queueName);
          isset_queueName = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 2:
        if (ftype == ::apache::thrift::protocol::T_STRING) {
          xfer += iprot->readString(this->queueDescription);
          this->__isset.queueDescription = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 3:
        if (ftype == ::apache::thrift::protocol::T_I32) {
          xfer += iprot->readI32(this->maxRunTime);
          this->__isset.maxRunTime = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 4:
        if (ftype == ::apache::thrift::protocol::T_I32) {
          xfer += iprot->readI32(this->maxNodes);
          this->__isset.maxNodes = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 5:
        if (ftype == ::apache::thrift::protocol::T_I32) {
          xfer += iprot->readI32(this->maxProcessors);
          this->__isset.maxProcessors = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 6:
        if (ftype == ::apache::thrift::protocol::T_I32) {
          xfer += iprot->readI32(this->maxJobsInQueue);
          this->__isset.maxJobsInQueue = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 7:
        if (ftype == ::apache::thrift::protocol::T_I32) {
          xfer += iprot->readI32(this->maxMemory);
          this->__isset.maxMemory = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 8:
        if (ftype == ::apache::thrift::protocol::T_I32) {
          xfer += iprot->readI32(this->cpuPerNode);
          this->__isset.cpuPerNode = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 9:
        if (ftype == ::apache::thrift::protocol::T_I32) {
          xfer += iprot->readI32(this->defaultNodeCount);
          this->__isset.defaultNodeCount = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 10:
        if (ftype == ::apache::thrift::protocol::T_I32) {
          xfer += iprot->readI32(this->defaultCPUCount);
          this->__isset.defaultCPUCount = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 11:
        if (ftype == ::apache::thrift::protocol::T_I32) {
          xfer += iprot->readI32(this->defaultWalltime);
          this->__isset.defaultWalltime = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 12:
        if (ftype == ::apache::thrift::protocol::T_STRING) {
          xfer += iprot->readString(this->queueSpecificMacros);
          this->__isset.queueSpecificMacros = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 13:
        if (ftype == ::apache::thrift::protocol::T_BOOL) {
          xfer += iprot->readBool(this->isDefaultQueue);
          this->__isset.isDefaultQueue = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      default:
        xfer += iprot->skip(ftype);
        break;
    }
    xfer += iprot->readFieldEnd();
  }

  xfer += iprot->readStructEnd();

  if (!isset_queueName)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  return xfer;
}

uint32_t BatchQueue::write(::apache::thrift::protocol::TProtocol* oprot) const {
  uint32_t xfer = 0;
  apache::thrift::protocol::TOutputRecursionTracker tracker(*oprot);
  xfer += oprot->writeStructBegin("BatchQueue");

  xfer += oprot->writeFieldBegin("queueName", ::apache::thrift::protocol::T_STRING, 1);
  xfer += oprot->writeString(this->queueName);
  xfer += oprot->writeFieldEnd();

  if (this->__isset.queueDescription) {
    xfer += oprot->writeFieldBegin("queueDescription", ::apache::thrift::protocol::T_STRING, 2);
    xfer += oprot->writeString(this->queueDescription);
    xfer += oprot->writeFieldEnd();
  }
  if (this->__isset.maxRunTime) {
    xfer += oprot->writeFieldBegin("maxRunTime", ::apache::thrift::protocol::T_I32, 3);
    xfer += oprot->writeI32(this->maxRunTime);
    xfer += oprot->writeFieldEnd();
  }
  if (this->__isset.maxNodes) {
    xfer += oprot->writeFieldBegin("maxNodes", ::apache::thrift::protocol::T_I32, 4);
    xfer += oprot->writeI32(this->maxNodes);
    xfer += oprot->writeFieldEnd();
  }
  if (this->__isset.maxProcessors) {
    xfer += oprot->writeFieldBegin("maxProcessors", ::apache::thrift::protocol::T_I32, 5);
    xfer += oprot->writeI32(this->maxProcessors);
    xfer += oprot->writeFieldEnd();
  }
  if (this->__isset.maxJobsInQueue) {
    xfer += oprot->writeFieldBegin("maxJobsInQueue", ::apache::thrift::protocol::T_I32, 6);
    xfer += oprot->writeI32(this->maxJobsInQueue);
    xfer += oprot->writeFieldEnd();
  }
  if (this->__isset.maxMemory) {
    xfer += oprot->writeFieldBegin("maxMemory", ::apache::thrift::protocol::T_I32, 7);
    xfer += oprot->writeI32(this->maxMemory);
    xfer += oprot->writeFieldEnd();
  }
  if (this->__isset.cpuPerNode) {
    xfer += oprot->writeFieldBegin("cpuPerNode", ::apache::thrift::protocol::T_I32, 8);
    xfer += oprot->writeI32(this->cpuPerNode);
    xfer += oprot->writeFieldEnd();
  }
  if (this->__isset.defaultNodeCount) {
    xfer += oprot->writeFieldBegin("defaultNodeCount", ::apache::thrift::protocol::T_I32, 9);
    xfer += oprot->writeI32(this->defaultNodeCount);
    xfer += oprot->writeFieldEnd();
  }
  if (this->__isset.defaultCPUCount) {
    xfer += oprot->writeFieldBegin("defaultCPUCount", ::apache::thrift::protocol::T_I32, 10);
    xfer += oprot->writeI32(this->defaultCPUCount);
    xfer += oprot->writeFieldEnd();
  }
  if (this->__isset.defaultWalltime) {
    xfer += oprot->writeFieldBegin("defaultWalltime", ::apache::thrift::protocol::T_I32, 11);
    xfer += oprot->writeI32(this->defaultWalltime);
    xfer += oprot->writeFieldEnd();
  }
  if (this->__isset.queueSpecificMacros) {
    xfer += oprot->writeFieldBegin("queueSpecificMacros", ::apache::thrift::protocol::T_STRING, 12);
    xfer += oprot->writeString(this->queueSpecificMacros);
    xfer += oprot->writeFieldEnd();
  }
  if (this->__isset.isDefaultQueue) {
    xfer += oprot->writeFieldBegin("isDefaultQueue", ::apache::thrift::protocol::T_BOOL, 13);
    xfer += oprot->writeBool(this->isDefaultQueue);
    xfer += oprot->writeFieldEnd();
  }
  xfer += oprot->writeFieldStop();
  xfer += oprot->writeStructEnd();
  return xfer;
}

void swap(BatchQueue &a, BatchQueue &b) {
  using ::std::swap;
  swap(a.queueName, b.queueName);
  swap(a.queueDescription, b.queueDescription);
  swap(a.maxRunTime, b.maxRunTime);
  swap(a.maxNodes, b.maxNodes);
  swap(a.maxProcessors, b.maxProcessors);
  swap(a.maxJobsInQueue, b.maxJobsInQueue);
  swap(a.maxMemory, b.maxMemory);
  swap(a.cpuPerNode, b.cpuPerNode);
  swap(a.defaultNodeCount, b.defaultNodeCount);
  swap(a.defaultCPUCount, b.defaultCPUCount);
  swap(a.defaultWalltime, b.defaultWalltime);
  swap(a.queueSpecificMacros, b.queueSpecificMacros);
  swap(a.isDefaultQueue, b.isDefaultQueue);
  swap(a.__isset, b.__isset);
}

BatchQueue::BatchQueue(const BatchQueue& other21) {
  queueName = other21.queueName;
  queueDescription = other21.queueDescription;
  maxRunTime = other21.maxRunTime;
  maxNodes = other21.maxNodes;
  maxProcessors = other21.maxProcessors;
  maxJobsInQueue = other21.maxJobsInQueue;
  maxMemory = other21.maxMemory;
  cpuPerNode = other21.cpuPerNode;
  defaultNodeCount = other21.defaultNodeCount;
  defaultCPUCount = other21.defaultCPUCount;
  defaultWalltime = other21.defaultWalltime;
  queueSpecificMacros = other21.queueSpecificMacros;
  isDefaultQueue = other21.isDefaultQueue;
  __isset = other21.__isset;
}
BatchQueue& BatchQueue::operator=(const BatchQueue& other22) {
  queueName = other22.queueName;
  queueDescription = other22.queueDescription;
  maxRunTime = other22.maxRunTime;
  maxNodes = other22.maxNodes;
  maxProcessors = other22.maxProcessors;
  maxJobsInQueue = other22.maxJobsInQueue;
  maxMemory = other22.maxMemory;
  cpuPerNode = other22.cpuPerNode;
  defaultNodeCount = other22.defaultNodeCount;
  defaultCPUCount = other22.defaultCPUCount;
  defaultWalltime = other22.defaultWalltime;
  queueSpecificMacros = other22.queueSpecificMacros;
  isDefaultQueue = other22.isDefaultQueue;
  __isset = other22.__isset;
  return *this;
}
void BatchQueue::printTo(std::ostream& out) const {
  using ::apache::thrift::to_string;
  out << "BatchQueue(";
  out << "queueName=" << to_string(queueName);
  out << ", " << "queueDescription="; (__isset.queueDescription ? (out << to_string(queueDescription)) : (out << "<null>"));
  out << ", " << "maxRunTime="; (__isset.maxRunTime ? (out << to_string(maxRunTime)) : (out << "<null>"));
  out << ", " << "maxNodes="; (__isset.maxNodes ? (out << to_string(maxNodes)) : (out << "<null>"));
  out << ", " << "maxProcessors="; (__isset.maxProcessors ? (out << to_string(maxProcessors)) : (out << "<null>"));
  out << ", " << "maxJobsInQueue="; (__isset.maxJobsInQueue ? (out << to_string(maxJobsInQueue)) : (out << "<null>"));
  out << ", " << "maxMemory="; (__isset.maxMemory ? (out << to_string(maxMemory)) : (out << "<null>"));
  out << ", " << "cpuPerNode="; (__isset.cpuPerNode ? (out << to_string(cpuPerNode)) : (out << "<null>"));
  out << ", " << "defaultNodeCount="; (__isset.defaultNodeCount ? (out << to_string(defaultNodeCount)) : (out << "<null>"));
  out << ", " << "defaultCPUCount="; (__isset.defaultCPUCount ? (out << to_string(defaultCPUCount)) : (out << "<null>"));
  out << ", " << "defaultWalltime="; (__isset.defaultWalltime ? (out << to_string(defaultWalltime)) : (out << "<null>"));
  out << ", " << "queueSpecificMacros="; (__isset.queueSpecificMacros ? (out << to_string(queueSpecificMacros)) : (out << "<null>"));
  out << ", " << "isDefaultQueue="; (__isset.isDefaultQueue ? (out << to_string(isDefaultQueue)) : (out << "<null>"));
  out << ")";
}


LOCALSubmission::~LOCALSubmission() throw() {
}


void LOCALSubmission::__set_jobSubmissionInterfaceId(const std::string& val) {
  this->jobSubmissionInterfaceId = val;
}

void LOCALSubmission::__set_resourceJobManager(const ResourceJobManager& val) {
  this->resourceJobManager = val;
}

void LOCALSubmission::__set_securityProtocol(const  ::apache::airavata::model::data::movement::SecurityProtocol::type val) {
  this->securityProtocol = val;
}

uint32_t LOCALSubmission::read(::apache::thrift::protocol::TProtocol* iprot) {

  apache::thrift::protocol::TInputRecursionTracker tracker(*iprot);
  uint32_t xfer = 0;
  std::string fname;
  ::apache::thrift::protocol::TType ftype;
  int16_t fid;

  xfer += iprot->readStructBegin(fname);

  using ::apache::thrift::protocol::TProtocolException;

  bool isset_jobSubmissionInterfaceId = false;
  bool isset_resourceJobManager = false;
  bool isset_securityProtocol = false;

  while (true)
  {
    xfer += iprot->readFieldBegin(fname, ftype, fid);
    if (ftype == ::apache::thrift::protocol::T_STOP) {
      break;
    }
    switch (fid)
    {
      case 1:
        if (ftype == ::apache::thrift::protocol::T_STRING) {
          xfer += iprot->readString(this->jobSubmissionInterfaceId);
          isset_jobSubmissionInterfaceId = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 2:
        if (ftype == ::apache::thrift::protocol::T_STRUCT) {
          xfer += this->resourceJobManager.read(iprot);
          isset_resourceJobManager = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 3:
        if (ftype == ::apache::thrift::protocol::T_I32) {
          int32_t ecast23;
          xfer += iprot->readI32(ecast23);
          this->securityProtocol = ( ::apache::airavata::model::data::movement::SecurityProtocol::type)ecast23;
          isset_securityProtocol = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      default:
        xfer += iprot->skip(ftype);
        break;
    }
    xfer += iprot->readFieldEnd();
  }

  xfer += iprot->readStructEnd();

  if (!isset_jobSubmissionInterfaceId)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  if (!isset_resourceJobManager)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  if (!isset_securityProtocol)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  return xfer;
}

uint32_t LOCALSubmission::write(::apache::thrift::protocol::TProtocol* oprot) const {
  uint32_t xfer = 0;
  apache::thrift::protocol::TOutputRecursionTracker tracker(*oprot);
  xfer += oprot->writeStructBegin("LOCALSubmission");

  xfer += oprot->writeFieldBegin("jobSubmissionInterfaceId", ::apache::thrift::protocol::T_STRING, 1);
  xfer += oprot->writeString(this->jobSubmissionInterfaceId);
  xfer += oprot->writeFieldEnd();

  xfer += oprot->writeFieldBegin("resourceJobManager", ::apache::thrift::protocol::T_STRUCT, 2);
  xfer += this->resourceJobManager.write(oprot);
  xfer += oprot->writeFieldEnd();

  xfer += oprot->writeFieldBegin("securityProtocol", ::apache::thrift::protocol::T_I32, 3);
  xfer += oprot->writeI32((int32_t)this->securityProtocol);
  xfer += oprot->writeFieldEnd();

  xfer += oprot->writeFieldStop();
  xfer += oprot->writeStructEnd();
  return xfer;
}

void swap(LOCALSubmission &a, LOCALSubmission &b) {
  using ::std::swap;
  swap(a.jobSubmissionInterfaceId, b.jobSubmissionInterfaceId);
  swap(a.resourceJobManager, b.resourceJobManager);
  swap(a.securityProtocol, b.securityProtocol);
}

LOCALSubmission::LOCALSubmission(const LOCALSubmission& other24) {
  jobSubmissionInterfaceId = other24.jobSubmissionInterfaceId;
  resourceJobManager = other24.resourceJobManager;
  securityProtocol = other24.securityProtocol;
}
LOCALSubmission& LOCALSubmission::operator=(const LOCALSubmission& other25) {
  jobSubmissionInterfaceId = other25.jobSubmissionInterfaceId;
  resourceJobManager = other25.resourceJobManager;
  securityProtocol = other25.securityProtocol;
  return *this;
}
void LOCALSubmission::printTo(std::ostream& out) const {
  using ::apache::thrift::to_string;
  out << "LOCALSubmission(";
  out << "jobSubmissionInterfaceId=" << to_string(jobSubmissionInterfaceId);
  out << ", " << "resourceJobManager=" << to_string(resourceJobManager);
  out << ", " << "securityProtocol=" << to_string(securityProtocol);
  out << ")";
}


SSHJobSubmission::~SSHJobSubmission() throw() {
}


void SSHJobSubmission::__set_jobSubmissionInterfaceId(const std::string& val) {
  this->jobSubmissionInterfaceId = val;
}

void SSHJobSubmission::__set_securityProtocol(const  ::apache::airavata::model::data::movement::SecurityProtocol::type val) {
  this->securityProtocol = val;
}

void SSHJobSubmission::__set_resourceJobManager(const ResourceJobManager& val) {
  this->resourceJobManager = val;
}

void SSHJobSubmission::__set_alternativeSSHHostName(const std::string& val) {
  this->alternativeSSHHostName = val;
__isset.alternativeSSHHostName = true;
}

void SSHJobSubmission::__set_sshPort(const int32_t val) {
  this->sshPort = val;
__isset.sshPort = true;
}

void SSHJobSubmission::__set_monitorMode(const MonitorMode::type val) {
  this->monitorMode = val;
__isset.monitorMode = true;
}

void SSHJobSubmission::__set_batchQueueEmailSenders(const std::vector<std::string> & val) {
  this->batchQueueEmailSenders = val;
__isset.batchQueueEmailSenders = true;
}

uint32_t SSHJobSubmission::read(::apache::thrift::protocol::TProtocol* iprot) {

  apache::thrift::protocol::TInputRecursionTracker tracker(*iprot);
  uint32_t xfer = 0;
  std::string fname;
  ::apache::thrift::protocol::TType ftype;
  int16_t fid;

  xfer += iprot->readStructBegin(fname);

  using ::apache::thrift::protocol::TProtocolException;

  bool isset_jobSubmissionInterfaceId = false;
  bool isset_securityProtocol = false;
  bool isset_resourceJobManager = false;

  while (true)
  {
    xfer += iprot->readFieldBegin(fname, ftype, fid);
    if (ftype == ::apache::thrift::protocol::T_STOP) {
      break;
    }
    switch (fid)
    {
      case 1:
        if (ftype == ::apache::thrift::protocol::T_STRING) {
          xfer += iprot->readString(this->jobSubmissionInterfaceId);
          isset_jobSubmissionInterfaceId = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 2:
        if (ftype == ::apache::thrift::protocol::T_I32) {
          int32_t ecast26;
          xfer += iprot->readI32(ecast26);
          this->securityProtocol = ( ::apache::airavata::model::data::movement::SecurityProtocol::type)ecast26;
          isset_securityProtocol = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 3:
        if (ftype == ::apache::thrift::protocol::T_STRUCT) {
          xfer += this->resourceJobManager.read(iprot);
          isset_resourceJobManager = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 4:
        if (ftype == ::apache::thrift::protocol::T_STRING) {
          xfer += iprot->readString(this->alternativeSSHHostName);
          this->__isset.alternativeSSHHostName = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 5:
        if (ftype == ::apache::thrift::protocol::T_I32) {
          xfer += iprot->readI32(this->sshPort);
          this->__isset.sshPort = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 6:
        if (ftype == ::apache::thrift::protocol::T_I32) {
          int32_t ecast27;
          xfer += iprot->readI32(ecast27);
          this->monitorMode = (MonitorMode::type)ecast27;
          this->__isset.monitorMode = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 7:
        if (ftype == ::apache::thrift::protocol::T_LIST) {
          {
            this->batchQueueEmailSenders.clear();
            uint32_t _size28;
            ::apache::thrift::protocol::TType _etype31;
            xfer += iprot->readListBegin(_etype31, _size28);
            this->batchQueueEmailSenders.resize(_size28);
            uint32_t _i32;
            for (_i32 = 0; _i32 < _size28; ++_i32)
            {
              xfer += iprot->readString(this->batchQueueEmailSenders[_i32]);
            }
            xfer += iprot->readListEnd();
          }
          this->__isset.batchQueueEmailSenders = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      default:
        xfer += iprot->skip(ftype);
        break;
    }
    xfer += iprot->readFieldEnd();
  }

  xfer += iprot->readStructEnd();

  if (!isset_jobSubmissionInterfaceId)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  if (!isset_securityProtocol)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  if (!isset_resourceJobManager)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  return xfer;
}

uint32_t SSHJobSubmission::write(::apache::thrift::protocol::TProtocol* oprot) const {
  uint32_t xfer = 0;
  apache::thrift::protocol::TOutputRecursionTracker tracker(*oprot);
  xfer += oprot->writeStructBegin("SSHJobSubmission");

  xfer += oprot->writeFieldBegin("jobSubmissionInterfaceId", ::apache::thrift::protocol::T_STRING, 1);
  xfer += oprot->writeString(this->jobSubmissionInterfaceId);
  xfer += oprot->writeFieldEnd();

  xfer += oprot->writeFieldBegin("securityProtocol", ::apache::thrift::protocol::T_I32, 2);
  xfer += oprot->writeI32((int32_t)this->securityProtocol);
  xfer += oprot->writeFieldEnd();

  xfer += oprot->writeFieldBegin("resourceJobManager", ::apache::thrift::protocol::T_STRUCT, 3);
  xfer += this->resourceJobManager.write(oprot);
  xfer += oprot->writeFieldEnd();

  if (this->__isset.alternativeSSHHostName) {
    xfer += oprot->writeFieldBegin("alternativeSSHHostName", ::apache::thrift::protocol::T_STRING, 4);
    xfer += oprot->writeString(this->alternativeSSHHostName);
    xfer += oprot->writeFieldEnd();
  }
  if (this->__isset.sshPort) {
    xfer += oprot->writeFieldBegin("sshPort", ::apache::thrift::protocol::T_I32, 5);
    xfer += oprot->writeI32(this->sshPort);
    xfer += oprot->writeFieldEnd();
  }
  if (this->__isset.monitorMode) {
    xfer += oprot->writeFieldBegin("monitorMode", ::apache::thrift::protocol::T_I32, 6);
    xfer += oprot->writeI32((int32_t)this->monitorMode);
    xfer += oprot->writeFieldEnd();
  }
  if (this->__isset.batchQueueEmailSenders) {
    xfer += oprot->writeFieldBegin("batchQueueEmailSenders", ::apache::thrift::protocol::T_LIST, 7);
    {
      xfer += oprot->writeListBegin(::apache::thrift::protocol::T_STRING, static_cast<uint32_t>(this->batchQueueEmailSenders.size()));
      std::vector<std::string> ::const_iterator _iter33;
      for (_iter33 = this->batchQueueEmailSenders.begin(); _iter33 != this->batchQueueEmailSenders.end(); ++_iter33)
      {
        xfer += oprot->writeString((*_iter33));
      }
      xfer += oprot->writeListEnd();
    }
    xfer += oprot->writeFieldEnd();
  }
  xfer += oprot->writeFieldStop();
  xfer += oprot->writeStructEnd();
  return xfer;
}

void swap(SSHJobSubmission &a, SSHJobSubmission &b) {
  using ::std::swap;
  swap(a.jobSubmissionInterfaceId, b.jobSubmissionInterfaceId);
  swap(a.securityProtocol, b.securityProtocol);
  swap(a.resourceJobManager, b.resourceJobManager);
  swap(a.alternativeSSHHostName, b.alternativeSSHHostName);
  swap(a.sshPort, b.sshPort);
  swap(a.monitorMode, b.monitorMode);
  swap(a.batchQueueEmailSenders, b.batchQueueEmailSenders);
  swap(a.__isset, b.__isset);
}

SSHJobSubmission::SSHJobSubmission(const SSHJobSubmission& other34) {
  jobSubmissionInterfaceId = other34.jobSubmissionInterfaceId;
  securityProtocol = other34.securityProtocol;
  resourceJobManager = other34.resourceJobManager;
  alternativeSSHHostName = other34.alternativeSSHHostName;
  sshPort = other34.sshPort;
  monitorMode = other34.monitorMode;
  batchQueueEmailSenders = other34.batchQueueEmailSenders;
  __isset = other34.__isset;
}
SSHJobSubmission& SSHJobSubmission::operator=(const SSHJobSubmission& other35) {
  jobSubmissionInterfaceId = other35.jobSubmissionInterfaceId;
  securityProtocol = other35.securityProtocol;
  resourceJobManager = other35.resourceJobManager;
  alternativeSSHHostName = other35.alternativeSSHHostName;
  sshPort = other35.sshPort;
  monitorMode = other35.monitorMode;
  batchQueueEmailSenders = other35.batchQueueEmailSenders;
  __isset = other35.__isset;
  return *this;
}
void SSHJobSubmission::printTo(std::ostream& out) const {
  using ::apache::thrift::to_string;
  out << "SSHJobSubmission(";
  out << "jobSubmissionInterfaceId=" << to_string(jobSubmissionInterfaceId);
  out << ", " << "securityProtocol=" << to_string(securityProtocol);
  out << ", " << "resourceJobManager=" << to_string(resourceJobManager);
  out << ", " << "alternativeSSHHostName="; (__isset.alternativeSSHHostName ? (out << to_string(alternativeSSHHostName)) : (out << "<null>"));
  out << ", " << "sshPort="; (__isset.sshPort ? (out << to_string(sshPort)) : (out << "<null>"));
  out << ", " << "monitorMode="; (__isset.monitorMode ? (out << to_string(monitorMode)) : (out << "<null>"));
  out << ", " << "batchQueueEmailSenders="; (__isset.batchQueueEmailSenders ? (out << to_string(batchQueueEmailSenders)) : (out << "<null>"));
  out << ")";
}


GlobusJobSubmission::~GlobusJobSubmission() throw() {
}


void GlobusJobSubmission::__set_jobSubmissionInterfaceId(const std::string& val) {
  this->jobSubmissionInterfaceId = val;
}

void GlobusJobSubmission::__set_securityProtocol(const  ::apache::airavata::model::data::movement::SecurityProtocol::type val) {
  this->securityProtocol = val;
}

void GlobusJobSubmission::__set_globusGateKeeperEndPoint(const std::vector<std::string> & val) {
  this->globusGateKeeperEndPoint = val;
__isset.globusGateKeeperEndPoint = true;
}

uint32_t GlobusJobSubmission::read(::apache::thrift::protocol::TProtocol* iprot) {

  apache::thrift::protocol::TInputRecursionTracker tracker(*iprot);
  uint32_t xfer = 0;
  std::string fname;
  ::apache::thrift::protocol::TType ftype;
  int16_t fid;

  xfer += iprot->readStructBegin(fname);

  using ::apache::thrift::protocol::TProtocolException;

  bool isset_jobSubmissionInterfaceId = false;
  bool isset_securityProtocol = false;

  while (true)
  {
    xfer += iprot->readFieldBegin(fname, ftype, fid);
    if (ftype == ::apache::thrift::protocol::T_STOP) {
      break;
    }
    switch (fid)
    {
      case 1:
        if (ftype == ::apache::thrift::protocol::T_STRING) {
          xfer += iprot->readString(this->jobSubmissionInterfaceId);
          isset_jobSubmissionInterfaceId = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 2:
        if (ftype == ::apache::thrift::protocol::T_I32) {
          int32_t ecast36;
          xfer += iprot->readI32(ecast36);
          this->securityProtocol = ( ::apache::airavata::model::data::movement::SecurityProtocol::type)ecast36;
          isset_securityProtocol = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 3:
        if (ftype == ::apache::thrift::protocol::T_LIST) {
          {
            this->globusGateKeeperEndPoint.clear();
            uint32_t _size37;
            ::apache::thrift::protocol::TType _etype40;
            xfer += iprot->readListBegin(_etype40, _size37);
            this->globusGateKeeperEndPoint.resize(_size37);
            uint32_t _i41;
            for (_i41 = 0; _i41 < _size37; ++_i41)
            {
              xfer += iprot->readString(this->globusGateKeeperEndPoint[_i41]);
            }
            xfer += iprot->readListEnd();
          }
          this->__isset.globusGateKeeperEndPoint = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      default:
        xfer += iprot->skip(ftype);
        break;
    }
    xfer += iprot->readFieldEnd();
  }

  xfer += iprot->readStructEnd();

  if (!isset_jobSubmissionInterfaceId)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  if (!isset_securityProtocol)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  return xfer;
}

uint32_t GlobusJobSubmission::write(::apache::thrift::protocol::TProtocol* oprot) const {
  uint32_t xfer = 0;
  apache::thrift::protocol::TOutputRecursionTracker tracker(*oprot);
  xfer += oprot->writeStructBegin("GlobusJobSubmission");

  xfer += oprot->writeFieldBegin("jobSubmissionInterfaceId", ::apache::thrift::protocol::T_STRING, 1);
  xfer += oprot->writeString(this->jobSubmissionInterfaceId);
  xfer += oprot->writeFieldEnd();

  xfer += oprot->writeFieldBegin("securityProtocol", ::apache::thrift::protocol::T_I32, 2);
  xfer += oprot->writeI32((int32_t)this->securityProtocol);
  xfer += oprot->writeFieldEnd();

  if (this->__isset.globusGateKeeperEndPoint) {
    xfer += oprot->writeFieldBegin("globusGateKeeperEndPoint", ::apache::thrift::protocol::T_LIST, 3);
    {
      xfer += oprot->writeListBegin(::apache::thrift::protocol::T_STRING, static_cast<uint32_t>(this->globusGateKeeperEndPoint.size()));
      std::vector<std::string> ::const_iterator _iter42;
      for (_iter42 = this->globusGateKeeperEndPoint.begin(); _iter42 != this->globusGateKeeperEndPoint.end(); ++_iter42)
      {
        xfer += oprot->writeString((*_iter42));
      }
      xfer += oprot->writeListEnd();
    }
    xfer += oprot->writeFieldEnd();
  }
  xfer += oprot->writeFieldStop();
  xfer += oprot->writeStructEnd();
  return xfer;
}

void swap(GlobusJobSubmission &a, GlobusJobSubmission &b) {
  using ::std::swap;
  swap(a.jobSubmissionInterfaceId, b.jobSubmissionInterfaceId);
  swap(a.securityProtocol, b.securityProtocol);
  swap(a.globusGateKeeperEndPoint, b.globusGateKeeperEndPoint);
  swap(a.__isset, b.__isset);
}

GlobusJobSubmission::GlobusJobSubmission(const GlobusJobSubmission& other43) {
  jobSubmissionInterfaceId = other43.jobSubmissionInterfaceId;
  securityProtocol = other43.securityProtocol;
  globusGateKeeperEndPoint = other43.globusGateKeeperEndPoint;
  __isset = other43.__isset;
}
GlobusJobSubmission& GlobusJobSubmission::operator=(const GlobusJobSubmission& other44) {
  jobSubmissionInterfaceId = other44.jobSubmissionInterfaceId;
  securityProtocol = other44.securityProtocol;
  globusGateKeeperEndPoint = other44.globusGateKeeperEndPoint;
  __isset = other44.__isset;
  return *this;
}
void GlobusJobSubmission::printTo(std::ostream& out) const {
  using ::apache::thrift::to_string;
  out << "GlobusJobSubmission(";
  out << "jobSubmissionInterfaceId=" << to_string(jobSubmissionInterfaceId);
  out << ", " << "securityProtocol=" << to_string(securityProtocol);
  out << ", " << "globusGateKeeperEndPoint="; (__isset.globusGateKeeperEndPoint ? (out << to_string(globusGateKeeperEndPoint)) : (out << "<null>"));
  out << ")";
}


UnicoreJobSubmission::~UnicoreJobSubmission() throw() {
}


void UnicoreJobSubmission::__set_jobSubmissionInterfaceId(const std::string& val) {
  this->jobSubmissionInterfaceId = val;
}

void UnicoreJobSubmission::__set_securityProtocol(const  ::apache::airavata::model::data::movement::SecurityProtocol::type val) {
  this->securityProtocol = val;
}

void UnicoreJobSubmission::__set_unicoreEndPointURL(const std::string& val) {
  this->unicoreEndPointURL = val;
}

uint32_t UnicoreJobSubmission::read(::apache::thrift::protocol::TProtocol* iprot) {

  apache::thrift::protocol::TInputRecursionTracker tracker(*iprot);
  uint32_t xfer = 0;
  std::string fname;
  ::apache::thrift::protocol::TType ftype;
  int16_t fid;

  xfer += iprot->readStructBegin(fname);

  using ::apache::thrift::protocol::TProtocolException;

  bool isset_jobSubmissionInterfaceId = false;
  bool isset_securityProtocol = false;
  bool isset_unicoreEndPointURL = false;

  while (true)
  {
    xfer += iprot->readFieldBegin(fname, ftype, fid);
    if (ftype == ::apache::thrift::protocol::T_STOP) {
      break;
    }
    switch (fid)
    {
      case 1:
        if (ftype == ::apache::thrift::protocol::T_STRING) {
          xfer += iprot->readString(this->jobSubmissionInterfaceId);
          isset_jobSubmissionInterfaceId = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 2:
        if (ftype == ::apache::thrift::protocol::T_I32) {
          int32_t ecast45;
          xfer += iprot->readI32(ecast45);
          this->securityProtocol = ( ::apache::airavata::model::data::movement::SecurityProtocol::type)ecast45;
          isset_securityProtocol = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 3:
        if (ftype == ::apache::thrift::protocol::T_STRING) {
          xfer += iprot->readString(this->unicoreEndPointURL);
          isset_unicoreEndPointURL = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      default:
        xfer += iprot->skip(ftype);
        break;
    }
    xfer += iprot->readFieldEnd();
  }

  xfer += iprot->readStructEnd();

  if (!isset_jobSubmissionInterfaceId)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  if (!isset_securityProtocol)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  if (!isset_unicoreEndPointURL)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  return xfer;
}

uint32_t UnicoreJobSubmission::write(::apache::thrift::protocol::TProtocol* oprot) const {
  uint32_t xfer = 0;
  apache::thrift::protocol::TOutputRecursionTracker tracker(*oprot);
  xfer += oprot->writeStructBegin("UnicoreJobSubmission");

  xfer += oprot->writeFieldBegin("jobSubmissionInterfaceId", ::apache::thrift::protocol::T_STRING, 1);
  xfer += oprot->writeString(this->jobSubmissionInterfaceId);
  xfer += oprot->writeFieldEnd();

  xfer += oprot->writeFieldBegin("securityProtocol", ::apache::thrift::protocol::T_I32, 2);
  xfer += oprot->writeI32((int32_t)this->securityProtocol);
  xfer += oprot->writeFieldEnd();

  xfer += oprot->writeFieldBegin("unicoreEndPointURL", ::apache::thrift::protocol::T_STRING, 3);
  xfer += oprot->writeString(this->unicoreEndPointURL);
  xfer += oprot->writeFieldEnd();

  xfer += oprot->writeFieldStop();
  xfer += oprot->writeStructEnd();
  return xfer;
}

void swap(UnicoreJobSubmission &a, UnicoreJobSubmission &b) {
  using ::std::swap;
  swap(a.jobSubmissionInterfaceId, b.jobSubmissionInterfaceId);
  swap(a.securityProtocol, b.securityProtocol);
  swap(a.unicoreEndPointURL, b.unicoreEndPointURL);
}

UnicoreJobSubmission::UnicoreJobSubmission(const UnicoreJobSubmission& other46) {
  jobSubmissionInterfaceId = other46.jobSubmissionInterfaceId;
  securityProtocol = other46.securityProtocol;
  unicoreEndPointURL = other46.unicoreEndPointURL;
}
UnicoreJobSubmission& UnicoreJobSubmission::operator=(const UnicoreJobSubmission& other47) {
  jobSubmissionInterfaceId = other47.jobSubmissionInterfaceId;
  securityProtocol = other47.securityProtocol;
  unicoreEndPointURL = other47.unicoreEndPointURL;
  return *this;
}
void UnicoreJobSubmission::printTo(std::ostream& out) const {
  using ::apache::thrift::to_string;
  out << "UnicoreJobSubmission(";
  out << "jobSubmissionInterfaceId=" << to_string(jobSubmissionInterfaceId);
  out << ", " << "securityProtocol=" << to_string(securityProtocol);
  out << ", " << "unicoreEndPointURL=" << to_string(unicoreEndPointURL);
  out << ")";
}


CloudJobSubmission::~CloudJobSubmission() throw() {
}


void CloudJobSubmission::__set_jobSubmissionInterfaceId(const std::string& val) {
  this->jobSubmissionInterfaceId = val;
}

void CloudJobSubmission::__set_securityProtocol(const  ::apache::airavata::model::data::movement::SecurityProtocol::type val) {
  this->securityProtocol = val;
}

void CloudJobSubmission::__set_nodeId(const std::string& val) {
  this->nodeId = val;
}

void CloudJobSubmission::__set_executableType(const std::string& val) {
  this->executableType = val;
}

void CloudJobSubmission::__set_providerName(const ProviderName::type val) {
  this->providerName = val;
}

void CloudJobSubmission::__set_userAccountName(const std::string& val) {
  this->userAccountName = val;
}

uint32_t CloudJobSubmission::read(::apache::thrift::protocol::TProtocol* iprot) {

  apache::thrift::protocol::TInputRecursionTracker tracker(*iprot);
  uint32_t xfer = 0;
  std::string fname;
  ::apache::thrift::protocol::TType ftype;
  int16_t fid;

  xfer += iprot->readStructBegin(fname);

  using ::apache::thrift::protocol::TProtocolException;

  bool isset_jobSubmissionInterfaceId = false;
  bool isset_securityProtocol = false;
  bool isset_nodeId = false;
  bool isset_executableType = false;
  bool isset_providerName = false;
  bool isset_userAccountName = false;

  while (true)
  {
    xfer += iprot->readFieldBegin(fname, ftype, fid);
    if (ftype == ::apache::thrift::protocol::T_STOP) {
      break;
    }
    switch (fid)
    {
      case 1:
        if (ftype == ::apache::thrift::protocol::T_STRING) {
          xfer += iprot->readString(this->jobSubmissionInterfaceId);
          isset_jobSubmissionInterfaceId = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 2:
        if (ftype == ::apache::thrift::protocol::T_I32) {
          int32_t ecast48;
          xfer += iprot->readI32(ecast48);
          this->securityProtocol = ( ::apache::airavata::model::data::movement::SecurityProtocol::type)ecast48;
          isset_securityProtocol = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 3:
        if (ftype == ::apache::thrift::protocol::T_STRING) {
          xfer += iprot->readString(this->nodeId);
          isset_nodeId = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 4:
        if (ftype == ::apache::thrift::protocol::T_STRING) {
          xfer += iprot->readString(this->executableType);
          isset_executableType = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 5:
        if (ftype == ::apache::thrift::protocol::T_I32) {
          int32_t ecast49;
          xfer += iprot->readI32(ecast49);
          this->providerName = (ProviderName::type)ecast49;
          isset_providerName = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 6:
        if (ftype == ::apache::thrift::protocol::T_STRING) {
          xfer += iprot->readString(this->userAccountName);
          isset_userAccountName = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      default:
        xfer += iprot->skip(ftype);
        break;
    }
    xfer += iprot->readFieldEnd();
  }

  xfer += iprot->readStructEnd();

  if (!isset_jobSubmissionInterfaceId)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  if (!isset_securityProtocol)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  if (!isset_nodeId)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  if (!isset_executableType)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  if (!isset_providerName)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  if (!isset_userAccountName)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  return xfer;
}

uint32_t CloudJobSubmission::write(::apache::thrift::protocol::TProtocol* oprot) const {
  uint32_t xfer = 0;
  apache::thrift::protocol::TOutputRecursionTracker tracker(*oprot);
  xfer += oprot->writeStructBegin("CloudJobSubmission");

  xfer += oprot->writeFieldBegin("jobSubmissionInterfaceId", ::apache::thrift::protocol::T_STRING, 1);
  xfer += oprot->writeString(this->jobSubmissionInterfaceId);
  xfer += oprot->writeFieldEnd();

  xfer += oprot->writeFieldBegin("securityProtocol", ::apache::thrift::protocol::T_I32, 2);
  xfer += oprot->writeI32((int32_t)this->securityProtocol);
  xfer += oprot->writeFieldEnd();

  xfer += oprot->writeFieldBegin("nodeId", ::apache::thrift::protocol::T_STRING, 3);
  xfer += oprot->writeString(this->nodeId);
  xfer += oprot->writeFieldEnd();

  xfer += oprot->writeFieldBegin("executableType", ::apache::thrift::protocol::T_STRING, 4);
  xfer += oprot->writeString(this->executableType);
  xfer += oprot->writeFieldEnd();

  xfer += oprot->writeFieldBegin("providerName", ::apache::thrift::protocol::T_I32, 5);
  xfer += oprot->writeI32((int32_t)this->providerName);
  xfer += oprot->writeFieldEnd();

  xfer += oprot->writeFieldBegin("userAccountName", ::apache::thrift::protocol::T_STRING, 6);
  xfer += oprot->writeString(this->userAccountName);
  xfer += oprot->writeFieldEnd();

  xfer += oprot->writeFieldStop();
  xfer += oprot->writeStructEnd();
  return xfer;
}

void swap(CloudJobSubmission &a, CloudJobSubmission &b) {
  using ::std::swap;
  swap(a.jobSubmissionInterfaceId, b.jobSubmissionInterfaceId);
  swap(a.securityProtocol, b.securityProtocol);
  swap(a.nodeId, b.nodeId);
  swap(a.executableType, b.executableType);
  swap(a.providerName, b.providerName);
  swap(a.userAccountName, b.userAccountName);
}

CloudJobSubmission::CloudJobSubmission(const CloudJobSubmission& other50) {
  jobSubmissionInterfaceId = other50.jobSubmissionInterfaceId;
  securityProtocol = other50.securityProtocol;
  nodeId = other50.nodeId;
  executableType = other50.executableType;
  providerName = other50.providerName;
  userAccountName = other50.userAccountName;
}
CloudJobSubmission& CloudJobSubmission::operator=(const CloudJobSubmission& other51) {
  jobSubmissionInterfaceId = other51.jobSubmissionInterfaceId;
  securityProtocol = other51.securityProtocol;
  nodeId = other51.nodeId;
  executableType = other51.executableType;
  providerName = other51.providerName;
  userAccountName = other51.userAccountName;
  return *this;
}
void CloudJobSubmission::printTo(std::ostream& out) const {
  using ::apache::thrift::to_string;
  out << "CloudJobSubmission(";
  out << "jobSubmissionInterfaceId=" << to_string(jobSubmissionInterfaceId);
  out << ", " << "securityProtocol=" << to_string(securityProtocol);
  out << ", " << "nodeId=" << to_string(nodeId);
  out << ", " << "executableType=" << to_string(executableType);
  out << ", " << "providerName=" << to_string(providerName);
  out << ", " << "userAccountName=" << to_string(userAccountName);
  out << ")";
}


JobSubmissionInterface::~JobSubmissionInterface() throw() {
}


void JobSubmissionInterface::__set_jobSubmissionInterfaceId(const std::string& val) {
  this->jobSubmissionInterfaceId = val;
}

void JobSubmissionInterface::__set_jobSubmissionProtocol(const JobSubmissionProtocol::type val) {
  this->jobSubmissionProtocol = val;
}

void JobSubmissionInterface::__set_priorityOrder(const int32_t val) {
  this->priorityOrder = val;
}

uint32_t JobSubmissionInterface::read(::apache::thrift::protocol::TProtocol* iprot) {

  apache::thrift::protocol::TInputRecursionTracker tracker(*iprot);
  uint32_t xfer = 0;
  std::string fname;
  ::apache::thrift::protocol::TType ftype;
  int16_t fid;

  xfer += iprot->readStructBegin(fname);

  using ::apache::thrift::protocol::TProtocolException;

  bool isset_jobSubmissionInterfaceId = false;
  bool isset_jobSubmissionProtocol = false;
  bool isset_priorityOrder = false;

  while (true)
  {
    xfer += iprot->readFieldBegin(fname, ftype, fid);
    if (ftype == ::apache::thrift::protocol::T_STOP) {
      break;
    }
    switch (fid)
    {
      case 1:
        if (ftype == ::apache::thrift::protocol::T_STRING) {
          xfer += iprot->readString(this->jobSubmissionInterfaceId);
          isset_jobSubmissionInterfaceId = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 2:
        if (ftype == ::apache::thrift::protocol::T_I32) {
          int32_t ecast52;
          xfer += iprot->readI32(ecast52);
          this->jobSubmissionProtocol = (JobSubmissionProtocol::type)ecast52;
          isset_jobSubmissionProtocol = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 3:
        if (ftype == ::apache::thrift::protocol::T_I32) {
          xfer += iprot->readI32(this->priorityOrder);
          isset_priorityOrder = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      default:
        xfer += iprot->skip(ftype);
        break;
    }
    xfer += iprot->readFieldEnd();
  }

  xfer += iprot->readStructEnd();

  if (!isset_jobSubmissionInterfaceId)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  if (!isset_jobSubmissionProtocol)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  if (!isset_priorityOrder)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  return xfer;
}

uint32_t JobSubmissionInterface::write(::apache::thrift::protocol::TProtocol* oprot) const {
  uint32_t xfer = 0;
  apache::thrift::protocol::TOutputRecursionTracker tracker(*oprot);
  xfer += oprot->writeStructBegin("JobSubmissionInterface");

  xfer += oprot->writeFieldBegin("jobSubmissionInterfaceId", ::apache::thrift::protocol::T_STRING, 1);
  xfer += oprot->writeString(this->jobSubmissionInterfaceId);
  xfer += oprot->writeFieldEnd();

  xfer += oprot->writeFieldBegin("jobSubmissionProtocol", ::apache::thrift::protocol::T_I32, 2);
  xfer += oprot->writeI32((int32_t)this->jobSubmissionProtocol);
  xfer += oprot->writeFieldEnd();

  xfer += oprot->writeFieldBegin("priorityOrder", ::apache::thrift::protocol::T_I32, 3);
  xfer += oprot->writeI32(this->priorityOrder);
  xfer += oprot->writeFieldEnd();

  xfer += oprot->writeFieldStop();
  xfer += oprot->writeStructEnd();
  return xfer;
}

void swap(JobSubmissionInterface &a, JobSubmissionInterface &b) {
  using ::std::swap;
  swap(a.jobSubmissionInterfaceId, b.jobSubmissionInterfaceId);
  swap(a.jobSubmissionProtocol, b.jobSubmissionProtocol);
  swap(a.priorityOrder, b.priorityOrder);
}

JobSubmissionInterface::JobSubmissionInterface(const JobSubmissionInterface& other53) {
  jobSubmissionInterfaceId = other53.jobSubmissionInterfaceId;
  jobSubmissionProtocol = other53.jobSubmissionProtocol;
  priorityOrder = other53.priorityOrder;
}
JobSubmissionInterface& JobSubmissionInterface::operator=(const JobSubmissionInterface& other54) {
  jobSubmissionInterfaceId = other54.jobSubmissionInterfaceId;
  jobSubmissionProtocol = other54.jobSubmissionProtocol;
  priorityOrder = other54.priorityOrder;
  return *this;
}
void JobSubmissionInterface::printTo(std::ostream& out) const {
  using ::apache::thrift::to_string;
  out << "JobSubmissionInterface(";
  out << "jobSubmissionInterfaceId=" << to_string(jobSubmissionInterfaceId);
  out << ", " << "jobSubmissionProtocol=" << to_string(jobSubmissionProtocol);
  out << ", " << "priorityOrder=" << to_string(priorityOrder);
  out << ")";
}


ComputeResourceDescription::~ComputeResourceDescription() throw() {
}


void ComputeResourceDescription::__set_computeResourceId(const std::string& val) {
  this->computeResourceId = val;
}

void ComputeResourceDescription::__set_hostName(const std::string& val) {
  this->hostName = val;
}

void ComputeResourceDescription::__set_hostAliases(const std::vector<std::string> & val) {
  this->hostAliases = val;
__isset.hostAliases = true;
}

void ComputeResourceDescription::__set_ipAddresses(const std::vector<std::string> & val) {
  this->ipAddresses = val;
__isset.ipAddresses = true;
}

void ComputeResourceDescription::__set_resourceDescription(const std::string& val) {
  this->resourceDescription = val;
__isset.resourceDescription = true;
}

void ComputeResourceDescription::__set_enabled(const bool val) {
  this->enabled = val;
__isset.enabled = true;
}

void ComputeResourceDescription::__set_batchQueues(const std::vector<BatchQueue> & val) {
  this->batchQueues = val;
__isset.batchQueues = true;
}

void ComputeResourceDescription::__set_fileSystems(const std::map<FileSystems::type, std::string> & val) {
  this->fileSystems = val;
__isset.fileSystems = true;
}

void ComputeResourceDescription::__set_jobSubmissionInterfaces(const std::vector<JobSubmissionInterface> & val) {
  this->jobSubmissionInterfaces = val;
__isset.jobSubmissionInterfaces = true;
}

void ComputeResourceDescription::__set_dataMovementInterfaces(const std::vector< ::apache::airavata::model::data::movement::DataMovementInterface> & val) {
  this->dataMovementInterfaces = val;
__isset.dataMovementInterfaces = true;
}

void ComputeResourceDescription::__set_maxMemoryPerNode(const int32_t val) {
  this->maxMemoryPerNode = val;
__isset.maxMemoryPerNode = true;
}

void ComputeResourceDescription::__set_gatewayUsageReporting(const bool val) {
  this->gatewayUsageReporting = val;
__isset.gatewayUsageReporting = true;
}

void ComputeResourceDescription::__set_gatewayUsageModuleLoadCommand(const std::string& val) {
  this->gatewayUsageModuleLoadCommand = val;
__isset.gatewayUsageModuleLoadCommand = true;
}

void ComputeResourceDescription::__set_gatewayUsageExecutable(const std::string& val) {
  this->gatewayUsageExecutable = val;
__isset.gatewayUsageExecutable = true;
}

void ComputeResourceDescription::__set_cpusPerNode(const int32_t val) {
  this->cpusPerNode = val;
__isset.cpusPerNode = true;
}

void ComputeResourceDescription::__set_defaultNodeCount(const int32_t val) {
  this->defaultNodeCount = val;
__isset.defaultNodeCount = true;
}

void ComputeResourceDescription::__set_defaultCPUCount(const int32_t val) {
  this->defaultCPUCount = val;
__isset.defaultCPUCount = true;
}

void ComputeResourceDescription::__set_defaultWalltime(const int32_t val) {
  this->defaultWalltime = val;
__isset.defaultWalltime = true;
}

uint32_t ComputeResourceDescription::read(::apache::thrift::protocol::TProtocol* iprot) {

  apache::thrift::protocol::TInputRecursionTracker tracker(*iprot);
  uint32_t xfer = 0;
  std::string fname;
  ::apache::thrift::protocol::TType ftype;
  int16_t fid;

  xfer += iprot->readStructBegin(fname);

  using ::apache::thrift::protocol::TProtocolException;

  bool isset_computeResourceId = false;
  bool isset_hostName = false;

  while (true)
  {
    xfer += iprot->readFieldBegin(fname, ftype, fid);
    if (ftype == ::apache::thrift::protocol::T_STOP) {
      break;
    }
    switch (fid)
    {
      case 1:
        if (ftype == ::apache::thrift::protocol::T_STRING) {
          xfer += iprot->readString(this->computeResourceId);
          isset_computeResourceId = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 2:
        if (ftype == ::apache::thrift::protocol::T_STRING) {
          xfer += iprot->readString(this->hostName);
          isset_hostName = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 3:
        if (ftype == ::apache::thrift::protocol::T_LIST) {
          {
            this->hostAliases.clear();
            uint32_t _size55;
            ::apache::thrift::protocol::TType _etype58;
            xfer += iprot->readListBegin(_etype58, _size55);
            this->hostAliases.resize(_size55);
            uint32_t _i59;
            for (_i59 = 0; _i59 < _size55; ++_i59)
            {
              xfer += iprot->readString(this->hostAliases[_i59]);
            }
            xfer += iprot->readListEnd();
          }
          this->__isset.hostAliases = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 4:
        if (ftype == ::apache::thrift::protocol::T_LIST) {
          {
            this->ipAddresses.clear();
            uint32_t _size60;
            ::apache::thrift::protocol::TType _etype63;
            xfer += iprot->readListBegin(_etype63, _size60);
            this->ipAddresses.resize(_size60);
            uint32_t _i64;
            for (_i64 = 0; _i64 < _size60; ++_i64)
            {
              xfer += iprot->readString(this->ipAddresses[_i64]);
            }
            xfer += iprot->readListEnd();
          }
          this->__isset.ipAddresses = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 5:
        if (ftype == ::apache::thrift::protocol::T_STRING) {
          xfer += iprot->readString(this->resourceDescription);
          this->__isset.resourceDescription = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 6:
        if (ftype == ::apache::thrift::protocol::T_BOOL) {
          xfer += iprot->readBool(this->enabled);
          this->__isset.enabled = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 7:
        if (ftype == ::apache::thrift::protocol::T_LIST) {
          {
            this->batchQueues.clear();
            uint32_t _size65;
            ::apache::thrift::protocol::TType _etype68;
            xfer += iprot->readListBegin(_etype68, _size65);
            this->batchQueues.resize(_size65);
            uint32_t _i69;
            for (_i69 = 0; _i69 < _size65; ++_i69)
            {
              xfer += this->batchQueues[_i69].read(iprot);
            }
            xfer += iprot->readListEnd();
          }
          this->__isset.batchQueues = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 8:
        if (ftype == ::apache::thrift::protocol::T_MAP) {
          {
            this->fileSystems.clear();
            uint32_t _size70;
            ::apache::thrift::protocol::TType _ktype71;
            ::apache::thrift::protocol::TType _vtype72;
            xfer += iprot->readMapBegin(_ktype71, _vtype72, _size70);
            uint32_t _i74;
            for (_i74 = 0; _i74 < _size70; ++_i74)
            {
              FileSystems::type _key75;
              int32_t ecast77;
              xfer += iprot->readI32(ecast77);
              _key75 = (FileSystems::type)ecast77;
              std::string& _val76 = this->fileSystems[_key75];
              xfer += iprot->readString(_val76);
            }
            xfer += iprot->readMapEnd();
          }
          this->__isset.fileSystems = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 9:
        if (ftype == ::apache::thrift::protocol::T_LIST) {
          {
            this->jobSubmissionInterfaces.clear();
            uint32_t _size78;
            ::apache::thrift::protocol::TType _etype81;
            xfer += iprot->readListBegin(_etype81, _size78);
            this->jobSubmissionInterfaces.resize(_size78);
            uint32_t _i82;
            for (_i82 = 0; _i82 < _size78; ++_i82)
            {
              xfer += this->jobSubmissionInterfaces[_i82].read(iprot);
            }
            xfer += iprot->readListEnd();
          }
          this->__isset.jobSubmissionInterfaces = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 10:
        if (ftype == ::apache::thrift::protocol::T_LIST) {
          {
            this->dataMovementInterfaces.clear();
            uint32_t _size83;
            ::apache::thrift::protocol::TType _etype86;
            xfer += iprot->readListBegin(_etype86, _size83);
            this->dataMovementInterfaces.resize(_size83);
            uint32_t _i87;
            for (_i87 = 0; _i87 < _size83; ++_i87)
            {
              xfer += this->dataMovementInterfaces[_i87].read(iprot);
            }
            xfer += iprot->readListEnd();
          }
          this->__isset.dataMovementInterfaces = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 11:
        if (ftype == ::apache::thrift::protocol::T_I32) {
          xfer += iprot->readI32(this->maxMemoryPerNode);
          this->__isset.maxMemoryPerNode = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 12:
        if (ftype == ::apache::thrift::protocol::T_BOOL) {
          xfer += iprot->readBool(this->gatewayUsageReporting);
          this->__isset.gatewayUsageReporting = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 13:
        if (ftype == ::apache::thrift::protocol::T_STRING) {
          xfer += iprot->readString(this->gatewayUsageModuleLoadCommand);
          this->__isset.gatewayUsageModuleLoadCommand = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 14:
        if (ftype == ::apache::thrift::protocol::T_STRING) {
          xfer += iprot->readString(this->gatewayUsageExecutable);
          this->__isset.gatewayUsageExecutable = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 15:
        if (ftype == ::apache::thrift::protocol::T_I32) {
          xfer += iprot->readI32(this->cpusPerNode);
          this->__isset.cpusPerNode = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 16:
        if (ftype == ::apache::thrift::protocol::T_I32) {
          xfer += iprot->readI32(this->defaultNodeCount);
          this->__isset.defaultNodeCount = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 17:
        if (ftype == ::apache::thrift::protocol::T_I32) {
          xfer += iprot->readI32(this->defaultCPUCount);
          this->__isset.defaultCPUCount = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      case 18:
        if (ftype == ::apache::thrift::protocol::T_I32) {
          xfer += iprot->readI32(this->defaultWalltime);
          this->__isset.defaultWalltime = true;
        } else {
          xfer += iprot->skip(ftype);
        }
        break;
      default:
        xfer += iprot->skip(ftype);
        break;
    }
    xfer += iprot->readFieldEnd();
  }

  xfer += iprot->readStructEnd();

  if (!isset_computeResourceId)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  if (!isset_hostName)
    throw TProtocolException(TProtocolException::INVALID_DATA);
  return xfer;
}

uint32_t ComputeResourceDescription::write(::apache::thrift::protocol::TProtocol* oprot) const {
  uint32_t xfer = 0;
  apache::thrift::protocol::TOutputRecursionTracker tracker(*oprot);
  xfer += oprot->writeStructBegin("ComputeResourceDescription");

  xfer += oprot->writeFieldBegin("computeResourceId", ::apache::thrift::protocol::T_STRING, 1);
  xfer += oprot->writeString(this->computeResourceId);
  xfer += oprot->writeFieldEnd();

  xfer += oprot->writeFieldBegin("hostName", ::apache::thrift::protocol::T_STRING, 2);
  xfer += oprot->writeString(this->hostName);
  xfer += oprot->writeFieldEnd();

  if (this->__isset.hostAliases) {
    xfer += oprot->writeFieldBegin("hostAliases", ::apache::thrift::protocol::T_LIST, 3);
    {
      xfer += oprot->writeListBegin(::apache::thrift::protocol::T_STRING, static_cast<uint32_t>(this->hostAliases.size()));
      std::vector<std::string> ::const_iterator _iter88;
      for (_iter88 = this->hostAliases.begin(); _iter88 != this->hostAliases.end(); ++_iter88)
      {
        xfer += oprot->writeString((*_iter88));
      }
      xfer += oprot->writeListEnd();
    }
    xfer += oprot->writeFieldEnd();
  }
  if (this->__isset.ipAddresses) {
    xfer += oprot->writeFieldBegin("ipAddresses", ::apache::thrift::protocol::T_LIST, 4);
    {
      xfer += oprot->writeListBegin(::apache::thrift::protocol::T_STRING, static_cast<uint32_t>(this->ipAddresses.size()));
      std::vector<std::string> ::const_iterator _iter89;
      for (_iter89 = this->ipAddresses.begin(); _iter89 != this->ipAddresses.end(); ++_iter89)
      {
        xfer += oprot->writeString((*_iter89));
      }
      xfer += oprot->writeListEnd();
    }
    xfer += oprot->writeFieldEnd();
  }
  if (this->__isset.resourceDescription) {
    xfer += oprot->writeFieldBegin("resourceDescription", ::apache::thrift::protocol::T_STRING, 5);
    xfer += oprot->writeString(this->resourceDescription);
    xfer += oprot->writeFieldEnd();
  }
  if (this->__isset.enabled) {
    xfer += oprot->writeFieldBegin("enabled", ::apache::thrift::protocol::T_BOOL, 6);
    xfer += oprot->writeBool(this->enabled);
    xfer += oprot->writeFieldEnd();
  }
  if (this->__isset.batchQueues) {
    xfer += oprot->writeFieldBegin("batchQueues", ::apache::thrift::protocol::T_LIST, 7);
    {
      xfer += oprot->writeListBegin(::apache::thrift::protocol::T_STRUCT, static_cast<uint32_t>(this->batchQueues.size()));
      std::vector<BatchQueue> ::const_iterator _iter90;
      for (_iter90 = this->batchQueues.begin(); _iter90 != this->batchQueues.end(); ++_iter90)
      {
        xfer += (*_iter90).write(oprot);
      }
      xfer += oprot->writeListEnd();
    }
    xfer += oprot->writeFieldEnd();
  }
  if (this->__isset.fileSystems) {
    xfer += oprot->writeFieldBegin("fileSystems", ::apache::thrift::protocol::T_MAP, 8);
    {
      xfer += oprot->writeMapBegin(::apache::thrift::protocol::T_I32, ::apache::thrift::protocol::T_STRING, static_cast<uint32_t>(this->fileSystems.size()));
      std::map<FileSystems::type, std::string> ::const_iterator _iter91;
      for (_iter91 = this->fileSystems.begin(); _iter91 != this->fileSystems.end(); ++_iter91)
      {
        xfer += oprot->writeI32((int32_t)_iter91->first);
        xfer += oprot->writeString(_iter91->second);
      }
      xfer += oprot->writeMapEnd();
    }
    xfer += oprot->writeFieldEnd();
  }
  if (this->__isset.jobSubmissionInterfaces) {
    xfer += oprot->writeFieldBegin("jobSubmissionInterfaces", ::apache::thrift::protocol::T_LIST, 9);
    {
      xfer += oprot->writeListBegin(::apache::thrift::protocol::T_STRUCT, static_cast<uint32_t>(this->jobSubmissionInterfaces.size()));
      std::vector<JobSubmissionInterface> ::const_iterator _iter92;
      for (_iter92 = this->jobSubmissionInterfaces.begin(); _iter92 != this->jobSubmissionInterfaces.end(); ++_iter92)
      {
        xfer += (*_iter92).write(oprot);
      }
      xfer += oprot->writeListEnd();
    }
    xfer += oprot->writeFieldEnd();
  }
  if (this->__isset.dataMovementInterfaces) {
    xfer += oprot->writeFieldBegin("dataMovementInterfaces", ::apache::thrift::protocol::T_LIST, 10);
    {
      xfer += oprot->writeListBegin(::apache::thrift::protocol::T_STRUCT, static_cast<uint32_t>(this->dataMovementInterfaces.size()));
      std::vector< ::apache::airavata::model::data::movement::DataMovementInterface> ::const_iterator _iter93;
      for (_iter93 = this->dataMovementInterfaces.begin(); _iter93 != this->dataMovementInterfaces.end(); ++_iter93)
      {
        xfer += (*_iter93).write(oprot);
      }
      xfer += oprot->writeListEnd();
    }
    xfer += oprot->writeFieldEnd();
  }
  if (this->__isset.maxMemoryPerNode) {
    xfer += oprot->writeFieldBegin("maxMemoryPerNode", ::apache::thrift::protocol::T_I32, 11);
    xfer += oprot->writeI32(this->maxMemoryPerNode);
    xfer += oprot->writeFieldEnd();
  }
  if (this->__isset.gatewayUsageReporting) {
    xfer += oprot->writeFieldBegin("gatewayUsageReporting", ::apache::thrift::protocol::T_BOOL, 12);
    xfer += oprot->writeBool(this->gatewayUsageReporting);
    xfer += oprot->writeFieldEnd();
  }
  if (this->__isset.gatewayUsageModuleLoadCommand) {
    xfer += oprot->writeFieldBegin("gatewayUsageModuleLoadCommand", ::apache::thrift::protocol::T_STRING, 13);
    xfer += oprot->writeString(this->gatewayUsageModuleLoadCommand);
    xfer += oprot->writeFieldEnd();
  }
  if (this->__isset.gatewayUsageExecutable) {
    xfer += oprot->writeFieldBegin("gatewayUsageExecutable", ::apache::thrift::protocol::T_STRING, 14);
    xfer += oprot->writeString(this->gatewayUsageExecutable);
    xfer += oprot->writeFieldEnd();
  }
  if (this->__isset.cpusPerNode) {
    xfer += oprot->writeFieldBegin("cpusPerNode", ::apache::thrift::protocol::T_I32, 15);
    xfer += oprot->writeI32(this->cpusPerNode);
    xfer += oprot->writeFieldEnd();
  }
  if (this->__isset.defaultNodeCount) {
    xfer += oprot->writeFieldBegin("defaultNodeCount", ::apache::thrift::protocol::T_I32, 16);
    xfer += oprot->writeI32(this->defaultNodeCount);
    xfer += oprot->writeFieldEnd();
  }
  if (this->__isset.defaultCPUCount) {
    xfer += oprot->writeFieldBegin("defaultCPUCount", ::apache::thrift::protocol::T_I32, 17);
    xfer += oprot->writeI32(this->defaultCPUCount);
    xfer += oprot->writeFieldEnd();
  }
  if (this->__isset.defaultWalltime) {
    xfer += oprot->writeFieldBegin("defaultWalltime", ::apache::thrift::protocol::T_I32, 18);
    xfer += oprot->writeI32(this->defaultWalltime);
    xfer += oprot->writeFieldEnd();
  }
  xfer += oprot->writeFieldStop();
  xfer += oprot->writeStructEnd();
  return xfer;
}

void swap(ComputeResourceDescription &a, ComputeResourceDescription &b) {
  using ::std::swap;
  swap(a.computeResourceId, b.computeResourceId);
  swap(a.hostName, b.hostName);
  swap(a.hostAliases, b.hostAliases);
  swap(a.ipAddresses, b.ipAddresses);
  swap(a.resourceDescription, b.resourceDescription);
  swap(a.enabled, b.enabled);
  swap(a.batchQueues, b.batchQueues);
  swap(a.fileSystems, b.fileSystems);
  swap(a.jobSubmissionInterfaces, b.jobSubmissionInterfaces);
  swap(a.dataMovementInterfaces, b.dataMovementInterfaces);
  swap(a.maxMemoryPerNode, b.maxMemoryPerNode);
  swap(a.gatewayUsageReporting, b.gatewayUsageReporting);
  swap(a.gatewayUsageModuleLoadCommand, b.gatewayUsageModuleLoadCommand);
  swap(a.gatewayUsageExecutable, b.gatewayUsageExecutable);
  swap(a.cpusPerNode, b.cpusPerNode);
  swap(a.defaultNodeCount, b.defaultNodeCount);
  swap(a.defaultCPUCount, b.defaultCPUCount);
  swap(a.defaultWalltime, b.defaultWalltime);
  swap(a.__isset, b.__isset);
}

ComputeResourceDescription::ComputeResourceDescription(const ComputeResourceDescription& other94) {
  computeResourceId = other94.computeResourceId;
  hostName = other94.hostName;
  hostAliases = other94.hostAliases;
  ipAddresses = other94.ipAddresses;
  resourceDescription = other94.resourceDescription;
  enabled = other94.enabled;
  batchQueues = other94.batchQueues;
  fileSystems = other94.fileSystems;
  jobSubmissionInterfaces = other94.jobSubmissionInterfaces;
  dataMovementInterfaces = other94.dataMovementInterfaces;
  maxMemoryPerNode = other94.maxMemoryPerNode;
  gatewayUsageReporting = other94.gatewayUsageReporting;
  gatewayUsageModuleLoadCommand = other94.gatewayUsageModuleLoadCommand;
  gatewayUsageExecutable = other94.gatewayUsageExecutable;
  cpusPerNode = other94.cpusPerNode;
  defaultNodeCount = other94.defaultNodeCount;
  defaultCPUCount = other94.defaultCPUCount;
  defaultWalltime = other94.defaultWalltime;
  __isset = other94.__isset;
}
ComputeResourceDescription& ComputeResourceDescription::operator=(const ComputeResourceDescription& other95) {
  computeResourceId = other95.computeResourceId;
  hostName = other95.hostName;
  hostAliases = other95.hostAliases;
  ipAddresses = other95.ipAddresses;
  resourceDescription = other95.resourceDescription;
  enabled = other95.enabled;
  batchQueues = other95.batchQueues;
  fileSystems = other95.fileSystems;
  jobSubmissionInterfaces = other95.jobSubmissionInterfaces;
  dataMovementInterfaces = other95.dataMovementInterfaces;
  maxMemoryPerNode = other95.maxMemoryPerNode;
  gatewayUsageReporting = other95.gatewayUsageReporting;
  gatewayUsageModuleLoadCommand = other95.gatewayUsageModuleLoadCommand;
  gatewayUsageExecutable = other95.gatewayUsageExecutable;
  cpusPerNode = other95.cpusPerNode;
  defaultNodeCount = other95.defaultNodeCount;
  defaultCPUCount = other95.defaultCPUCount;
  defaultWalltime = other95.defaultWalltime;
  __isset = other95.__isset;
  return *this;
}
void ComputeResourceDescription::printTo(std::ostream& out) const {
  using ::apache::thrift::to_string;
  out << "ComputeResourceDescription(";
  out << "computeResourceId=" << to_string(computeResourceId);
  out << ", " << "hostName=" << to_string(hostName);
  out << ", " << "hostAliases="; (__isset.hostAliases ? (out << to_string(hostAliases)) : (out << "<null>"));
  out << ", " << "ipAddresses="; (__isset.ipAddresses ? (out << to_string(ipAddresses)) : (out << "<null>"));
  out << ", " << "resourceDescription="; (__isset.resourceDescription ? (out << to_string(resourceDescription)) : (out << "<null>"));
  out << ", " << "enabled="; (__isset.enabled ? (out << to_string(enabled)) : (out << "<null>"));
  out << ", " << "batchQueues="; (__isset.batchQueues ? (out << to_string(batchQueues)) : (out << "<null>"));
  out << ", " << "fileSystems="; (__isset.fileSystems ? (out << to_string(fileSystems)) : (out << "<null>"));
  out << ", " << "jobSubmissionInterfaces="; (__isset.jobSubmissionInterfaces ? (out << to_string(jobSubmissionInterfaces)) : (out << "<null>"));
  out << ", " << "dataMovementInterfaces="; (__isset.dataMovementInterfaces ? (out << to_string(dataMovementInterfaces)) : (out << "<null>"));
  out << ", " << "maxMemoryPerNode="; (__isset.maxMemoryPerNode ? (out << to_string(maxMemoryPerNode)) : (out << "<null>"));
  out << ", " << "gatewayUsageReporting="; (__isset.gatewayUsageReporting ? (out << to_string(gatewayUsageReporting)) : (out << "<null>"));
  out << ", " << "gatewayUsageModuleLoadCommand="; (__isset.gatewayUsageModuleLoadCommand ? (out << to_string(gatewayUsageModuleLoadCommand)) : (out << "<null>"));
  out << ", " << "gatewayUsageExecutable="; (__isset.gatewayUsageExecutable ? (out << to_string(gatewayUsageExecutable)) : (out << "<null>"));
  out << ", " << "cpusPerNode="; (__isset.cpusPerNode ? (out << to_string(cpusPerNode)) : (out << "<null>"));
  out << ", " << "defaultNodeCount="; (__isset.defaultNodeCount ? (out << to_string(defaultNodeCount)) : (out << "<null>"));
  out << ", " << "defaultCPUCount="; (__isset.defaultCPUCount ? (out << to_string(defaultCPUCount)) : (out << "<null>"));
  out << ", " << "defaultWalltime="; (__isset.defaultWalltime ? (out << to_string(defaultWalltime)) : (out << "<null>"));
  out << ")";
}

}}}}} // namespace
