/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.ws.jetty9;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.transport.stomp.StompFrame;
import org.apache.activemq.transport.ws.AbstractStompSocket;
import org.apache.activemq.util.IOExceptionSupport;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.WebSocketListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StompSocket
extends AbstractStompSocket
implements WebSocketListener {
    private static final Logger LOG = LoggerFactory.getLogger(StompSocket.class);
    private final int ORDERLY_CLOSE_TIMEOUT = 10;
    private Session session;

    public StompSocket(String remoteAddress) {
        super(remoteAddress);
    }

    @Override
    public void sendToStomp(StompFrame command) throws IOException {
        try {
            this.session.getRemote().sendStringByFuture(this.getWireFormat().marshalToString(command)).get(StompSocket.getDefaultSendTimeOut(), TimeUnit.SECONDS);
        }
        catch (Exception e) {
            throw IOExceptionSupport.create(e);
        }
    }

    @Override
    public void handleStopped() throws IOException {
        if (this.session != null && this.session.isOpen()) {
            this.session.close();
        }
    }

    public void onWebSocketBinary(byte[] arg0, int arg1, int arg2) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onWebSocketClose(int arg0, String arg1) {
        try {
            if (this.protocolLock.tryLock() || this.protocolLock.tryLock(10L, TimeUnit.SECONDS)) {
                LOG.debug("Stomp WebSocket closed: code[{}] message[{}]", (Object)arg0, (Object)arg1);
                this.protocolConverter.onStompCommand(new StompFrame("DISCONNECT"));
            }
        }
        catch (Exception e) {
            LOG.debug("Failed to close STOMP WebSocket cleanly", e);
        }
        finally {
            if (this.protocolLock.isHeldByCurrentThread()) {
                this.protocolLock.unlock();
            }
        }
    }

    public void onWebSocketConnect(Session session) {
        this.session = session;
    }

    public void onWebSocketError(Throwable arg0) {
    }

    public void onWebSocketText(String data) {
        this.processStompFrame(data);
    }

    private static int getDefaultSendTimeOut() {
        return Integer.getInteger("org.apache.activemq.transport.ws.StompSocket.sendTimeout", 30);
    }
}

