/*
   This file is part of TALER
   Copyright (C) 2025 Taler Systems SA

   TALER is free software; you can redistribute it and/or modify it under the
   terms of the GNU General Public License as published by the Free Software
   Foundation; either version 3, or (at your option) any later version.

   TALER is distributed in the hope that it will be useful, but WITHOUT ANY
   WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
   A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

   You should have received a copy of the GNU General Public License along with
   TALER; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
 */
/**
 * @file donaudb/pg_lookup_donation_unit_amount.h
 * @brief Getting the donation unit amount
 * @author Bohdan Potuzhnyi
 */
#ifndef PG_LOOKUP_DONATION_UNIT_H
#define PG_LOOKUP_DONATION_UNIT_H

#include <taler/taler_util.h>
#include <taler/taler_json_lib.h>
#include "donaudb_plugin.h"
/**
 * Look up the face value of one donation-unit entry.
 *
 * @param cls plugin’s `struct PostgresClosure *`
 * @param h_donation_unit_pub hash of the donation-unit public key (PRIMARY KEY)
 * @param[out] value amount stored in the table
 * @return same semantics as every other DH_PG_* lookup:
 *         #GNUNET_DB_STATUS_SUCCESS_ONE_RESULT (==1) on success,
 *         0 if not found, negative on hard error.
 */
enum GNUNET_DB_QueryStatus
DH_PG_lookup_donation_unit_amount (
  void *cls,
  const struct DONAU_DonationUnitHashP *h_donation_unit_pub,
  struct TALER_Amount *value);

#endif /* PG_LOOKUP_DONATION_UNIT_H */