/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.logging;

import java.util.HashMap;
import java.util.Map;

public class PaxContext {
    static final int HT_SIZE = 7;
    final ThreadLocal<Map<String, Object>> tlm = Boolean.parseBoolean(System.getProperty("org.ops4j.pax.logging.threadContextMapInheritable", "true")) ? new ThreadLocalMap() : new ThreadLocal();

    public void putAll(Map<String, Object> context) {
        Map<String, Object> ht = this.tlm.get();
        if (ht == null) {
            ht = new HashMap<String, Object>(7);
            this.tlm.set(ht);
        }
        ht.putAll(context);
    }

    public void put(String key, Object o) {
        Map<String, Object> ht = this.tlm.get();
        if (ht == null) {
            ht = new HashMap<String, Object>(7);
            this.tlm.set(ht);
        }
        ht.put(key, o);
    }

    public Object get(String key) {
        Map<String, Object> ht = this.tlm.get();
        if (ht != null && key != null) {
            return ht.get(key);
        }
        return null;
    }

    public void remove(String key) {
        Map<String, Object> ht = this.tlm.get();
        if (ht != null) {
            ht.remove(key);
        }
    }

    public Map<String, Object> getContext() {
        return this.tlm.get();
    }

    public Map<String, Object> getCopyOfContextMap() {
        Map<String, Object> ht = this.tlm.get();
        if (ht != null) {
            return new HashMap<String, Object>(ht);
        }
        return null;
    }

    public void clear() {
        Map<String, Object> ht = this.tlm.get();
        if (ht != null) {
            ht.clear();
        }
    }

    public void setContextMap(Map<String, Object> contextMap) {
        Map<String, Object> ht = this.tlm.get();
        if (ht == null) {
            ht = new HashMap<String, Object>(7);
            this.tlm.set(ht);
        } else {
            ht.clear();
        }
        ht.putAll(contextMap);
    }

    static class ThreadLocalMap
    extends InheritableThreadLocal<Map<String, Object>> {
        ThreadLocalMap() {
        }

        @Override
        protected Map<String, Object> childValue(Map<String, Object> parentValue) {
            if (parentValue != null) {
                return new HashMap<String, Object>(parentValue);
            }
            return null;
        }
    }
}

