/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.parsing;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.persistence.exceptions.JPQLException;
import org.eclipse.persistence.internal.jpa.parsing.AliasableNode;
import org.eclipse.persistence.internal.jpa.parsing.AttributeNode;
import org.eclipse.persistence.internal.jpa.parsing.GenerationContext;
import org.eclipse.persistence.internal.jpa.parsing.Node;
import org.eclipse.persistence.internal.jpa.parsing.ParseTreeContext;
import org.eclipse.persistence.internal.jpa.parsing.SelectGenerationContext;
import org.eclipse.persistence.internal.jpa.parsing.TypeHelper;
import org.eclipse.persistence.queries.ObjectLevelReadQuery;
import org.eclipse.persistence.queries.ReportQuery;

public class ConstructorNode
extends Node
implements AliasableNode {
    private String className = null;
    public List<Node> constructorItems = new ArrayList<Node>();

    public ConstructorNode(String className) {
        this.className = className;
    }

    @Override
    public void applyToQuery(ObjectLevelReadQuery theQuery, GenerationContext context) {
        if (theQuery instanceof ReportQuery) {
            SelectGenerationContext selectContext = (SelectGenerationContext)context;
            ReportQuery reportQuery = (ReportQuery)theQuery;
            reportQuery.beginAddingConstructorArguments(this.getConstructorClass(context.getParseTreeContext()));
            for (Node node : this.constructorItems) {
                if (this.selectingRelationshipField(node, context)) {
                    selectContext.useOuterJoins();
                }
                node.applyToQuery(reportQuery, context);
                selectContext.dontUseOuterJoins();
            }
            reportQuery.endAddingToConstructorItem();
        }
    }

    @Override
    public void validate(ParseTreeContext context) {
        Object name;
        int index;
        for (Node item : this.constructorItems) {
            item.validate(context);
        }
        TypeHelper typeHelper = context.getTypeHelper();
        Object type = typeHelper.resolveTypeName(this.className);
        if (type == null && (index = ((String)(name = this.className)).lastIndexOf(46)) != -1) {
            name = ((String)name).substring(0, index) + "$" + ((String)name).substring(index + 1);
            type = typeHelper.resolveTypeName((String)name);
        }
        this.setType(type);
    }

    @Override
    public boolean isConstructorNode() {
        return true;
    }

    public void addConstructorItem(Node theNode) {
        this.constructorItems.add(theNode);
    }

    public void setConstructorItems(List<Node> items) {
        this.constructorItems = items;
    }

    public List<Node> getConstructorItems() {
        return this.constructorItems;
    }

    private Class<?> getConstructorClass(ParseTreeContext context) {
        Object type = this.getType();
        if (type == null) {
            throw JPQLException.constructorClassNotFound(context.getQueryInfo(), this.getLine(), this.getColumn(), this.className);
        }
        return (Class)type;
    }

    private boolean selectingRelationshipField(Node node, GenerationContext context) {
        if (node == null || !node.isDotNode()) {
            return false;
        }
        TypeHelper typeHelper = context.getParseTreeContext().getTypeHelper();
        Node path = node.getLeft();
        AttributeNode attribute = (AttributeNode)node.getRight();
        return typeHelper.isRelationship(path.getType(), attribute.getAttributeName());
    }

    @Override
    public String getAsString() {
        StringBuilder repr = new StringBuilder();
        repr.append("NEW ").append(this.className);
        repr.append("(");
        Iterator<Node> i = this.constructorItems.iterator();
        while (i.hasNext()) {
            Node node = i.next();
            repr.append(node.getAsString());
            if (!i.hasNext()) continue;
            repr.append(", ");
        }
        repr.append(")");
        return repr.toString();
    }

    @Override
    public boolean isAliasableNode() {
        return true;
    }
}

