/*
 * Decompiled with CFR 0.152.
 */
package org.metatype.sxc.util;

import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.metatype.sxc.util.Attribute;
import org.metatype.sxc.util.RuntimeXMLStreamException;
import org.metatype.sxc.util.XoXMLStreamReader;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class XoXMLStreamReaderImpl
implements XoXMLStreamReader {
    XMLStreamReader reader;
    String text;
    private int depth = 0;
    private static final String XSI_NS = "http://www.w3.org/2001/XMLSchema-instance";

    public XoXMLStreamReaderImpl(XMLStreamReader reader) {
        this.reader = reader;
        if (reader.getEventType() == 1) {
            ++this.depth;
        }
    }

    @Override
    public QName getXsiType() {
        String val = this.getAttributeValue(XSI_NS, "type");
        if (val != null) {
            return this.getAsQName(val);
        }
        return null;
    }

    @Override
    public QName getAsQName(String val) {
        int i = val.indexOf(":");
        if (i == -1) {
            String ns = this.getNamespaceURI("");
            if (ns == null) {
                ns = "";
            }
            return new QName(ns, val.intern());
        }
        String prefix = val.substring(0, i);
        String ns = this.getNamespaceURI(prefix);
        if (ns == null) {
            ns = "";
        }
        return new QName(ns, val.substring(i + 1).intern(), prefix);
    }

    @Override
    public boolean isXsiNil() {
        String val = this.getAttributeValue(XSI_NS, "nil");
        return val != null && (val.equals("1") || val.equals("true"));
    }

    @Override
    public int getDepth() {
        return this.depth;
    }

    @Override
    public QName getElementAsQName() throws XMLStreamException {
        String val = this.getElementAsString();
        if (val != null) {
            return this.getAsQName(val);
        }
        return null;
    }

    @Override
    public int getElementAsInt() throws XMLStreamException, NumberFormatException {
        return Integer.parseInt(this.getElementText().trim());
    }

    @Override
    public double getElementAsDouble() throws XMLStreamException {
        return Double.parseDouble(this.getElementAsString());
    }

    @Override
    public float getElementAsFloat() throws XMLStreamException {
        return Float.parseFloat(this.getElementAsString());
    }

    @Override
    public long getElementAsLong() throws XMLStreamException {
        return Long.parseLong(this.getElementAsString());
    }

    @Override
    public short getElementAsShort() throws XMLStreamException {
        return Short.parseShort(this.getElementAsString());
    }

    @Override
    public byte getElementAsByte() throws XMLStreamException {
        return Byte.parseByte(this.getElementAsString());
    }

    @Override
    public String getElementAsString() throws XMLStreamException {
        return this.getElementText().trim();
    }

    @Override
    public boolean getElementAsBoolean() throws XMLStreamException {
        String s = this.getElementAsString();
        return s.equals("true") || s.equals("1");
    }

    @Override
    public Iterable<String> getElementAsXmlList() throws XMLStreamException {
        return Arrays.asList(this.getElementAsString().split("\\s+"));
    }

    @Override
    public Element getElementAsDomElement() throws XMLStreamException {
        Document document;
        if (this.getEventType() != 1) {
            throw new IllegalStateException("Current event must be START_ELEMENT");
        }
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        factory.setValidating(false);
        try {
            document = factory.newDocumentBuilder().newDocument();
        }
        catch (ParserConfigurationException e) {
            throw new XMLStreamException(e);
        }
        LinkedList<Element> stack = new LinkedList<Element>();
        Element rootElement = null;
        int targetDepth = this.depth + 1;
        int event = this.getEventType();
        while (this.depth >= targetDepth - 1) {
            if (event == 1) {
                Element element = document.createElementNS(this.getNamespaceURI(), this.getLocalName());
                for (int i = 0; i < this.getAttributeCount(); ++i) {
                    element.setAttributeNS(this.getAttributeNamespace(i), this.getAttributeLocalName(i), this.getAttributeValue(i));
                }
                if (!stack.isEmpty()) {
                    ((Element)stack.getFirst()).appendChild(element);
                } else if (rootElement == null) {
                    rootElement = element;
                } else {
                    throw new IllegalStateException();
                }
                stack.addFirst(element);
            } else if (event == 2) {
                stack.removeFirst();
            } else if (event == 4) {
                Text textNode = document.createTextNode(this.getText());
                ((Element)stack.getFirst()).appendChild(textNode);
            } else if (event == 12) {
                CDATASection cdataSection = document.createCDATASection(this.getText());
                ((Element)stack.getFirst()).appendChild(cdataSection);
            } else if (event == 5) {
                Comment comment = document.createComment(this.getText());
                ((Element)stack.getFirst()).appendChild(comment);
            } else if (event == 6 || event == 7 || event == 8 || event == 3 || event == 3 || event == 9 || event == 11) {
                // empty if block
            }
            if (!this.hasNext()) break;
            event = this.next();
        }
        return rootElement;
    }

    @Override
    public void close() throws XMLStreamException {
        this.reader.close();
    }

    @Override
    public int getAttributeCount() {
        return this.reader.getAttributeCount();
    }

    @Override
    public String getAttributeLocalName(int arg0) {
        return this.reader.getAttributeLocalName(arg0);
    }

    @Override
    public QName getAttributeName(int arg0) {
        return this.reader.getAttributeName(arg0);
    }

    @Override
    public String getAttributeNamespace(int arg0) {
        return this.reader.getAttributeNamespace(arg0);
    }

    @Override
    public String getAttributePrefix(int arg0) {
        return this.reader.getAttributePrefix(arg0);
    }

    @Override
    public String getAttributeType(int arg0) {
        return this.reader.getAttributeType(arg0);
    }

    @Override
    public String getAttributeValue(int arg0) {
        return this.reader.getAttributeValue(arg0);
    }

    @Override
    public String getAttributeValue(String arg0, String arg1) {
        return this.reader.getAttributeValue(arg0, arg1);
    }

    @Override
    public String getCharacterEncodingScheme() {
        return this.reader.getCharacterEncodingScheme();
    }

    @Override
    public String getElementText() throws XMLStreamException {
        if (this.text == null) {
            --this.depth;
            this.text = this.reader.getElementText();
        }
        return this.text;
    }

    @Override
    public String getEncoding() {
        return this.reader.getEncoding();
    }

    @Override
    public int getEventType() {
        return this.reader.getEventType();
    }

    @Override
    public String getLocalName() {
        return this.reader.getLocalName();
    }

    @Override
    public Location getLocation() {
        return this.reader.getLocation();
    }

    @Override
    public QName getName() {
        return this.reader.getName();
    }

    @Override
    public NamespaceContext getNamespaceContext() {
        return this.reader.getNamespaceContext();
    }

    @Override
    public int getNamespaceCount() {
        return this.reader.getNamespaceCount();
    }

    @Override
    public String getNamespacePrefix(int arg0) {
        return this.reader.getNamespacePrefix(arg0);
    }

    @Override
    public String getNamespaceURI() {
        return this.reader.getNamespaceURI();
    }

    @Override
    public String getNamespaceURI(int arg0) {
        return this.reader.getNamespaceURI(arg0);
    }

    @Override
    public String getNamespaceURI(String arg0) {
        return this.reader.getNamespaceURI(arg0);
    }

    @Override
    public String getPIData() {
        return this.reader.getPIData();
    }

    @Override
    public String getPITarget() {
        return this.reader.getPITarget();
    }

    @Override
    public String getPrefix() {
        return this.reader.getPrefix();
    }

    @Override
    public Object getProperty(String arg0) throws IllegalArgumentException {
        return this.reader.getProperty(arg0);
    }

    @Override
    public String getText() {
        return this.reader.getText();
    }

    @Override
    public char[] getTextCharacters() {
        return this.reader.getTextCharacters();
    }

    @Override
    public int getTextCharacters(int arg0, char[] arg1, int arg2, int arg3) throws XMLStreamException {
        return this.reader.getTextCharacters(arg0, arg1, arg2, arg3);
    }

    @Override
    public int getTextLength() {
        return this.reader.getTextLength();
    }

    @Override
    public int getTextStart() {
        return this.reader.getTextStart();
    }

    @Override
    public String getVersion() {
        return this.reader.getVersion();
    }

    @Override
    public boolean hasName() {
        return this.reader.hasName();
    }

    @Override
    public boolean hasNext() throws XMLStreamException {
        return this.reader.hasNext();
    }

    @Override
    public boolean hasText() {
        return this.reader.hasText();
    }

    @Override
    public boolean isAttributeSpecified(int arg0) {
        return this.reader.isAttributeSpecified(arg0);
    }

    @Override
    public boolean isCharacters() {
        return this.reader.isCharacters();
    }

    @Override
    public boolean isEndElement() {
        return this.reader.isEndElement();
    }

    @Override
    public boolean isStandalone() {
        return this.reader.isStandalone();
    }

    @Override
    public boolean isStartElement() {
        return this.reader.isStartElement();
    }

    @Override
    public boolean isWhiteSpace() {
        return this.reader.isWhiteSpace();
    }

    @Override
    public int next() throws XMLStreamException {
        this.text = null;
        int next = this.reader.next();
        if (next == 1) {
            ++this.depth;
        } else if (next == 2) {
            --this.depth;
        }
        return next;
    }

    @Override
    public int nextTag() throws XMLStreamException {
        int eventType = this.reader.nextTag();
        if (eventType == 1) {
            ++this.depth;
        } else if (eventType == 2) {
            --this.depth;
        }
        return eventType;
    }

    @Override
    public int nextTagIgnoreAll() throws XMLStreamException {
        int event = this.next();
        while (event != 7 && event != 1 && event != 2 && event != 8) {
            event = this.next();
        }
        return event;
    }

    @Override
    public void require(int arg0, String arg1, String arg2) throws XMLStreamException {
        this.reader.require(arg0, arg1, arg2);
    }

    @Override
    public boolean standaloneSet() {
        return this.reader.standaloneSet();
    }

    @Override
    public Iterable<XoXMLStreamReader> getChildElements() {
        return new Iterable<XoXMLStreamReader>(){

            @Override
            public Iterator<XoXMLStreamReader> iterator() {
                return new ChildElementsIterator();
            }
        };
    }

    @Override
    public Iterable<XoXMLStreamReader> getMixedChildElements() {
        return new Iterable<XoXMLStreamReader>(){

            @Override
            public Iterator<XoXMLStreamReader> iterator() {
                return new ChildElementsIterator(true);
            }
        };
    }

    @Override
    public Iterable<Attribute> getAttributes() {
        return new Iterable<Attribute>(){

            @Override
            public Iterator<Attribute> iterator() {
                return new AttributesIterator();
            }
        };
    }

    public int hashCode() {
        return this.reader.hashCode();
    }

    public boolean equals(Object arg0) {
        return this.reader.equals(arg0);
    }

    public String toString() {
        return this.reader.toString();
    }

    public final class AttributeImpl
    implements Attribute {
        private final AttributesIterator attributesIterator;

        public AttributeImpl(AttributesIterator attributesIterator) {
            this.attributesIterator = attributesIterator;
        }

        @Override
        public QName getName() {
            return XoXMLStreamReaderImpl.this.getAttributeName(this.attributesIterator.index);
        }

        @Override
        public String getLocalName() {
            return XoXMLStreamReaderImpl.this.getAttributeLocalName(this.attributesIterator.index);
        }

        @Override
        public String getNamespace() {
            return XoXMLStreamReaderImpl.this.getAttributeNamespace(this.attributesIterator.index);
        }

        @Override
        public String getPrefix() {
            return XoXMLStreamReaderImpl.this.getAttributePrefix(this.attributesIterator.index);
        }

        @Override
        public String getType() {
            return XoXMLStreamReaderImpl.this.getAttributeType(this.attributesIterator.index);
        }

        @Override
        public String getValue() {
            return XoXMLStreamReaderImpl.this.getAttributeValue(this.attributesIterator.index);
        }

        @Override
        public boolean getBooleanValue() {
            return Boolean.parseBoolean(this.getValue());
        }

        @Override
        public byte getByteValue() {
            return Byte.parseByte(this.getValue());
        }

        @Override
        public short getShortValue() {
            return Short.parseShort(this.getValue());
        }

        @Override
        public int getIntValue() {
            return Integer.parseInt(this.getValue());
        }

        @Override
        public long getLongValue() {
            return Long.parseLong(this.getValue());
        }

        @Override
        public float getFloatValue() {
            return Float.parseFloat(this.getValue());
        }

        @Override
        public double getDoubleValue() {
            return Double.parseDouble(this.getValue());
        }

        @Override
        public Iterable<String> getXmlListValue() {
            String value = this.getValue().trim();
            List<String> list = Arrays.asList(value.split("\\s+"));
            return list;
        }

        @Override
        public int getIndex() {
            return this.attributesIterator.index;
        }

        @Override
        public XoXMLStreamReader getReader() {
            return XoXMLStreamReaderImpl.this;
        }
    }

    private final class AttributesIterator
    implements Iterator<Attribute> {
        private final Attribute attribute;
        private int index;

        private AttributesIterator() {
            this.attribute = new AttributeImpl(this);
            this.index = -1;
        }

        @Override
        public boolean hasNext() {
            return this.index + 1 < XoXMLStreamReaderImpl.this.getAttributeCount();
        }

        @Override
        public Attribute next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            ++this.index;
            return this.attribute;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private class ChildElementsIterator
    implements Iterator<XoXMLStreamReader> {
        private final int targetDepth;
        private final boolean mixed;
        private boolean moveToNext;
        private boolean hasMoreEvents;

        private ChildElementsIterator() {
            this.targetDepth = XoXMLStreamReaderImpl.this.depth + 1;
            this.moveToNext = true;
            this.mixed = false;
        }

        private ChildElementsIterator(boolean mixed) {
            this.targetDepth = XoXMLStreamReaderImpl.this.depth + 1;
            this.moveToNext = true;
            this.mixed = mixed;
        }

        @Override
        public boolean hasNext() {
            if (this.moveToNext) {
                this.advanceToNext();
            }
            return this.hasMoreEvents;
        }

        @Override
        public XoXMLStreamReader next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.moveToNext = true;
            return XoXMLStreamReaderImpl.this;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private void advanceToNext() {
            this.moveToNext = false;
            do {
                int event;
                try {
                    if (!XoXMLStreamReaderImpl.this.hasNext()) {
                        this.hasMoreEvents = false;
                        return;
                    }
                    event = XoXMLStreamReaderImpl.this.next();
                }
                catch (XMLStreamException e) {
                    throw new RuntimeXMLStreamException(e);
                }
                if (!this.atNext(event)) continue;
                this.hasMoreEvents = true;
                return;
            } while (XoXMLStreamReaderImpl.this.depth >= this.targetDepth - 1);
            this.hasMoreEvents = false;
        }

        private boolean atNext(int event) {
            if (event == 1) {
                return XoXMLStreamReaderImpl.this.depth == this.targetDepth;
            }
            if (this.mixed && (event == 4 || event == 12)) {
                return XoXMLStreamReaderImpl.this.depth == this.targetDepth - 1;
            }
            return false;
        }
    }
}

