/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval.jsr.metadata;

import jakarta.validation.ConstraintDeclarationException;
import jakarta.validation.ConstraintTarget;
import jakarta.validation.GroupSequence;
import jakarta.validation.ParameterNameProvider;
import jakarta.validation.Valid;
import jakarta.validation.constraintvalidation.ValidationTarget;
import jakarta.validation.groups.ConvertGroup;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.AnnotatedParameterizedType;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.bval.jsr.ApacheValidatorFactory;
import org.apache.bval.jsr.ConstraintAnnotationAttributes;
import org.apache.bval.jsr.groups.GroupConversion;
import org.apache.bval.jsr.metadata.AnnotationBehavior;
import org.apache.bval.jsr.metadata.CompositeBuilder;
import org.apache.bval.jsr.metadata.ContainerElementKey;
import org.apache.bval.jsr.metadata.Meta;
import org.apache.bval.jsr.metadata.MetadataBuilder;
import org.apache.bval.jsr.metadata.Signature;
import org.apache.bval.jsr.util.AnnotationsManager;
import org.apache.bval.jsr.util.Methods;
import org.apache.bval.jsr.util.ToUnmodifiable;
import org.apache.bval.util.Exceptions;
import org.apache.bval.util.Lazy;
import org.apache.bval.util.ObjectUtils;
import org.apache.bval.util.Validate;
import org.apache.bval.util.reflection.Reflection;
import org.apache.commons.weaver.privilizer.Privilizing;

@Privilizing(value={@Privilizing.CallTo(value=Reflection.class)})
public class ReflectionBuilder {
    private final ApacheValidatorFactory validatorFactory;
    private final Lazy<CompositeBuilder> compositeBuilder;

    public ReflectionBuilder(ApacheValidatorFactory validatorFactory) {
        this.validatorFactory = Validate.notNull(validatorFactory, "validatorFactory", new Object[0]);
        this.compositeBuilder = new Lazy<CompositeBuilder>(() -> new CompositeBuilder(this.validatorFactory, x -> AnnotationBehavior.ABSTAIN));
    }

    public <T> MetadataBuilder.ForBean<T> forBean(Class<T> beanClass) {
        return new ForBean(new Meta.ForClass<T>(beanClass));
    }

    private class ForExecutable<E extends Executable>
    implements MetadataBuilder.ForExecutable<E> {
        final Meta<E> meta;
        final BiFunction<ParameterNameProvider, E, List<String>> getParameterNames;

        ForExecutable(Meta<E> meta, BiFunction<ParameterNameProvider, E, List<String>> getParameterNames) {
            this.meta = Validate.notNull(meta, "meta", new Object[0]);
            this.getParameterNames = Validate.notNull(getParameterNames, "getParameterNames", new Object[0]);
        }

        @Override
        public List<MetadataBuilder.ForContainer<Parameter>> getParameters(Meta<E> ignored) {
            Parameter[] parameters = ((Executable)this.meta.getHost()).getParameters();
            if (parameters.length == 0) {
                return Collections.emptyList();
            }
            List<String> parameterNames = this.getParameterNames.apply(ReflectionBuilder.this.validatorFactory.getParameterNameProvider(), (Executable)this.meta.getHost());
            return IntStream.range(0, parameters.length).mapToObj(n -> new ForContainer<Parameter>(new Meta.ForParameter(parameters[n], (String)parameterNames.get(n)))).collect(ToUnmodifiable.list());
        }

        @Override
        public ForContainer<E> getReturnValue(Meta<E> ignored) {
            return new ForContainer<E>(this.meta){

                @Override
                public Annotation[] getDeclaredConstraints(Meta<E> meta) {
                    return ForExecutable.this.getConstraints(ConstraintTarget.RETURN_VALUE);
                }
            };
        }

        @Override
        public MetadataBuilder.ForElement<E> getCrossParameter(Meta<E> ignored) {
            return new ForElement<E>(this.meta){

                @Override
                public Annotation[] getDeclaredConstraints(Meta<E> meta) {
                    return ForExecutable.this.getConstraints(ConstraintTarget.PARAMETERS);
                }
            };
        }

        private Annotation[] getConstraints(ConstraintTarget constraintTarget) {
            return Optional.of(this.getConstraintsByTarget()).map(m -> (List)m.get(constraintTarget)).map(l -> l.toArray(new Annotation[l.size()])).orElse(ObjectUtils.EMPTY_ANNOTATION_ARRAY);
        }

        private Map<ConstraintTarget, List<Annotation>> getConstraintsByTarget() {
            Annotation[] declaredConstraints = AnnotationsManager.getDeclaredConstraints(this.meta);
            if (ObjectUtils.isEmptyArray(declaredConstraints)) {
                return Collections.emptyMap();
            }
            EnumMap<ConstraintTarget, List<Annotation>> result = new EnumMap<ConstraintTarget, List<Annotation>>(ConstraintTarget.class);
            for (Annotation constraint : declaredConstraints) {
                ConstraintTarget target;
                Class<? extends Annotation> constraintType = constraint.annotationType();
                Optional<ConstraintTarget> explicitTarget = Optional.of(ConstraintAnnotationAttributes.VALIDATION_APPLIES_TO.analyze(constraintType)).filter(ConstraintAnnotationAttributes.Worker::isValid).map(w -> (ConstraintTarget)w.read(constraint)).filter(et -> et != ConstraintTarget.IMPLICIT);
                if (explicitTarget.isPresent()) {
                    target = explicitTarget.get();
                } else {
                    Set<ValidationTarget> supportedTargets = ReflectionBuilder.this.validatorFactory.getAnnotationsManager().supportedTargets(constraintType);
                    if (supportedTargets.size() == 1) {
                        ValidationTarget validationTarget = supportedTargets.iterator().next();
                        switch (validationTarget) {
                            case PARAMETERS: {
                                target = ConstraintTarget.PARAMETERS;
                                break;
                            }
                            case ANNOTATED_ELEMENT: {
                                target = ConstraintTarget.RETURN_VALUE;
                                break;
                            }
                            default: {
                                throw Exceptions.create(IllegalStateException::new, "Unknown %s %s for %s", ValidationTarget.class.getSimpleName(), validationTarget, constraintType);
                            }
                        }
                    } else {
                        target = this.impliedConstraintTarget();
                        if (target == null) {
                            Exceptions.raise(ConstraintDeclarationException::new, "Found %d possible %s types for constraint type %s and no explicit assignment via #%s()", supportedTargets.size(), ValidationTarget.class.getSimpleName(), constraintType.getName(), ConstraintAnnotationAttributes.VALIDATION_APPLIES_TO.getAttributeName());
                        }
                    }
                }
                result.computeIfAbsent(target, k -> new ArrayList()).add(constraint);
            }
            return result;
        }

        private ConstraintTarget impliedConstraintTarget() {
            if (((Executable)this.meta.getHost()).getParameterCount() == 0) {
                return ConstraintTarget.RETURN_VALUE;
            }
            if (Void.TYPE.equals(this.meta.getType())) {
                return ConstraintTarget.PARAMETERS;
            }
            return null;
        }
    }

    private class ForContainer<E extends AnnotatedElement>
    extends ForElement<E>
    implements MetadataBuilder.ForContainer<E> {
        ForContainer(Meta<E> meta) {
            super(meta);
        }

        @Override
        public Map<ContainerElementKey, MetadataBuilder.ForContainer<AnnotatedType>> getContainerElementTypes(Meta<E> ignored) {
            AnnotatedType annotatedType = this.meta.getAnnotatedType();
            if (annotatedType instanceof AnnotatedParameterizedType) {
                AnnotatedParameterizedType container = (AnnotatedParameterizedType)annotatedType;
                TreeMap<ContainerElementKey, MetadataBuilder.ForContainer<AnnotatedType>> result = new TreeMap<ContainerElementKey, MetadataBuilder.ForContainer<AnnotatedType>>();
                AnnotatedType[] typeArgs = container.getAnnotatedActualTypeArguments();
                for (int i = 0; i < typeArgs.length; ++i) {
                    ContainerElementKey key = new ContainerElementKey(container, (Integer)i);
                    result.put(key, new ForContainer<AnnotatedType>(new Meta.ForContainerElement(this.meta, key)));
                }
                return result;
            }
            return Collections.emptyMap();
        }

        @Override
        public boolean isCascade(Meta<E> ignored) {
            return AnnotationsManager.isAnnotationDirectlyPresent(this.meta.getHost(), Valid.class);
        }

        @Override
        public Set<GroupConversion> getGroupConversions(Meta<E> ignored) {
            return Stream.of((ConvertGroup[])AnnotationsManager.getDeclaredAnnotationsByType(this.meta.getHost(), ConvertGroup.class)).map(cg -> GroupConversion.from(cg.from()).to(cg.to())).collect(ToUnmodifiable.set());
        }
    }

    private class ForClass<T>
    extends ForElement<Class<T>>
    implements MetadataBuilder.ForClass<T> {
        ForClass(Meta<Class<T>> meta) {
            super(meta);
        }

        @Override
        public List<Class<?>> getGroupSequence(Meta<Class<T>> ignored) {
            GroupSequence groupSequence = AnnotationsManager.getAnnotation(this.meta.getHost(), GroupSequence.class);
            return groupSequence == null ? null : Collections.unmodifiableList(Arrays.asList(groupSequence.value()));
        }
    }

    private abstract class ForElement<E extends AnnotatedElement>
    implements MetadataBuilder.ForElement<E> {
        final Meta<E> meta;

        ForElement(Meta<E> meta) {
            this.meta = Validate.notNull(meta, "meta", new Object[0]);
        }

        @Override
        public Annotation[] getDeclaredConstraints(Meta<E> ignored) {
            return AnnotationsManager.getDeclaredConstraints(this.meta);
        }

        public boolean equals(Object obj) {
            return obj == this || this.getClass().isInstance(obj) && ((ForElement)obj).meta.equals(this.meta);
        }

        public int hashCode() {
            return Objects.hash(this.getClass(), this.meta);
        }
    }

    private class ForBean<T>
    implements MetadataBuilder.ForBean<T> {
        private final Meta<Class<T>> meta;

        ForBean(Meta<Class<T>> meta) {
            this.meta = Validate.notNull(meta, "meta", new Object[0]);
        }

        @Override
        public MetadataBuilder.ForClass<T> getClass(Meta<Class<T>> ignored) {
            return new ForClass<T>(this.meta);
        }

        @Override
        public Map<String, MetadataBuilder.ForContainer<Field>> getFields(Meta<Class<T>> ignored) {
            Field[] declaredFields = Reflection.getDeclaredFields(this.meta.getHost());
            if (declaredFields.length == 0) {
                return Collections.emptyMap();
            }
            return Stream.of(declaredFields).filter(f -> !Modifier.isStatic(f.getModifiers()) && !f.isSynthetic()).collect(Collectors.toMap(Field::getName, f -> new ForContainer<Field>(new Meta.ForField((Field)f))));
        }

        @Override
        public Map<String, MetadataBuilder.ForContainer<Method>> getGetters(Meta<Class<T>> ignored) {
            Method[] declaredMethods = Reflection.getDeclaredMethods(this.meta.getHost());
            if (declaredMethods.length == 0) {
                return Collections.emptyMap();
            }
            HashMap<String, Set> getters = new HashMap<String, Set>();
            for (Method m : declaredMethods) {
                if (!Methods.isGetter(m)) continue;
                getters.computeIfAbsent(Methods.propertyName(m), k -> new LinkedHashSet()).add(m);
            }
            TreeMap<String, MetadataBuilder.ForContainer<Method>> result = new TreeMap<String, MetadataBuilder.ForContainer<Method>>();
            getters.forEach((k, methods) -> {
                CompositeBuilder.ForContainer builder;
                if ("class".equals(k)) {
                    return;
                }
                List delegates = methods.stream().map(g -> new ForContainer<Method>(new Meta.ForMethod((Method)g))).collect(Collectors.toList());
                if (delegates.isEmpty()) {
                    return;
                }
                if (delegates.size() == 1) {
                    builder = (CompositeBuilder.ForContainer)delegates.get(0);
                } else {
                    CompositeBuilder compositeBuilder = ReflectionBuilder.this.compositeBuilder.get();
                    Objects.requireNonNull(compositeBuilder);
                    builder = compositeBuilder.new CompositeBuilder.ForContainer(delegates);
                }
                result.put((String)k, builder);
            });
            return result;
        }

        @Override
        public Map<Signature, MetadataBuilder.ForExecutable<Constructor<? extends T>>> getConstructors(Meta<Class<T>> ignored) {
            Constructor<T>[] declaredConstructors = Reflection.getDeclaredConstructors(this.meta.getHost());
            if (declaredConstructors.length == 0) {
                return Collections.emptyMap();
            }
            return Stream.of(declaredConstructors).collect(Collectors.toMap(Signature::of, c -> new ForExecutable<Constructor>(new Meta.ForConstructor(c), ParameterNameProvider::getParameterNames)));
        }

        @Override
        public Map<Signature, MetadataBuilder.ForExecutable<Method>> getMethods(Meta<Class<T>> ignored) {
            Method[] declaredMethods = Reflection.getDeclaredMethods(this.meta.getHost());
            if (declaredMethods.length == 0) {
                return Collections.emptyMap();
            }
            HashMap<Signature, Set> methodsBySignature = new HashMap<Signature, Set>();
            for (Method m : declaredMethods) {
                if (Modifier.isStatic(m.getModifiers())) continue;
                methodsBySignature.computeIfAbsent(Signature.of(m), k -> new LinkedHashSet()).add(m);
            }
            TreeMap<Signature, MetadataBuilder.ForExecutable<Method>> result = new TreeMap<Signature, MetadataBuilder.ForExecutable<Method>>();
            methodsBySignature.forEach((sig, methods) -> {
                CompositeBuilder.ForExecutable builder;
                List delegates = methods.stream().map(g -> new ForExecutable<Method>(new Meta.ForMethod((Method)g), ParameterNameProvider::getParameterNames)).collect(Collectors.toList());
                if (delegates.isEmpty()) {
                    return;
                }
                if (delegates.size() == 1) {
                    builder = (CompositeBuilder.ForExecutable)delegates.get(0);
                } else {
                    CompositeBuilder compositeBuilder = ReflectionBuilder.this.compositeBuilder.get();
                    Objects.requireNonNull(compositeBuilder);
                    builder = compositeBuilder.new CompositeBuilder.ForExecutable(delegates, ParameterNameProvider::getParameterNames);
                }
                result.put((Signature)sig, builder);
            });
            return result;
        }
    }
}

