/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.runtime.io.media;

import io.smallrye.openapi.api.models.media.DiscriminatorImpl;
import io.smallrye.openapi.runtime.io.IOContext;
import io.smallrye.openapi.runtime.io.IoLogging;
import io.smallrye.openapi.runtime.io.ModelIO;
import io.smallrye.openapi.runtime.io.Names;
import io.smallrye.openapi.runtime.io.schema.SchemaFactory;
import io.smallrye.openapi.runtime.util.ModelUtil;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import org.eclipse.microprofile.openapi.models.media.Discriminator;
import org.eclipse.microprofile.openapi.models.media.Schema;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.Type;

public class DiscriminatorIO<V, A extends V, O extends V, AB, OB>
extends ModelIO<Discriminator, V, A, O, AB, OB> {
    private static final String PROP_MAPPING = "mapping";
    private static final String PROP_PROPERTY_NAME = "propertyName";

    public DiscriminatorIO(IOContext<V, A, O, AB, OB> context) {
        super(context, Names.DISCRIMINATOR_MAPPING, Names.create(Discriminator.class));
    }

    @Override
    public Discriminator read(AnnotationInstance annotation) {
        IoLogging.logger.singleAnnotationAs("@Schema", "Discriminator");
        String propertyName = (String)this.value(annotation, "discriminatorProperty");
        AnnotationInstance[] mapping = (AnnotationInstance[])this.value(annotation, "discriminatorMapping");
        if (propertyName == null && mapping == null) {
            return null;
        }
        DiscriminatorImpl discriminator = new DiscriminatorImpl();
        if (propertyName != null) {
            discriminator.setPropertyName(propertyName);
        }
        if (mapping != null) {
            IoLogging.logger.annotationsList("@DiscriminatorMapping");
            Arrays.stream(mapping).map(this::readMapping).forEach(e -> discriminator.addMapping((String)e.getKey(), (String)e.getValue()));
        }
        return discriminator;
    }

    private Map.Entry<String, String> readMapping(AnnotationInstance mapping) {
        Schema schema;
        String propertyValue = (String)this.value(mapping, "value");
        Type schemaType = (Type)this.value(mapping, "schema");
        String schemaRef = schemaType != null ? ((schema = SchemaFactory.typeToSchema(this.scannerContext(), schemaType)) != null ? schema.getRef() : null) : null;
        if (propertyValue == null && schemaRef != null) {
            propertyValue = ModelUtil.nameFromRef(schemaRef);
        }
        return DiscriminatorIO.entry(propertyValue, schemaRef);
    }

    @Override
    public Discriminator readObject(O node) {
        DiscriminatorImpl discriminator = new DiscriminatorImpl();
        discriminator.setPropertyName(this.jsonIO().getString(node, PROP_PROPERTY_NAME));
        discriminator.setMapping(this.jsonIO().getObject(node, PROP_MAPPING).map(this.jsonIO()::properties).map(properties -> properties.stream().map(entry -> DiscriminatorIO.entry((String)entry.getKey(), this.jsonIO().asString(entry.getValue()))).collect(DiscriminatorIO.toLinkedMap())).orElse(null));
        return discriminator;
    }

    @Override
    public Optional<O> write(Discriminator model) {
        return this.optionalJsonObject(model).map(node -> {
            this.setIfPresent(node, PROP_PROPERTY_NAME, this.jsonIO().toJson(model.getPropertyName()));
            this.setIfPresent(node, PROP_MAPPING, this.jsonIO().toJson(model.getMapping()));
            return node;
        }).map(this.jsonIO()::buildObject);
    }
}

