/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.utils;

import java.util.EnumMap;
import java.util.function.Function;

public class EnumUtil {
    public static String toMetricName(Enum type) {
        return type.name().toLowerCase().replace('_', '-');
    }

    public static <T extends Enum<T>, U> EnumMap<T, U> toEnumMap(Class<T> klass, Function<? super T, ? extends U> mapper) {
        EnumMap<T, U> map = new EnumMap<T, U>(klass);
        for (Enum elem : (Enum[])klass.getEnumConstants()) {
            map.put((T)elem, mapper.apply(elem));
        }
        return map;
    }
}

