/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.request.logging;

import ch.qos.logback.access.common.spi.AccessEvent;
import ch.qos.logback.access.common.spi.IAccessEvent;
import ch.qos.logback.access.common.spi.ServerAdapter;
import ch.qos.logback.access.jetty.JettyServerAdapter;
import ch.qos.logback.access.jetty.RequestLogImpl;
import ch.qos.logback.access.jetty.RequestWrapper;
import ch.qos.logback.access.jetty.ResponseWrapper;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.spi.FilterReply;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;

public class LogbackAccessRequestLog
extends RequestLogImpl {
    public void configure() {
        this.setName("LogbackAccessRequestLog");
    }

    private static Map<String, String> buildHeaderMap(HttpFields headers) {
        TreeMap<String, String> headerMap = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        for (HttpField f : headers) {
            String existing = (String)headerMap.get(f.getName());
            String value = existing == null ? f.getValue() : existing + "," + f.getValue();
            headerMap.put(f.getName(), value);
        }
        return headerMap;
    }

    public void log(final Request jettyRequest, final Response jettyResponse) {
        RequestWrapper httpServletRequest = new RequestWrapper(jettyRequest){

            public Map<String, String> buildRequestHeaderMap() {
                return LogbackAccessRequestLog.buildHeaderMap(jettyRequest.getHeaders());
            }
        };
        ResponseWrapper httpServletResponse = new ResponseWrapper(jettyResponse);
        JettyServerAdapter adapter = new JettyServerAdapter(jettyRequest, jettyResponse){

            public Map<String, String> buildResponseHeaderMap() {
                return LogbackAccessRequestLog.buildHeaderMap((HttpFields)jettyResponse.getHeaders());
            }
        };
        AccessEvent accessEvent = new AccessEvent((Context)this, (HttpServletRequest)httpServletRequest, (HttpServletResponse)httpServletResponse, (ServerAdapter)adapter);
        if (this.getFilterChainDecision((IAccessEvent)accessEvent) == FilterReply.DENY) {
            return;
        }
        this.appendLoopOnAppenders((IAccessEvent)accessEvent);
    }

    private void appendLoopOnAppenders(IAccessEvent iAccessEvent) {
        Iterator appenderIterator = this.iteratorForAppenders();
        while (appenderIterator.hasNext()) {
            ((Appender)appenderIterator.next()).doAppend((Object)iAccessEvent);
        }
    }
}

