/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.fetcher.cilium.handler;

import com.google.protobuf.Struct;
import com.google.protobuf.Value;
import io.cilium.api.flow.Endpoint;
import io.vavr.Tuple;
import lombok.Generated;
import org.apache.skywalking.oap.server.library.util.FieldsHelper;

public class ServiceMetadata {
    private String serviceName;
    private String serviceInstanceName;

    public ServiceMetadata(Endpoint endpoint) {
        FieldsHelper.forClass(this.getClass()).inflate(this.parseEndpointToStruct(endpoint), (Object)this);
    }

    private Struct parseEndpointToStruct(Endpoint endpoint) {
        Struct.Builder builder = Struct.newBuilder();
        Struct.Builder labelsStruct = Struct.newBuilder();
        endpoint.getLabelsList().stream().map(label -> label.split("=", 2)).forEach(split -> {
            if (((String[])split).length == 1) {
                this.addingLabel(labelsStruct, split[0], "");
                return;
            }
            this.addingLabel(labelsStruct, split[0], split[1]);
        });
        builder.putFields("LABELS", Value.newBuilder().setStructValue(labelsStruct.build()).build());
        Struct.Builder workloadsStruct = Struct.newBuilder();
        endpoint.getWorkloadsList().stream().map(workload -> Tuple.of((Object)workload.getKind(), (Object)workload.getName())).forEach(split -> workloadsStruct.putFields((String)split._1, Value.newBuilder().setStringValue((String)split._2).build()));
        builder.putFields("WORKLOADS", Value.newBuilder().setStructValue(workloadsStruct.build()).build());
        builder.putFields("NAMESPACE", Value.newBuilder().setStringValue(endpoint.getNamespace()).build());
        builder.putFields("NAME", Value.newBuilder().setStringValue(endpoint.getPodName()).build());
        return builder.build();
    }

    private void addingLabel(Struct.Builder builder, String key, String value) {
        Value val = Value.newBuilder().setStringValue(value).build();
        builder.putFields(key, val);
        if (key.indexOf("k8s:") == 0) {
            builder.putFields(key.substring(4), val);
        }
    }

    @Generated
    public String getServiceName() {
        return this.serviceName;
    }

    @Generated
    public String getServiceInstanceName() {
        return this.serviceInstanceName;
    }

    @Generated
    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    @Generated
    public void setServiceInstanceName(String serviceInstanceName) {
        this.serviceInstanceName = serviceInstanceName;
    }

    @Generated
    public String toString() {
        return "ServiceMetadata(serviceName=" + this.getServiceName() + ", serviceInstanceName=" + this.getServiceInstanceName() + ")";
    }

    @Generated
    public ServiceMetadata() {
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ServiceMetadata)) {
            return false;
        }
        ServiceMetadata other = (ServiceMetadata)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$serviceName = this.getServiceName();
        String other$serviceName = other.getServiceName();
        if (this$serviceName == null ? other$serviceName != null : !this$serviceName.equals(other$serviceName)) {
            return false;
        }
        String this$serviceInstanceName = this.getServiceInstanceName();
        String other$serviceInstanceName = other.getServiceInstanceName();
        return !(this$serviceInstanceName == null ? other$serviceInstanceName != null : !this$serviceInstanceName.equals(other$serviceInstanceName));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ServiceMetadata;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $serviceName = this.getServiceName();
        result = result * 59 + ($serviceName == null ? 43 : $serviceName.hashCode());
        String $serviceInstanceName = this.getServiceInstanceName();
        result = result * 59 + ($serviceInstanceName == null ? 43 : $serviceInstanceName.hashCode());
        return result;
    }
}

