/*
 * Decompiled with CFR 0.152.
 */
package graphql.scalars.locale;

import graphql.Internal;
import graphql.language.StringValue;
import graphql.language.Value;
import graphql.scalars.util.Kit;
import graphql.schema.Coercing;
import graphql.schema.CoercingParseLiteralException;
import graphql.schema.CoercingParseValueException;
import graphql.schema.CoercingSerializeException;
import graphql.schema.GraphQLScalarType;
import java.util.Locale;

@Internal
public final class LocaleScalar {
    public static final GraphQLScalarType INSTANCE;

    private LocaleScalar() {
    }

    static {
        Coercing<Locale, String> coercing = new Coercing<Locale, String>(){

            public String serialize(Object input) throws CoercingSerializeException {
                if (input instanceof String) {
                    try {
                        return Locale.forLanguageTag((String)input).toLanguageTag();
                    }
                    catch (Exception e) {
                        throw new CoercingSerializeException("Expected a valid language tag string but was but was " + Kit.typeName(input));
                    }
                }
                if (input instanceof Locale) {
                    return ((Locale)input).toLanguageTag();
                }
                throw new CoercingSerializeException("Expected a 'java.util.Locale' object but was " + Kit.typeName(input));
            }

            public Locale parseValue(Object input) throws CoercingParseValueException {
                if (input instanceof String) {
                    try {
                        return Locale.forLanguageTag(input.toString());
                    }
                    catch (Exception e) {
                        throw new CoercingParseValueException("Unable to parse value to 'java.util.Locale' because of: " + e.getMessage());
                    }
                }
                if (input instanceof Locale) {
                    return (Locale)input;
                }
                throw new CoercingParseValueException("Expected a 'java.lang.String' object but was " + Kit.typeName(input));
            }

            public Locale parseLiteral(Object input) throws CoercingParseLiteralException {
                if (input instanceof StringValue) {
                    return Locale.forLanguageTag(((StringValue)input).getValue());
                }
                throw new CoercingParseLiteralException("Expected a 'java.lang.String' object but was " + Kit.typeName(input));
            }

            public Value<?> valueToLiteral(Object input) {
                String s = this.serialize(input);
                return StringValue.newStringValue((String)s).build();
            }
        };
        INSTANCE = GraphQLScalarType.newScalar().name("Locale").description("A IETF BCP 47 language tag").coercing((Coercing)coercing).build();
    }
}

